/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.remote.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.CommandLauncherManager;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.remote.core.RemoteProcessClosure;
import org.eclipse.cdt.remote.internal.core.Activator;
import org.eclipse.cdt.remote.internal.core.messages.Messages;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.core.IRemoteResource;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.RemoteProcessAdapter;

public class RemoteCommandLauncher
implements ICommandLauncher {
    private static final String CYGWIN_PREFIX = "cygdrive";
    private boolean usingLocalLauncher = false;
    private ICommandLauncher fLocalLauncher;
    private boolean fShowCommand;
    private String[] fCommandArgs;
    private IRemoteConnection fConnection;
    private IRemoteProcess fRemoteProcess;
    private final Properties fEnvironment = new Properties();
    private static final long DELAY = 50L;

    public static String makeRemote(String local, IRemoteResource remote) {
        return RemoteCommandLauncher.makeRemote((IPath)new Path(local), remote).toString();
    }

    public static IPath makeRemote(IPath localPath, IRemoteResource remote) {
        IPath relativePath;
        if (!localPath.isAbsolute()) {
            return localPath;
        }
        IPath remoteLocation = remote.getResource().getLocation();
        Path remotePath = new Path(remote.getActiveLocationURI().getPath());
        if (remoteLocation.getDevice() != null && localPath.getDevice() == null) {
            boolean isCygwin = localPath.segment(0).equals(CYGWIN_PREFIX);
            remoteLocation = new Path(RemoteCommandLauncher.getPathString(remoteLocation, isCygwin));
            remotePath = new Path(RemoteCommandLauncher.getPathString((IPath)remotePath, isCygwin));
        }
        if (!(relativePath = localPath.makeRelativeTo(remoteLocation)).isEmpty()) {
            remotePath = remotePath.append(relativePath);
        }
        return remotePath;
    }

    private static String getPathString(IPath path, boolean isCygwin) {
        String s = path.toString();
        s = isCygwin ? s.replaceAll("^([a-zA-Z]):", "/cygdrive/$1") : s.replaceAll("^([a-zA-Z]):", "/$1");
        return s;
    }

    public RemoteCommandLauncher() {
        this.fLocalLauncher = new CommandLauncher();
    }

    public RemoteCommandLauncher(ICommandLauncher localLauncher) {
        this.fLocalLauncher = localLauncher;
    }

    private String[] constructCommandArray(String command, String[] commandArgs, IRemoteResource remote) {
        String[] args = new String[1 + commandArgs.length];
        args[0] = RemoteCommandLauncher.makeRemote(command, remote);
        int i = 0;
        while (i < commandArgs.length) {
            args[i + 1] = RemoteCommandLauncher.makeRemote(commandArgs[i], remote);
            ++i;
        }
        return args;
    }

    public Process execute(IPath commandPath, String[] args, String[] env, IPath workingDirectory, IProgressMonitor monitor) throws CoreException {
        IRemoteResource remRes;
        ICommandLauncher localLauncher = CommandLauncherManager.getInstance().getCommandLauncher(this.getProject());
        localLauncher.setProject(this.getProject());
        localLauncher.setErrorMessage(this.getErrorMessage());
        this.usingLocalLauncher = false;
        if (this.fLocalLauncher == null) {
            this.fLocalLauncher = localLauncher;
        }
        if (this.getProject() != null && (remRes = (IRemoteResource)this.getProject().getAdapter(IRemoteResource.class)) != null) {
            URI uri = remRes.getActiveLocationURI();
            IRemoteServicesManager remoteServicesManager = Activator.getService(IRemoteServicesManager.class);
            IRemoteConnectionType connectionType = remoteServicesManager.getConnectionType(uri);
            if (connectionType != null && !connectionType.getScheme().equals("file")) {
                this.fConnection = connectionType.getConnection(uri);
                if (this.fConnection != null) {
                    this.parseEnvironment(env);
                    this.fCommandArgs = this.constructCommandArray(commandPath.toString(), args, remRes);
                    IRemoteProcessService processService = (IRemoteProcessService)this.fConnection.getService(IRemoteProcessService.class);
                    IRemoteProcessBuilder processBuilder = processService.getProcessBuilder(this.fCommandArgs);
                    if (workingDirectory != null) {
                        String remoteWorkingPath = RemoteCommandLauncher.makeRemote(workingDirectory.toString(), remRes);
                        IRemoteFileService fileManager = (IRemoteFileService)this.fConnection.getService(IRemoteFileService.class);
                        IFileStore wd = fileManager.getResource(remoteWorkingPath);
                        processBuilder.directory(wd);
                    }
                    Map processEnv = processBuilder.environment();
                    for (String key : this.fEnvironment.stringPropertyNames()) {
                        processEnv.put(key, this.fEnvironment.getProperty(key));
                    }
                    try {
                        this.fRemoteProcess = processBuilder.start();
                        return new RemoteProcessAdapter(this.fRemoteProcess);
                    }
                    catch (IOException e) {
                        this.fLocalLauncher.setErrorMessage(e.getMessage());
                        return null;
                    }
                }
            }
        }
        this.usingLocalLauncher = true;
        return this.fLocalLauncher.execute(commandPath, args, env, workingDirectory, monitor);
    }

    public String[] getCommandArgs() {
        if (this.usingLocalLauncher) {
            return this.fLocalLauncher.getCommandArgs();
        }
        return this.fCommandArgs;
    }

    public String getCommandLine() {
        if (this.usingLocalLauncher) {
            return this.fLocalLauncher.getCommandLine();
        }
        return this.getCommandLine(this.fCommandArgs);
    }

    protected String getCommandLine(String[] commandArgs) {
        return this.getCommandLineQuoted(commandArgs, false);
    }

    private String getCommandLineQuoted(String[] commandArgs, boolean quote) {
        String nl = System.getProperty("line.separator", "\n");
        if (this.fConnection != null) {
            nl = this.fConnection.getProperty("line.separator");
        }
        StringBuilder buf = new StringBuilder();
        if (commandArgs != null) {
            String[] stringArray = commandArgs;
            int n = commandArgs.length;
            int n2 = 0;
            while (n2 < n) {
                Object commandArg = stringArray[n2];
                if (quote && (((String)commandArg).contains(" ") || ((String)commandArg).contains("\"") || ((String)commandArg).contains("\\"))) {
                    commandArg = "\"" + ((String)commandArg).replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"") + "\"";
                }
                buf.append((String)commandArg);
                buf.append(' ');
                ++n2;
            }
            buf.append(nl);
        }
        return buf.toString();
    }

    public Properties getEnvironment() {
        if (this.usingLocalLauncher) {
            return this.fLocalLauncher.getEnvironment();
        }
        return this.fEnvironment;
    }

    public String getErrorMessage() {
        return this.fLocalLauncher.getErrorMessage();
    }

    public IProject getProject() {
        return this.fLocalLauncher.getProject();
    }

    private void parseEnvironment(String[] env) {
        if (env != null) {
            this.fEnvironment.clear();
            String[] stringArray = env;
            int n = env.length;
            int n2 = 0;
            while (n2 < n) {
                String envStr = stringArray[n2];
                int pos = envStr.indexOf(61);
                if (pos < 0) {
                    pos = envStr.length();
                }
                String key = envStr.substring(0, pos);
                String value = envStr.substring(pos + 1);
                this.fEnvironment.put(key, value);
                ++n2;
            }
        }
    }

    private void printCommandLine(OutputStream os) {
        if (os != null) {
            try {
                os.write(this.getCommandLineQuoted(this.getCommandArgs(), true).getBytes());
                os.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setErrorMessage(String error) {
        this.fLocalLauncher.setErrorMessage(error);
    }

    public void setProject(IProject project) {
        this.fLocalLauncher.setProject(project);
    }

    public void showCommand(boolean show) {
        this.fLocalLauncher.showCommand(show);
        this.fShowCommand = show;
    }

    public int waitAndRead(OutputStream out, OutputStream err) {
        if (this.usingLocalLauncher) {
            return this.fLocalLauncher.waitAndRead(out, err);
        }
        if (this.fShowCommand) {
            this.printCommandLine(out);
        }
        if (this.fRemoteProcess == null) {
            return -1;
        }
        RemoteProcessClosure closure = new RemoteProcessClosure(this.fRemoteProcess, out, err);
        closure.runBlocking();
        return 0;
    }

    public int waitAndRead(OutputStream out, OutputStream err, IProgressMonitor monitor) {
        if (this.usingLocalLauncher) {
            return this.fLocalLauncher.waitAndRead(out, err, monitor);
        }
        if (this.fShowCommand) {
            this.printCommandLine(out);
        }
        if (this.fRemoteProcess == null) {
            return -1;
        }
        RemoteProcessClosure closure = new RemoteProcessClosure(this.fRemoteProcess, out, err);
        closure.runNonBlocking();
        while (!monitor.isCanceled() && closure.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int state = 0;
        if (monitor.isCanceled()) {
            closure.terminate();
            state = 1;
            this.setErrorMessage(Messages.RemoteCommandLauncher_Command_canceled);
        }
        try {
            this.fRemoteProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return state;
    }
}

