/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui;

import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class SWTUtil {
    public static final String OVERRIDE_ENABLEMENT = "override.enable";

    public static void recurseEnable(boolean enable, Control control) {
        Object data = control.getData();
        boolean en = enable;
        if (data != null && data instanceof OverrideEnablement) {
            en = ((OverrideEnablement)data).override(en);
        } else {
            data = control.getData(OVERRIDE_ENABLEMENT);
            if (data != null && data instanceof OverrideEnablement) {
                en = ((OverrideEnablement)data).override(en);
            }
        }
        control.setEnabled(en);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                SWTUtil.recurseEnable(en, child);
                ++n2;
            }
        } else if (control instanceof Label) {
            Color color = enable ? control.getDisplay().getSystemColor(2) : JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
            control.setForeground(color);
        }
    }

    public static void setHorizontalGrabbing(Control control) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).grabExcessHorizontalSpace = true;
        }
    }

    public static int getButtonWidthHint(Button button) {
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static interface OverrideEnablement {
        public boolean override(boolean var1);
    }
}

