/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.context.ui;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.wikitext.context.ui.WikiTextContextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.IFoldingStructure;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineItem;
import org.eclipse.ui.IEditorPart;

class ActiveFoldingListener
extends AbstractContextListener {
    private final IEditorPart part;
    private final IFoldingStructure foldingStructure;
    private IPropertyChangeListener preferenceListener = event -> {
        if ("org.eclipse.mylyn.context.ui.editor.folding.enabled".equals(event.getProperty())) {
            Object newValue = event.getNewValue();
            this.foldingEnabled = Boolean.TRUE.toString().equals(newValue.toString());
            this.updateFolding(false);
        }
    };
    private boolean foldingEnabled;
    private final AbstractContextStructureBridge bridge;
    private final IPreferenceStore preferences;

    public ActiveFoldingListener(IEditorPart part, IFoldingStructure foldingStructure) {
        this.part = part;
        this.foldingStructure = foldingStructure;
        this.bridge = ContextCore.getStructureBridge((String)"org.eclipse.mylyn.wikitext");
        ContextCore.getContextManager().addListener((AbstractContextListener)this);
        this.preferences = WikiTextContextUiPlugin.getDefault().getPreferenceStore();
        this.preferences.addPropertyChangeListener(this.preferenceListener);
        this.foldingEnabled = this.preferences.getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled");
        this.updateFolding(false);
    }

    private void updateFolding(boolean elementsDeleted) {
        if (!this.foldingStructure.isFoldingEnabled()) {
            return;
        }
        if (!this.foldingEnabled || !ContextCore.getContextManager().isContextActive()) {
            this.foldingStructure.expandAll();
        } else {
            OutlineItem outline = (OutlineItem)this.part.getAdapter(OutlineItem.class);
            if (outline != null) {
                ArrayList toExpand = new ArrayList();
                outline.accept(item -> {
                    String identifier = this.bridge.getHandleIdentifier((Object)item);
                    IInteractionElement element = ContextCore.getContextManager().getElement(identifier);
                    if (element != null && element.getInterest().isInteresting()) {
                        toExpand.add(item);
                    }
                    return true;
                });
                if (toExpand.isEmpty()) {
                    this.foldingStructure.collapseAll(elementsDeleted);
                } else {
                    this.foldingStructure.expandElementsExclusive(toExpand, elementsDeleted);
                }
            }
        }
    }

    public void contextChanged(ContextChangeEvent event) {
        switch (event.getEventKind()) {
            case ACTIVATED: {
                if (!this.foldingStructure.isFoldingEnabled()) break;
                this.updateFolding(false);
                break;
            }
            case DEACTIVATED: {
                if (!this.foldingStructure.isFoldingEnabled()) break;
                this.foldingStructure.expandAll();
                break;
            }
            case CLEARED: {
                if (!event.isActiveContext() || !this.foldingStructure.isFoldingEnabled()) break;
                if (!this.foldingEnabled || !ContextCore.getContextManager().isContextActive()) {
                    this.foldingStructure.expandAll();
                    break;
                }
                this.foldingStructure.collapseAll(true);
                break;
            }
            case INTEREST_CHANGED: {
                if (!this.foldingStructure.isFoldingEnabled()) break;
                this.updateFolding(false);
                break;
            }
            case ELEMENTS_DELETED: {
                if (!this.foldingStructure.isFoldingEnabled()) break;
                this.updateFolding(true);
                break;
            }
        }
    }

    public void dispose() {
        if (this.preferenceListener != null) {
            this.preferences.removePropertyChangeListener(this.preferenceListener);
            this.preferenceListener = null;
        }
        ContextCore.getContextManager().removeListener((AbstractContextListener)this);
    }
}

