/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.util.search;

import java.nio.file.Path;
import java.util.Objects;
import java.util.StringJoiner;
import org.eclipse.scout.sdk.core.util.Ensure;

public class FileRange {
    private final Path m_file;
    private final Path m_module;
    private final CharSequence m_textOfRange;
    private final int m_start;
    private final int m_end;

    public FileRange(Path file, Path modulePath, CharSequence textOfRange, int start, int end) {
        this.m_file = (Path)Ensure.notNull((Object)file);
        this.m_module = (Path)Ensure.notNull((Object)modulePath);
        this.m_textOfRange = (CharSequence)Ensure.notNull((Object)textOfRange);
        this.m_start = start;
        this.m_end = end;
    }

    public Path file() {
        return this.m_file;
    }

    public Path module() {
        return this.m_module;
    }

    public CharSequence text() {
        return this.m_textOfRange;
    }

    public int start() {
        return this.m_start;
    }

    public int end() {
        return this.m_end;
    }

    public int length() {
        return this.m_end - this.m_start;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileRange fileRange = (FileRange)o;
        return this.m_start == fileRange.m_start && this.m_end == fileRange.m_end && this.m_textOfRange.equals(fileRange.m_textOfRange) && this.m_file.equals(fileRange.m_file);
    }

    public int hashCode() {
        return Objects.hash(this.m_file, this.m_textOfRange, this.m_start, this.m_end);
    }

    public String toString() {
        return new StringJoiner(", ", FileRange.class.getSimpleName() + " [", "]").add("file=" + String.valueOf(this.m_file)).add("text=" + String.valueOf(this.m_textOfRange)).add("start=" + this.m_start).add("end=" + this.m_end).toString();
    }
}

