/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.xml.internal;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.wildwebdeveloper.xml.internal.Activator;
import org.eclipse.wildwebdeveloper.xml.internal.XMLExtensionRegistry;
import org.eclipse.wildwebdeveloper.xml.internal.ui.preferences.XMLPreferenceServerConstants;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class XMLLanguageServer
extends ProcessStreamConnectionProvider {
    private static final String XML_LANGUAGE_SERVER_ID = "org.eclipse.wildwebdeveloper.xml";
    private static final String SETTINGS_KEY = "settings";
    private static final String XML_KEY = "xml";
    private static final String EXTENDED_CLIENT_CAPABILITIES_KEY = "extendedClientCapabilities";
    private static final String CODE_LENS_KEY = "codeLens";
    private static final String CODE_LENS_KIND_KEY = "codeLensKind";
    private static final String VALUE_SET_KEY = "valueSet";
    private static final String BINDING_WIZARD_SUPPORT_KEY = "bindingWizardSupport";
    private static final XMLExtensionRegistry extensionJarRegistry = new XMLExtensionRegistry();
    private static final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private static final LanguageServersRegistry.LanguageServerDefinition lemminxDefinition = LanguageServersRegistry.getInstance().getDefinition("org.eclipse.wildwebdeveloper.xml");
    private final IPropertyChangeListener psListener = event -> XMLPreferenceServerConstants.getLemminxPreference(event).ifPresent(pref -> {
        Map<String, Object> config = this.mergeCustomInitializationOptions(extensionJarRegistry.getInitiatizationOptions());
        DidChangeConfigurationParams params = new DidChangeConfigurationParams(Collections.singletonMap(XML_KEY, ((Map)config.get(SETTINGS_KEY)).get(XML_KEY)));
        ((LanguageServers.LanguageServerProjectExecutor)LanguageServers.forProject(null).withPreferredServer(lemminxDefinition)).excludeInactive().collectAll((w, ls) -> CompletableFuture.completedFuture(ls)).thenAccept(lss -> lss.stream().forEach(ls -> ls.getWorkspaceService().didChangeConfiguration(params)));
    });
    private final String logLevelString;

    public XMLLanguageServer() {
        ArrayList<Object> commands = new ArrayList<Object>();
        ArrayList<String> jarPaths = new ArrayList<String>();
        commands.add(this.computeJavaPath());
        commands.addAll(this.getProxySettings());
        String debugPortString = System.getProperty(((Object)((Object)this)).getClass().getName() + ".debugPort");
        if (debugPortString != null) {
            commands.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + debugPortString);
        }
        this.logLevelString = System.getProperty(((Object)((Object)this)).getClass().getName() + ".log.level");
        if (this.logLevelString != null) {
            commands.add("-Dlog.level=" + this.logLevelString);
        }
        commands.add("-Duser.name=" + System.getProperty("user.name"));
        commands.add("-Duser.home=" + System.getProperty("user.home"));
        commands.add("-classpath");
        try {
            Bundle lemminxBundle = this.getLemminxBundle();
            File file = (File)FileLocator.getBundleFileLocation((Bundle)lemminxBundle).orElseThrow(() -> new IllegalStateException("Can't determine lemminx file location"));
            List<String> extensionJarPaths = this.getExtensionJarPaths();
            String uberJarPath = file.getAbsolutePath();
            jarPaths.add(uberJarPath);
            jarPaths.addAll(extensionJarPaths);
            commands.add(String.join((CharSequence)System.getProperty("path.separator"), jarPaths));
            String mainClass = (String)lemminxBundle.getHeaders().get("Main-Class");
            commands.add(mainClass);
            this.setCommands(commands);
            this.setWorkingDirectory(System.getProperty("user.dir"));
        }
        catch (RuntimeException e) {
            ILog.get().error(e.getMessage(), (Throwable)e);
        }
    }

    private Bundle getLemminxBundle() {
        Bundle self = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        BundleWiring wiring = (BundleWiring)self.adapt(BundleWiring.class);
        List wires = wiring.getRequiredWires("osgi.wiring.bundle");
        for (BundleWire bundleWire : wires) {
            Bundle bundle = bundleWire.getProvider().getBundle();
            if (!bundle.getSymbolicName().equals("org.eclipse.lemminx.uber-jar")) continue;
            return bundle;
        }
        throw new IllegalStateException("can't find the lemminx bundle!");
    }

    private Collection<? extends String> getProxySettings() {
        IProxyService service;
        HashMap<Object, String> res = new HashMap<Object, String>();
        for (Map.Entry<Object, Object> entry2 : System.getProperties().entrySet()) {
            Object object = entry2.getKey();
            if (!(object instanceof String)) continue;
            String property = (String)object;
            Object object2 = entry2.getValue();
            if (!(object2 instanceof String)) continue;
            String value = (String)object2;
            if (!property.toLowerCase().contains("proxy") && !property.toLowerCase().contains("proxies")) continue;
            res.put(property, value);
        }
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceRef = bundleContext.getServiceReference(IProxyService.class);
        if (serviceRef != null && (service = (IProxyService)bundleContext.getService(serviceRef)) != null) {
            IProxyData[] iProxyDataArray = service.getProxyData();
            int n = iProxyDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProxyData data = iProxyDataArray[n2];
                if (data.getHost() != null) {
                    res.put(data.getType().toLowerCase() + ".proxyHost", data.getHost());
                    res.put(data.getType().toLowerCase() + ".proxyPort", Integer.toString(data.getPort()));
                }
                if (data.getUserId() != null) {
                    res.put(data.getType().toLowerCase() + ".proxyUser", data.getUserId());
                }
                if (data.getPassword() != null) {
                    res.put(data.getType().toLowerCase() + ".proxyPassword", data.getPassword());
                }
                ++n2;
            }
            String nonProxiedHosts = String.join((CharSequence)"|", service.getNonProxiedHosts());
            if (!nonProxiedHosts.isEmpty()) {
                res.put("http.nonProxyHosts", nonProxiedHosts);
                res.put("https.nonProxyHosts", nonProxiedHosts);
            }
        }
        return res.entrySet().stream().map(entry -> "-D" + (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.toSet());
    }

    private List<String> getExtensionJarPaths() {
        List<String> extensionJarPaths = extensionJarRegistry.getXMLExtensionJars();
        extensionJarPaths.addAll(extensionJarRegistry.getXMLLSClassPathExtensions());
        return extensionJarPaths;
    }

    private String computeJavaPath() {
        return new File(System.getProperty("java.home"), "bin/java" + (Platform.getOS().equals("win32") ? ".exe" : "")).getAbsolutePath();
    }

    public Object getInitializationOptions(URI rootUri) {
        HashMap<String, Object> initializationOptions = new HashMap<String, Object>();
        Map<String, Object> settings = this.mergeCustomInitializationOptions(extensionJarRegistry.getInitiatizationOptions());
        initializationOptions.put(SETTINGS_KEY, settings.get(SETTINGS_KEY));
        Object extendedClientCapabilities = XMLLanguageServer.createExtendedClientCapabilities();
        initializationOptions.put(EXTENDED_CLIENT_CAPABILITIES_KEY, extendedClientCapabilities);
        return initializationOptions;
    }

    private static Object createExtendedClientCapabilities() {
        HashMap<String, Serializable> extendedClientCapabilities = new HashMap<String, Serializable>();
        HashMap codeLens = new HashMap();
        extendedClientCapabilities.put(CODE_LENS_KEY, codeLens);
        HashMap<String, List<String>> codeLensKind = new HashMap<String, List<String>>();
        codeLens.put(CODE_LENS_KIND_KEY, codeLensKind);
        List<String> valueSet = Arrays.asList(CodeLensKind.association.name());
        codeLensKind.put(VALUE_SET_KEY, valueSet);
        extendedClientCapabilities.put(BINDING_WIZARD_SUPPORT_KEY, Boolean.TRUE);
        return extendedClientCapabilities;
    }

    private Map<String, Object> mergeCustomInitializationOptions(Map<String, Object> defaults) {
        HashMap<String, Object> xmlOpts = new HashMap<String, Object>(defaults);
        XMLPreferenceServerConstants.storePreferencesToLemminxOptions(store, xmlOpts);
        if (this.logLevelString != null) {
            xmlOpts.put("logs", Map.of("file", new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), ".metadata/lemminx.log").getAbsolutePath()));
        }
        return Map.of(SETTINGS_KEY, Map.of(XML_KEY, xmlOpts));
    }

    public void start() throws IOException {
        super.start();
        store.addPropertyChangeListener(this.psListener);
    }

    public void stop() {
        store.removePropertyChangeListener(this.psListener);
        super.stop();
    }

    public String toString() {
        return "XML Language Server: " + super.toString();
    }

    private static enum CodeLensKind {
        association;

    }
}

