/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelProvider;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.CreateSourceModuleOperation;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.MementoModelElementUtil;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelProviderManager;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ScriptFolderInfo;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.dltk.utils.CorePrinter;

public class ScriptFolder
extends Openable
implements IScriptFolder {
    protected final IPath path;
    private final String elementName;

    protected ScriptFolder(ModelElement parent, IPath path) {
        super(parent);
        this.path = path;
        this.elementName = ScriptFolder.pathToString(path);
    }

    public static String pathToString(IPath path) {
        int segmentCount = path.segmentCount();
        if (segmentCount == 0) {
            return "";
        }
        if (segmentCount == 1) {
            return path.segment(0);
        }
        int resultSize = segmentCount - 1;
        int i = 0;
        while (i < segmentCount) {
            resultSize += path.segment(i).length();
            ++i;
        }
        char[] result = new char[resultSize];
        int index = 0;
        int i2 = 0;
        while (i2 < segmentCount) {
            if (i2 != 0) {
                result[index++] = 47;
            }
            String segment = path.segment(i2);
            segment.getChars(0, segment.length(), result, index);
            index += segment.length();
            ++i2;
        }
        return new String(result);
    }

    public static String pathToString(String[] path) {
        int segmentCount = path.length;
        if (segmentCount == 0) {
            return "";
        }
        if (segmentCount == 1) {
            return path[0];
        }
        int resultSize = segmentCount - 1;
        int i = 0;
        while (i < segmentCount) {
            resultSize += path[i].length();
            ++i;
        }
        char[] result = new char[resultSize];
        int index = 0;
        int i2 = 0;
        while (i2 < segmentCount) {
            if (i2 != 0) {
                result[index++] = 47;
            }
            String segment = path[i2];
            segment.getChars(0, segment.length(), result, index);
            index += segment.length();
            ++i2;
        }
        return new String(result);
    }

    @Override
    protected Object createElementInfo() {
        return new ScriptFolderInfo();
    }

    @Override
    public int getElementType() {
        return 4;
    }

    @Override
    public IPath getPath() {
        IProjectFragment root = this.getProjectFragment();
        if (root.isArchive()) {
            return root.getPath();
        }
        return root.getPath().append(this.path);
    }

    @Override
    public IResource getResource() {
        IProjectFragment root = this.getProjectFragment();
        if (root.isArchive()) {
            return root.getResource();
        }
        if (this.path.segmentCount() == 0) {
            return root.getResource();
        }
        IContainer container = (IContainer)root.getResource();
        if (container != null) {
            return container.getFolder(this.path);
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScriptFolder)) {
            return false;
        }
        ScriptFolder other = (ScriptFolder)o;
        return this.path.equals((Object)other.path) && this.parent.equals(other.parent);
    }

    @Override
    public int hashCode() {
        return Util.combineHashCodes(this.parent.hashCode(), this.path.hashCode());
    }

    @Override
    public boolean exists() {
        return super.exists() && !Util.isExcluded(this);
    }

    public int getKind() throws ModelException {
        return this.getProjectFragment().getKind();
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
        IModelProvider[] providers;
        if (!underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        int kind = this.getKind();
        if (kind == 1 && Util.isExcluded(this)) {
            throw this.newNotPresentException();
        }
        HashSet<ISourceModule> vChildren = new HashSet<ISourceModule>();
        try {
            IProjectFragment root = this.getProjectFragment();
            IResource[] members = ((IContainer)underlyingResource).members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource child = members[i];
                if (child.getType() != 2 && !Util.isExcluded(child, root) && kind == 1 && Util.isValidSourceModule((IModelElement)this, child)) {
                    ISourceModule childElement = this.getSourceModule(child.getName());
                    vChildren.add(childElement);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
        if (kind == 1) {
            ISourceModule[] primarySourceModules = this.getSourceModules(DefaultWorkingCopyOwner.PRIMARY);
            int i = 0;
            int length = primarySourceModules.length;
            while (i < length) {
                ISourceModule primary = primarySourceModules[i];
                vChildren.add(primary);
                ++i;
            }
        }
        ArrayList<IModelElement> childrenSet = new ArrayList<IModelElement>(vChildren);
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this);
        if (toolkit != null && (providers = ModelProviderManager.getProviders(toolkit.getNatureId())) != null) {
            int i = 0;
            while (i < providers.length) {
                providers[i].provideModelChanges(this, childrenSet);
                ++i;
            }
        }
        info.setChildren(childrenSet.toArray(new IModelElement[childrenSet.size()]));
        return true;
    }

    public ISourceModule[] getSourceModules(WorkingCopyOwner owner) {
        ISourceModule[] workingCopies = ModelManager.getModelManager().getWorkingCopies(owner, false);
        if (workingCopies == null) {
            return ModelManager.NO_WORKING_COPY;
        }
        int length = workingCopies.length;
        ISourceModule[] result = new ISourceModule[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            ISourceModule wc = workingCopies[i];
            IResource res = wc.getResource();
            boolean valid = res != null ? Util.isValidSourceModule((IModelElement)this, res) : Util.isValidSourceModule((IModelElement)this, wc.getPath());
            if (this.equals(wc.getParent()) && !Util.isExcluded(wc) && valid) {
                result[index++] = wc;
            }
            ++i;
        }
        if (index != length) {
            ISourceModule[] iSourceModuleArray = result;
            result = new ISourceModule[index];
            System.arraycopy(iSourceModuleArray, 0, result, 0, index);
        }
        return result;
    }

    @Override
    public ISourceModule getSourceModule(String name) {
        IModelProvider[] providers;
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this);
        if (toolkit != null && (providers = ModelProviderManager.getProviders(toolkit.getNatureId())) != null) {
            boolean provides = false;
            int i = 0;
            while (i < providers.length) {
                if (providers[i].isModelChangesProvidedFor(this, name)) {
                    provides = true;
                    break;
                }
                ++i;
            }
            if (provides) {
                try {
                    IModelElement[] children = this.getChildren();
                    IPath fullPath = this.getPath().append(name);
                    int i2 = 0;
                    while (i2 < children.length) {
                        IPath childPath;
                        IModelElement child = children[i2];
                        if (child instanceof IScriptFolder && fullPath.equals((Object)(childPath = child.getPath()))) {
                            return (ISourceModule)child;
                        }
                        ++i2;
                    }
                }
                catch (ModelException e) {
                    DLTKCore.error("Could not obtain model element childrens.", (Throwable)((Object)e));
                }
            }
        }
        return new SourceModule(this, name, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public ISourceModule createSourceModule(String cuName, String contents, boolean force, IProgressMonitor monitor) throws ModelException {
        CreateSourceModuleOperation op = new CreateSourceModuleOperation(this, cuName, contents, force);
        op.runOperation(monitor);
        return new SourceModule(this, cuName, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public final IProjectFragment getProjectFragment() {
        return (IProjectFragment)this.getParent();
    }

    @Override
    protected void toStringName(StringBuilder buffer) {
        String elementName = this.getElementName();
        if (elementName.length() == 0) {
            buffer.append("<default>");
        } else {
            buffer.append(elementName);
        }
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public boolean isRootFolder() {
        return this.path.segmentCount() == 0;
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrint("DLTK Script folder:" + this.getElementName());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + String.valueOf(element));
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    @Override
    public ISourceModule[] getSourceModules() throws ModelException {
        List<IModelElement> list = this.getChildrenOfType(5);
        return list.toArray(new ISourceModule[list.size()]);
    }

    @Override
    public Object[] getForeignResources() throws ModelException {
        if (this.isRootFolder()) {
            return ModelElementInfo.NO_NON_SCRIPT_RESOURCES;
        }
        return ((ScriptFolderInfo)this.getElementInfo()).getForeignResources(this.getResource(), this.getProjectFragment());
    }

    @Override
    public boolean hasSubfolders() throws ModelException {
        IModelElement[] packages = ((IProjectFragment)this.getParent()).getChildren();
        int namesLength = this.path.segmentCount();
        int i = 0;
        int length = packages.length;
        while (i < length) {
            block4: {
                IPath otherNames = null;
                if (packages[i] instanceof ScriptFolder && (otherNames = ((ScriptFolder)packages[i]).path).segmentCount() > namesLength) {
                    int j = 0;
                    while (j < namesLength) {
                        if (this.path.segment(j).equals(otherNames.segment(j))) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '{': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String classFileName = memento.nextToken();
                ModelElement classFile = (ModelElement)((Object)this.getSourceModule(classFileName));
                return classFile.getHandleFromMemento(memento, owner);
            }
            case '}': {
                return MementoModelElementUtil.getHandleFromMemento(memento, this, owner);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '<';
    }

    @Override
    public boolean containsScriptResources() throws ModelException {
        Object elementInfo = this.getElementInfo();
        if (!(elementInfo instanceof ScriptFolderInfo)) {
            return false;
        }
        ScriptFolderInfo scriptElementInfo = (ScriptFolderInfo)elementInfo;
        return scriptElementInfo.containsScriptResources();
    }

    @Override
    public boolean hasChildren() throws ModelException {
        return this.getChildren().length > 0;
    }

    @Override
    public void copy(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        if (container == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] containers = new IModelElement[]{container};
        IModelElement[] siblings = null;
        if (sibling != null) {
            siblings = new IModelElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getModel().copy(elements, containers, siblings, renamings, replace, monitor);
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) throws ModelException {
        IModelElement[] elements = new IModelElement[]{this};
        this.getModel().delete(elements, force, monitor);
    }

    @Override
    public void move(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        if (container == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] containers = new IModelElement[]{container};
        IModelElement[] siblings = null;
        if (sibling != null) {
            siblings = new IModelElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getModel().move(elements, containers, siblings, renamings, replace, monitor);
    }

    @Override
    public void rename(String newName, boolean force, IProgressMonitor monitor) throws ModelException {
        if (newName == null) {
            throw new IllegalArgumentException(Messages.element_nullName);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] dests = new IModelElement[]{this.getParent()};
        String[] renamings = new String[]{newName};
        this.getModel().rename(elements, dests, renamings, force, monitor);
    }

    public IPath getRelativePath() {
        return this.path;
    }
}

