/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.search;

import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.ui.search.DLTKSearchResultPage;
import org.eclipse.dltk.internal.ui.search.SearchLabelProvider;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Image;

public class SortingLabelProvider
extends SearchLabelProvider
implements IColorProvider {
    public static final int SHOW_ELEMENT_CONTAINER = 1;
    public static final int SHOW_CONTAINER_ELEMENT = 2;
    public static final int SHOW_PATH = 3;

    public SortingLabelProvider(DLTKSearchResultPage page) {
        super(page);
    }

    @Override
    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof IModelElement || element instanceof IResource) {
            image = super.getImage(element);
        }
        if (image != null) {
            return image;
        }
        return this.getParticipantImage(element);
    }

    @Override
    public final String getText(Object element) {
        return this.getLabelWithCounts(element, this.appendRalitivePath(element, this.internalGetText(element)));
    }

    private String appendRalitivePath(Object element, String internalGetText) {
        StringBuilder result = new StringBuilder(internalGetText);
        if (element instanceof IModelElement) {
            IModelElement modelElement = (IModelElement)element;
            try {
                String path = null;
                ISourceModule sm = (ISourceModule)modelElement.getAncestor(5);
                if (sm instanceof ExternalSourceModule) {
                    ExternalSourceModule esm = (ExternalSourceModule)sm;
                    path = esm.getStorage().getFullPath().toString();
                } else {
                    IResource resource = modelElement.getUnderlyingResource();
                    path = resource.getFullPath().toString();
                }
                if (path != null) {
                    result.append(" - ").append(path);
                }
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
        }
        return result.toString();
    }

    private String internalGetText(Object o) {
        String text = super.getText(o);
        if (text != null && text.length() > 0) {
            return text;
        }
        return this.getParticipantText(o);
    }

    public void setOrder(int orderFlag) {
        long flags = 564186904002571L;
        if (orderFlag == 1) {
            flags |= 0x112120901L;
        } else if (orderFlag == 2) {
            flags |= 0x89050481L;
        } else if (orderFlag == 3) {
            flags |= 0x89050481L;
            flags |= 0x100000000000L;
        }
        this.setTextFlags(flags);
    }
}

