/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards.types;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.util.StatusUtil;
import org.eclipse.php.internal.ui.wizards.types.Messages;
import org.eclipse.php.internal.ui.wizards.types.NewPHPTypePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class NewPHPTraitPage
extends NewPHPTypePage {
    private static final String[] TRAIT__CHECKBOXES = new String[]{"PHPDoc Blocks"};
    private static final String[] TRAIT__CHECKBOXES7 = new String[]{"PHPDoc Blocks", "strict_types"};

    public NewPHPTraitPage() {
        super(Messages.NewPHPTraitPage_0);
        this.fTypeKind = 3;
        this.setMessage(Messages.NewPHPTraitPage_1);
        this.setDescription(Messages.NewPHPTraitPage_1);
        this.setTitle(Messages.NewPHPTraitPage_2);
        this.interfacesStatus = new StatusInfo();
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        super.createControl(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.createLocationSection(composite);
        this.createElementSection(composite);
        this.setControl((Control)composite);
        this.initValues();
        this.elementName.setFocus();
    }

    private void createElementSection(Composite container) {
        GridLayout layout = new GridLayout(3, false);
        Composite elementSection = new Composite(container, 0);
        elementSection.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        elementSection.setLayoutData((Object)gd);
        this.addElementNameText(elementSection, Messages.NewPHPTraitPage_3);
        this.addNamespaceText(elementSection);
        if (this.phpVersion == null || this.phpVersion.isGreaterThan(PHPVersion.PHP5_4)) {
            this.addCheckboxesCreation(elementSection, TRAIT__CHECKBOXES7);
        } else {
            this.addCheckboxesCreation(elementSection, TRAIT__CHECKBOXES);
        }
    }

    @Override
    protected void sourceFolderChanged() {
        super.sourceFolderChanged();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String sourcePath = this.getSourceText();
        if (sourcePath == null || sourcePath.length() == 0) {
            return;
        }
        IProject currentProject = workspaceRoot.getProject(this.getProjectName(sourcePath));
        IScriptProject model = DLTKCore.create((IProject)currentProject);
        if (this.getInterfaces().size() > 0) {
            this.validateInterfaces(model);
        }
    }

    @Override
    protected IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.elementNameStatus, this.sourceFolderStatus, this.newFileStatus, this.existingFileStatus, this.interfacesStatus, this.namespaceStatus});
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            super.setVisible(visible);
            return;
        }
        this.getShell().getDisplay().asyncExec(() -> {
            MessageDialog dialog;
            int res;
            if (this.phpVersion.isLessThan(PHPVersion.PHP5_4) && (res = (dialog = new MessageDialog(this.getShell(), this.phpVersion.getAlias().toUpperCase() + Messages.NewPHPTraitPage_4, null, Messages.NewPHPTraitPage_5 + this.phpVersion.getAlias().toUpperCase() + Messages.NewPHPTraitPage_6, 3, new String[]{Messages.NewPHPTraitPage_7, Messages.NewPHPTraitPage_8}, 0)).open()) != 0) {
                WizardDialog wizardDialog = (WizardDialog)this.getContainer();
                wizardDialog.close();
            }
        });
        super.setVisible(visible);
    }
}

