/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.TmfVertex;

public class TmfVertexLegacyWrapper
implements ITmfVertex {
    private final IGraphWorker fWorker;
    private final TmfVertex fLegacyVertex;

    public static TmfVertex.EdgeDirection newDirectionToOldDirection(ITmfGraph.EdgeDirection direction) {
        switch (direction) {
            case INCOMING_HORIZONTAL_EDGE: {
                return TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE;
            }
            case INCOMING_VERTICAL_EDGE: {
                return TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE;
            }
            case OUTGOING_HORIZONTAL_EDGE: {
                return TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE;
            }
            case OUTGOING_VERTICAL_EDGE: {
                return TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE;
            }
        }
        throw new IllegalArgumentException("Unknown direction " + String.valueOf((Object)direction));
    }

    public TmfVertexLegacyWrapper(IGraphWorker worker, TmfVertex vertex) {
        this.fWorker = worker;
        this.fLegacyVertex = vertex;
    }

    public IGraphWorker getWorker() {
        return this.fWorker;
    }

    @Override
    public int compareTo(ITmfVertex arg0) {
        if (!(arg0 instanceof TmfVertexLegacyWrapper)) {
            return 0;
        }
        return this.fLegacyVertex.compareTo(((TmfVertexLegacyWrapper)arg0).fLegacyVertex);
    }

    @Override
    public long getTimestamp() {
        return this.fLegacyVertex.getTs();
    }

    public TmfVertex getVertex() {
        return this.fLegacyVertex;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof TmfVertexLegacyWrapper)) {
            return false;
        }
        TmfVertexLegacyWrapper other = (TmfVertexLegacyWrapper)obj;
        return Objects.equals(this.fLegacyVertex, other.fLegacyVertex) && Objects.equals(this.fWorker, other.fWorker);
    }

    public int hashCode() {
        return Objects.hash(this.fLegacyVertex, this.fWorker);
    }

    public String toString() {
        return "[Legacy vertex for worker: " + String.valueOf(this.fWorker) + ", vertex: " + String.valueOf(this.fLegacyVertex) + "]";
    }
}

