/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil;

import org.apache.wsil.WSILDocument;
import org.apache.wsil.WSILException;
import org.apache.wsil.util.WSILProperties;

public abstract class WSILDocumentFactory {
    public abstract WSILDocument newDocument() throws WSILException;

    public static WSILDocumentFactory newInstance() throws WSILException {
        WSILDocumentFactory docFactory = null;
        String factoryClassName = null;
        try {
            factoryClassName = WSILProperties.getDocumentFactory();
            Class<?> factoryClass = Class.forName(factoryClassName);
            docFactory = (WSILDocumentFactory)factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new WSILException("Could not instantiate document factory class: " + factoryClassName + ".", e);
        }
        return docFactory;
    }
}

