/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.dataprovider;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.AbstractCriticalPathModule;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraphVisitor;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.internal.analysis.graph.core.dataprovider.CriticalPathEntry;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.TmfGraphStatistics;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.ITimeElement;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphStateFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CriticalPathDataProvider
extends AbstractTmfTraceDataProvider
implements ITimeGraphDataProvider<CriticalPathEntry>,
IOutputStyleProvider {
    public static final @NonNull String ID = "org.eclipse.tracecompass.analysis.graph.core.dataprovider.CriticalPathDataProvider";
    private static final AtomicLong ATOMIC_LONG = new AtomicLong();
    private @NonNull AbstractCriticalPathModule fCriticalPathModule;
    private static final @NonNull Map<@NonNull String, @NonNull OutputElementStyle> STATE_MAP = new HashMap<String, OutputElementStyle>();
    private final Map<String, Long> fHostIdToEntryId = new HashMap<String, Long>();
    private final BiMap<IGraphWorker, Long> fWorkerToEntryId = HashBiMap.create();
    private final LoadingCache<IGraphWorker, CriticalPathVisitor> fHorizontalVisitorCache = CacheBuilder.newBuilder().maximumSize(10L).build((CacheLoader)new CacheLoader<IGraphWorker, CriticalPathVisitor>(){

        public CriticalPathVisitor load(IGraphWorker key) throws Exception {
            ITmfGraph criticalPath = CriticalPathDataProvider.this.fCriticalPathModule.getCriticalPathGraph();
            return new CriticalPathVisitor(criticalPath, key);
        }
    });
    private List<@NonNull ITimeGraphArrow> fLinks;
    private final Map<Long, @NonNull Multimap<@NonNull String, @NonNull Object>> fEntryMetadata = new HashMap<Long, Multimap<String, Object>>();

    public CriticalPathDataProvider(@NonNull ITmfTrace trace, @NonNull AbstractCriticalPathModule criticalPathProvider) {
        super(trace);
        this.fCriticalPathModule = criticalPathProvider;
    }

    public synchronized @NonNull TmfModelResponse<@NonNull TmfTreeModel<@NonNull CriticalPathEntry>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        ITmfGraph graph = this.fCriticalPathModule.getCriticalPathGraph();
        if (graph == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
        }
        IGraphWorker current = this.getCurrent();
        if (current == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        CriticalPathVisitor visitor = (CriticalPathVisitor)this.fHorizontalVisitorCache.getUnchecked((Object)current);
        for (CriticalPathEntry model : visitor.getEntries()) {
            this.fEntryMetadata.put(model.getId(), model.getMetadata());
        }
        return new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), visitor.getEntries()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private @Nullable IGraphWorker getCurrent() {
        Object obj = this.fCriticalPathModule.getParameter("workerid");
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof IGraphWorker)) {
            throw new IllegalStateException("Wrong type for critical path module parameter workerid expected IGraphWorker got " + obj.getClass().getSimpleName());
        }
        return (IGraphWorker)obj;
    }

    public @NonNull String getId() {
        return ID;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull TmfModelResponse<@NonNull TimeGraphModel> fetchRowModel(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        IGraphWorker graphWorker = this.getCurrent();
        if (graphWorker == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        CriticalPathVisitor visitor = (CriticalPathVisitor)this.fHorizontalVisitorCache.getIfPresent((Object)graphWorker);
        if (visitor == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        HashMap<@NonNull K, @NonNull @NonNull @NonNull @NonNull V> predicates = new HashMap();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(fetchParameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        ArrayList<@NonNull TimeGraphRowModel> rowModels = new ArrayList<TimeGraphRowModel>();
        for (Long id : filter.getSelectedItems()) {
            Collection states = (Collection)visitor.fStates.asMap().get(id);
            if (states == null) continue;
            ArrayList filteredStates = new ArrayList();
            for (ITimeGraphState state : states) {
                if (!CriticalPathDataProvider.overlaps(state.getStartTime(), state.getDuration(), filter.getTimesRequested())) continue;
                state.setActiveProperties(0);
                this.applyFilterAndAddState(filteredStates, state, id, predicates, monitor);
            }
            rowModels.add(new TimeGraphRowModel(id.longValue(), filteredStates));
        }
        return new TmfModelResponse((Object)new TimeGraphModel(rowModels), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private static final boolean overlaps(long start, long duration, long[] times) {
        int pos = Arrays.binarySearch(times, start);
        if (pos >= 0) {
            return true;
        }
        int ins = -pos - 1;
        if (ins >= times.length) {
            return false;
        }
        return times[ins] <= start + duration;
    }

    public @NonNull TmfModelResponse<@NonNull List<@NonNull ITimeGraphArrow>> fetchArrows(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(fetchParameters);
        if (filter == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        return new TmfModelResponse(this.getLinkList(filter.getStart(), filter.getEnd()), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public @NonNull TmfModelResponse<@NonNull Map<@NonNull String, @NonNull String>> fetchTooltip(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.INCORRECT_QUERY_PARAMETERS);
        }
        IGraphWorker worker = (IGraphWorker)this.fWorkerToEntryId.inverse().get(filter.getSelectedItems().iterator().next());
        if (worker == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        Map<@NonNull String, @NonNull String> info = worker.getWorkerInformation(filter.getStart());
        return new TmfModelResponse(info, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private @Nullable List<@NonNull ITimeGraphArrow> getLinkList(long startTime, long endTime) {
        IGraphWorker current = this.getCurrent();
        List<@NonNull ITimeGraphArrow> graphLinks = this.fLinks;
        if (current == null) {
            if (graphLinks != null) {
                return graphLinks;
            }
            return Collections.emptyList();
        }
        CriticalPathVisitor visitor = (CriticalPathVisitor)this.fHorizontalVisitorCache.getIfPresent((Object)current);
        if (visitor == null) {
            return Collections.emptyList();
        }
        this.fLinks = graphLinks = visitor.getGraphLinks();
        return CriticalPathDataProvider.getLinksInRange(graphLinks, startTime, endTime);
    }

    private static List<@NonNull ITimeGraphArrow> getLinksInRange(List<ITimeGraphArrow> allLinks, long startTime, long endTime) {
        ArrayList<@NonNull ITimeGraphArrow> linksInRange = new ArrayList<ITimeGraphArrow>();
        for (ITimeGraphArrow link : allLinks) {
            if (link.getStartTime() > endTime || link.getStartTime() + link.getDuration() < startTime) continue;
            linksInRange.add(link);
        }
        return linksInRange;
    }

    protected @NonNull OutputElementStyle getMatchingState(ITmfEdgeContextState contextState, boolean arrow) {
        OutputElementStyle outputElementStyle = new OutputElementStyle(null, contextState.getStyles());
        STATE_MAP.put(contextState.getContextEnum().name(), outputElementStyle);
        return outputElementStyle;
    }

    public @NonNull Multimap<@NonNull String, @NonNull Object> getFilterData(long entryId, long time, @Nullable IProgressMonitor monitor) {
        return ITimeGraphStateFilter.mergeMultimaps((Multimap[])new Multimap[]{super.getFilterData(entryId, time, monitor), this.fEntryMetadata.getOrDefault(entryId, (Multimap<String, Object>)ImmutableMultimap.of())});
    }

    public @NonNull TmfModelResponse<@NonNull OutputStyleModel> fetchStyle(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse((Object)new OutputStyleModel(STATE_MAP), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private final class CriticalPathVisitor
    implements ITmfGraphVisitor {
        private final ITmfGraph fGraph;
        private final Map<String, CriticalPathEntry> fHostEntries = new HashMap<String, CriticalPathEntry>();
        private final Map<IGraphWorker, CriticalPathEntry> fWorkers = new LinkedHashMap<IGraphWorker, CriticalPathEntry>();
        private final TmfGraphStatistics fStatistics = new TmfGraphStatistics();
        private final TreeMultimap<Long, ITimeGraphState> fStates = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparingLong(ITimeElement::getStartTime));
        private long fStart;
        private long fEnd;
        private List<@NonNull CriticalPathEntry> fCached;
        private @Nullable List<@NonNull ITimeGraphArrow> fGraphLinks;

        private CriticalPathVisitor(ITmfGraph graph, IGraphWorker worker) {
            this.fGraph = graph;
            this.fStart = CriticalPathDataProvider.this.getTrace().getStartTime().toNanos();
            this.fEnd = CriticalPathDataProvider.this.getTrace().getEndTime().toNanos();
            ITmfVertex head = graph.getHead();
            if (head != null) {
                this.fStart = Long.min(this.fStart, head.getTimestamp());
                for (IGraphWorker w : graph.getWorkers()) {
                    ITmfVertex tail = graph.getTail(w);
                    if (tail == null) continue;
                    this.fEnd = Long.max(this.fEnd, tail.getTimestamp());
                }
            }
            this.fStatistics.computeGraphStatistics(graph, worker);
        }

        @Override
        public void visitHead(ITmfVertex node) {
            IGraphWorker owner = this.fGraph.getParentOf(node);
            if (owner == null) {
                return;
            }
            if (this.fWorkers.containsKey(owner)) {
                return;
            }
            ITmfVertex first = this.fGraph.getHead(owner);
            ITmfVertex last = this.fGraph.getTail(owner);
            if (first == null || last == null) {
                return;
            }
            this.fStart = Long.min(CriticalPathDataProvider.this.getTrace().getStartTime().toNanos(), first.getTimestamp());
            this.fEnd = Long.max(CriticalPathDataProvider.this.getTrace().getEndTime().toNanos(), last.getTimestamp());
            Long sum = this.fStatistics.getSum(owner);
            Double percent = this.fStatistics.getPercent(owner);
            String host = owner.getHostId();
            long parentId = CriticalPathDataProvider.this.fHostIdToEntryId.computeIfAbsent(host, h -> ATOMIC_LONG.getAndIncrement());
            this.fHostEntries.computeIfAbsent(host, h -> new CriticalPathEntry(parentId, -1L, Collections.singletonList(host), this.fStart, this.fEnd, sum, percent));
            long entryId = (Long)CriticalPathDataProvider.this.fWorkerToEntryId.computeIfAbsent((Object)owner, w -> ATOMIC_LONG.getAndIncrement());
            CriticalPathEntry entry = new CriticalPathEntry(entryId, parentId, owner, this.fStart, this.fEnd, sum, percent);
            this.fWorkers.put(owner, entry);
        }

        @Override
        public void visit(ITmfEdge link, boolean horizontal) {
            if (horizontal) {
                IGraphWorker parent = this.fGraph.getParentOf(link.getVertexFrom());
                Long id = (Long)CriticalPathDataProvider.this.fWorkerToEntryId.get((Object)parent);
                if (id != null) {
                    String linkQualifier = link.getLinkQualifier();
                    TimeGraphState ev = new TimeGraphState(link.getVertexFrom().getTimestamp(), link.getDuration(), linkQualifier, CriticalPathDataProvider.this.getMatchingState(link.getEdgeContextState(), false));
                    this.fStates.put((Object)id, (Object)ev);
                }
            } else {
                IGraphWorker parentFrom = this.fGraph.getParentOf(link.getVertexFrom());
                IGraphWorker parentTo = this.fGraph.getParentOf(link.getVertexTo());
                CriticalPathEntry entryFrom = this.fWorkers.get(parentFrom);
                CriticalPathEntry entryTo = this.fWorkers.get(parentTo);
                List<ITimeGraphArrow> graphLinks = this.fGraphLinks;
                if (graphLinks != null && entryFrom != null && entryTo != null) {
                    TimeGraphArrow lk = new TimeGraphArrow(entryFrom.getId(), entryTo.getId(), link.getVertexFrom().getTimestamp(), link.getVertexTo().getTimestamp() - link.getVertexFrom().getTimestamp(), CriticalPathDataProvider.this.getMatchingState(link.getEdgeContextState(), true));
                    graphLinks.add((ITimeGraphArrow)lk);
                }
            }
        }

        public @NonNull List<@NonNull CriticalPathEntry> getEntries() {
            if (this.fCached != null) {
                return this.fCached;
            }
            this.fGraph.scanLineTraverse(this.fGraph.getHead(), (ITmfGraphVisitor)this);
            ArrayList<@NonNull CriticalPathEntry> list = new ArrayList<CriticalPathEntry>(this.fHostEntries.values());
            list.addAll(this.fWorkers.values());
            this.fCached = list;
            return list;
        }

        public synchronized List<@NonNull ITimeGraphArrow> getGraphLinks() {
            if (this.fGraphLinks == null) {
                this.fGraphLinks = new ArrayList<ITimeGraphArrow>();
                this.fGraph.scanLineTraverse(this.fGraph.getHead(), (ITmfGraphVisitor)this);
            }
            return this.fGraphLinks;
        }

        @Override
        public void visit(@NonNull ITmfVertex vertex) {
        }
    }
}

