/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.preferences;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.bnd.ui.AddRemoveButtonBarPart;
import org.eclipse.pde.bnd.ui.URLDialog;
import org.eclipse.pde.bnd.ui.URLLabelProvider;
import org.eclipse.pde.bnd.ui.preferences.ReposPreference;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.prefs.BackingStoreException;

public class ReposPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ReposPreference {
    private static final String REPO_DEFAULT = "https://raw.githubusercontent.com/bndtools/bundle-hub/master/index.xml.gz";
    private boolean enableTemplateRepo;
    private List<String> templateRepos;
    private TableViewer vwrRepos;
    private IEclipsePreferences preferences;

    public void init(IWorkbench workbench) {
        this.preferences = (IEclipsePreferences)InstanceScope.INSTANCE.getNode(FrameworkUtil.getBundle(ReposPreferencePage.class).getSymbolicName()).node("repoTemplateLoader");
        this.enableTemplateRepo = this.preferences.getBoolean("enableTemplateRepositories", false);
        this.templateRepos = (List)TEMPLATE_REPOSITORIES_PARSER.apply(this.preferences.get("templateRepoUriList", REPO_DEFAULT));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginRight = 10;
        composite.setLayout((Layout)layout);
        Group group = new Group(composite, 0);
        group.setText("Templates Repositories");
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        final Button btnEnableTemplateRepo = new Button((Composite)group, 32);
        btnEnableTemplateRepo.setText("Enable templates repositories");
        btnEnableTemplateRepo.setSelection(this.enableTemplateRepo);
        btnEnableTemplateRepo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        ControlDecoration decoration = new ControlDecoration((Control)btnEnableTemplateRepo, 131200, composite);
        decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        decoration.setMarginWidth(3);
        decoration.setDescriptionText("These repositories are used to load\ntemplates, in addition to repositories\nconfigured in the Bnd OSGi Workspace.");
        decoration.setShowHover(true);
        decoration.setShowOnlyOnFocus(false);
        Label lblRepos = new Label((Composite)group, 0);
        lblRepos.setText("Repository URLs:");
        lblRepos.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        final Table tblRepos = new Table((Composite)group, 2050);
        this.vwrRepos = new TableViewer(tblRepos);
        this.vwrRepos.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.vwrRepos.setLabelProvider((IBaseLabelProvider)new URLLabelProvider());
        this.vwrRepos.setInput(this.templateRepos);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 260;
        gd.heightHint = 80;
        tblRepos.setLayoutData((Object)gd);
        tblRepos.setEnabled(this.enableTemplateRepo);
        AddRemoveButtonBarPart addRemoveRepoPart = new AddRemoveButtonBarPart();
        ToolBar addRemovePanel = addRemoveRepoPart.createControl((Composite)group, 0x800200);
        addRemovePanel.setLayoutData((Object)new GridData(4, 128, false, false));
        addRemoveRepoPart.setRemoveEnabled(false);
        addRemoveRepoPart.addListener(new AddRemoveButtonBarPart.AddRemoveListener(){

            @Override
            public void addSelected() {
                ReposPreferencePage.this.doAddRepo();
            }

            @Override
            public void removeSelected() {
                ReposPreferencePage.this.doRemoveRepo();
            }
        });
        this.vwrRepos.addSelectionChangedListener(event -> addRemoveRepoPart.setRemoveEnabled(!this.vwrRepos.getSelection().isEmpty()));
        tblRepos.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && e.stateMask == 0) {
                    ReposPreferencePage.this.doRemoveRepo();
                }
            }
        });
        btnEnableTemplateRepo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ReposPreferencePage.this.enableTemplateRepo = btnEnableTemplateRepo.getSelection();
                tblRepos.setEnabled(ReposPreferencePage.this.enableTemplateRepo);
                ReposPreferencePage.this.validate();
            }
        });
        return composite;
    }

    private void doAddRepo() {
        URLDialog dialog = new URLDialog(this.getShell(), "Add repository URL", false);
        if (dialog.open() == 0) {
            URI location = dialog.getLocation();
            String locationStr = location.toString();
            this.templateRepos.add(locationStr);
            this.vwrRepos.add((Object)locationStr);
        }
    }

    private void doRemoveRepo() {
        int[] selectedIndexes = this.vwrRepos.getTable().getSelectionIndices();
        if (selectedIndexes == null) {
            return;
        }
        ArrayList<String> selected = new ArrayList<String>(selectedIndexes.length);
        int[] nArray = selectedIndexes;
        int n = selectedIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            selected.add(this.templateRepos.get(index));
            ++n2;
        }
        this.templateRepos.removeAll(selected);
        this.vwrRepos.remove(selected.toArray());
        this.validate();
    }

    private void validate() {
        String error = null;
        if (this.enableTemplateRepo) {
            for (String templateRepo : this.templateRepos) {
                try {
                    URI uRI = new URI(templateRepo);
                }
                catch (URISyntaxException e) {
                    error = "Invalid URL: " + e.getMessage();
                }
            }
        }
        this.setErrorMessage(error);
        this.setValid(error == null);
    }

    public boolean performOk() {
        String repoList = this.templateRepos.stream().collect(Collectors.joining("\t"));
        if (!this.enableTemplateRepo) {
            this.preferences.remove("enableTemplateRepositories");
            if (REPO_DEFAULT.equals(repoList)) {
                this.preferences.remove("templateRepoUriList");
            } else {
                this.preferences.put("templateRepoUriList", repoList);
            }
        } else {
            this.preferences.putBoolean("enableTemplateRepositories", this.enableTemplateRepo);
            this.preferences.put("templateRepoUriList", repoList);
        }
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return true;
    }
}

