/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.pull.PullOperationUI;
import org.eclipse.egit.ui.internal.selection.SelectionRepositoryStateCache;
import org.eclipse.jgit.lib.Repository;

public class PullFromUpstreamActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository[] repos = this.getRepositories(event);
        if (repos.length == 0) {
            return null;
        }
        LinkedHashSet<Repository> repositories = new LinkedHashSet<Repository>(Arrays.asList(repos));
        new PullOperationUI(repositories).start();
        return null;
    }

    @Override
    public boolean isEnabled() {
        Repository[] repos;
        Repository[] repositoryArray = repos = this.getRepositories();
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            Repository repo = repositoryArray[n2];
            String fullBranch = SelectionRepositoryStateCache.INSTANCE.getFullBranchName(repo);
            if (fullBranch == null || !fullBranch.startsWith("refs/")) {
                return false;
            }
            if (SelectionRepositoryStateCache.INSTANCE.getHead(repo) == null) {
                return false;
            }
            ++n2;
        }
        return repos.length > 0;
    }
}

