/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl;

import java.util.HashMap;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap {
    private IDispatch attributes;
    private HashMap<AttrKey, Node> attrMap;
    private NodeImpl baseNode;

    public NamedNodeMapImpl(NodeImpl nodeImpl, IDispatch iDispatch) {
        this.baseNode = nodeImpl;
        this.attributes = iDispatch;
    }

    private void initCache() {
        if (this.attrMap != null) {
            return;
        }
        this.attrMap = new HashMap();
        int n = this.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = this.item(n2);
            AttrKey attrKey = new AttrKey(node.getNamespaceURI(), node.getLocalName());
            this.attrMap.put(attrKey, node);
            ++n2;
        }
    }

    public Node item(int n) {
        try {
            IDispatch iDispatch = (IDispatch)this.attributes.invoke1("item", (Object)n);
            return this.baseNode.newNode(iDispatch);
        }
        catch (DispatchException dispatchException) {
            dispatchException.printStackTrace();
            return null;
        }
    }

    public int getLength() {
        Integer n = (Integer)Helper.get(this.attributes, "length");
        if (n == null) {
            return 0;
        }
        return n;
    }

    public Node getNamedItem(String string) {
        try {
            IDispatch iDispatch = (IDispatch)this.attributes.invoke1("removeNamedItem", (Object)string);
            return this.baseNode.newNode(iDispatch);
        }
        catch (DispatchException dispatchException) {
            return null;
        }
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (!(node instanceof NodeImpl)) {
            Helper.notSupported();
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        try {
            IDispatch iDispatch = (IDispatch)this.attributes.invoke1("setNamedItem", (Object)nodeImpl.getINode());
            return this.baseNode.newNode(iDispatch);
        }
        catch (DispatchException dispatchException) {
            return null;
        }
    }

    public Node removeNamedItem(String string) throws DOMException {
        try {
            IDispatch iDispatch = (IDispatch)this.attributes.invoke1("removeNamedItem", (Object)string);
            return this.baseNode.newNode(iDispatch);
        }
        catch (DispatchException dispatchException) {
            return null;
        }
    }

    public Node getNamedItemNS(String string, String string2) {
        this.initCache();
        Node node = this.attrMap.get(new AttrKey(string, string2));
        return node;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        this.initCache();
        Node node2 = this.attrMap.get(new AttrKey(node.getNamespaceURI(), node.getLocalName()));
        return this.setNamedItem(node2);
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        this.initCache();
        Node node = this.attrMap.get(new AttrKey(string, string2));
        return this.removeNamedItem(node.getNodeName());
    }

    private static class AttrKey {
        String ns;
        String name;

        public boolean equals(Object object) {
            if (!(object instanceof AttrKey)) {
                return false;
            }
            AttrKey attrKey = (AttrKey)object;
            return this.ns.equals(attrKey.ns) && this.name.equals(attrKey.name);
        }

        public int hashCode() {
            return this.ns.hashCode() ^ this.name.hashCode();
        }

        AttrKey(String string, String string2) {
            this.ns = string;
            this.name = string2;
        }
    }
}

