/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.sirius.tools.internal.resource.InMemoryResourceFactoryImpl;
import org.eclipse.sirius.tools.internal.resource.InMemoryURIHandlerImpl;

public class InMemoryURIConverterImpl
extends ExtensibleURIConverterImpl
implements URIConverter {
    private URIHandler inMemoryURIHandler;

    public OutputStream createOutputStream(URI uri) throws IOException {
        OutputStream outputStream = null;
        outputStream = "memory".equals(uri.scheme()) ? new ByteArrayOutputStream() : super.createOutputStream(uri);
        return outputStream;
    }

    public InputStream createInputStream(URI uri) throws IOException {
        ByteArrayInputStream inputStream = null;
        byte[] buffer = InMemoryResourceFactoryImpl.IN_MEMORY_BUFFERS.get(uri);
        if (buffer == null || buffer.length == 0) {
            buffer = new byte[1000000];
            InMemoryResourceFactoryImpl.IN_MEMORY_BUFFERS.put(uri, buffer);
        }
        inputStream = new ByteArrayInputStream(buffer);
        return inputStream;
    }

    public URIHandler getURIHandler(URI uri) {
        URIHandler uriHandler = null;
        if ("memory".equals(uri.scheme())) {
            return this.getInMemoryURIHandler();
        }
        uriHandler = super.getURIHandler(uri);
        return uriHandler;
    }

    private URIHandler getInMemoryURIHandler() {
        if (this.inMemoryURIHandler == null) {
            this.inMemoryURIHandler = new InMemoryURIHandlerImpl();
        }
        return this.inMemoryURIHandler;
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return InMemoryResourceFactoryImpl.IN_MEMORY_BUFFERS.containsKey(uri);
    }
}

