/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.query;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.query.SiriusProjectDependencies;
import org.eclipse.sirius.business.api.query.SiriusProjectDependencyQuery;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.internal.query.IProjectDependencyProvider;
import org.eclipse.sirius.business.internal.query.SiriusProjectQuery;
import org.eclipse.sirius.business.internal.session.parser.RepresentationsFileSaxParser;

public class LocalProjectDependencyProvider
implements IProjectDependencyProvider {
    @Override
    public boolean canHandle(IProject project) {
        boolean canHandle = false;
        Map<URI, Set<URI>> mainAirdReferencedURIs = new SiriusProjectQuery(project).getMainAirdReferencedURIs();
        if (!mainAirdReferencedURIs.isEmpty()) {
            canHandle = Stream.of(mainAirdReferencedURIs.values()).flatMap(Collection::stream).flatMap(Collection::stream).filter(uri -> new URIQuery((URI)uri).isCDOURI()).findFirst().isEmpty();
        }
        return canHandle;
    }

    @Override
    public SiriusProjectDependencies getDirectDependencies(IProject project) {
        Set<String> imageProjectsDirectDependencies = new LinkedHashSet<String>();
        LinkedHashSet<String> generalProjectDependencies = new LinkedHashSet<String>();
        List<URI> mainAirdURIs = new SiriusProjectQuery(project).getMainAirdURIs();
        for (URI airdResourceURI : mainAirdURIs) {
            String platformString = airdResourceURI.toPlatformString(true);
            IResource airdResource = ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
            if (!(airdResource instanceof IFile)) continue;
            RepresentationsFileSaxParser representationsFileSaxParser = new RepresentationsFileSaxParser((IFile)airdResource);
            representationsFileSaxParser.analyze();
            Set<URI> referencedAnalysis = representationsFileSaxParser.getReferencedAnalysis();
            Set<URI> semanticElements = representationsFileSaxParser.getSemanticElements();
            imageProjectsDirectDependencies = representationsFileSaxParser.getImageDependencies();
            Stream.of(referencedAnalysis, semanticElements).flatMap(Collection::stream).forEach(uri -> {
                if (uri.isPlatformResource()) {
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
                    IProject fileProject = file.getProject();
                    generalProjectDependencies.add(fileProject.getName());
                }
            });
        }
        generalProjectDependencies.remove(project.getName());
        imageProjectsDirectDependencies.remove(project.getName());
        return new SiriusProjectDependencies(imageProjectsDirectDependencies, generalProjectDependencies, new LinkedHashSet<String>(), new LinkedHashSet<String>());
    }

    private SiriusProjectDependencies addAllGeneralDependencies(IProject projectToAnalyse, Set<String> allGeneralProjectDependencies, Set<String> notAnalysedGeneralProjectDependencies) {
        SiriusProjectDependencies allDependencies = new SiriusProjectDependencyQuery(projectToAnalyse).getDirectDependencies();
        for (String projectName : allDependencies.getGeneralProjectDirectDependencies()) {
            if (allGeneralProjectDependencies.contains(projectName)) continue;
            IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (currentProject.exists()) {
                allGeneralProjectDependencies.add(projectName);
                this.addAllGeneralDependencies(currentProject, allGeneralProjectDependencies, notAnalysedGeneralProjectDependencies);
                continue;
            }
            notAnalysedGeneralProjectDependencies.add(projectName);
        }
        return allDependencies;
    }

    @Override
    public SiriusProjectDependencies getAllDependencies(IProject project) {
        LinkedHashSet<String> allGeneralProjectDependencies = new LinkedHashSet<String>();
        LinkedHashSet<String> notAnalysedGeneralProjectDependencies = new LinkedHashSet<String>();
        SiriusProjectDependencies directDependencies = this.addAllGeneralDependencies(project, allGeneralProjectDependencies, notAnalysedGeneralProjectDependencies);
        allGeneralProjectDependencies.removeAll(directDependencies.getGeneralProjectDirectDependencies());
        LinkedHashSet<String> directProjectDepsName = new LinkedHashSet<String>(directDependencies.getGeneralProjectDirectDependencies());
        directProjectDepsName.removeAll(notAnalysedGeneralProjectDependencies);
        return new SiriusProjectDependencies(directDependencies.getImageProjectsDirectDependencies(), directProjectDepsName, allGeneralProjectDependencies, notAnalysedGeneralProjectDependencies);
    }
}

