/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.api.permission;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.LockStatus;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.tools.api.permission.DRepresentationPermissionStatusQuery;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class DRepresentationPermissionStatusListener
implements IAuthorityListener {
    private DSemanticDecorator representation;
    private SessionListener editor;
    private DRepresentationPermissionStatusQuery dRepresentationPermissionStatusQuery;

    public DRepresentationPermissionStatusListener(DSemanticDecorator representation, SessionListener editor) {
        this.representation = representation;
        this.editor = editor;
        this.dRepresentationPermissionStatusQuery = new DRepresentationPermissionStatusQuery(representation);
    }

    public DSemanticDecorator getRepresentation() {
        return this.representation;
    }

    public void notifyIsLocked(EObject lockedElement) {
        this.notifyIsLocked(Collections.singletonList(lockedElement));
    }

    public void notifyIsLocked(Collection<EObject> lockedElements) {
        IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)this.representation);
        if (this.dRepresentationPermissionStatusQuery.isDSemanticDecoratorLockStatusNotification(lockedElements)) {
            LockStatus lockStatus = permissionAuthority.getLockStatus((EObject)this.representation);
            this.changeUILockStatus(lockStatus);
        }
    }

    public void notifyIsReleased(EObject unlockedElement) {
        this.notifyIsReleased(Collections.singletonList(unlockedElement));
    }

    public void notifyIsReleased(Collection<EObject> unlockedElements) {
        if (this.dRepresentationPermissionStatusQuery.isDSemanticDecoratorLockStatusNotification(unlockedElements)) {
            this.changeUILockStatus(LockStatus.NOT_LOCKED);
        }
    }

    private void changeUILockStatus(LockStatus lockStatus) {
        int sessionListenerEvent = this.dRepresentationPermissionStatusQuery.getAssociatedSessionListenerEvent(lockStatus);
        if (sessionListenerEvent != -1) {
            this.editor.notify(sessionListenerEvent);
        }
    }
}

