/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.format.semantic.diagram.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.refresh.DiagramCreationUtil;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.format.semantic.MappingBasedDiagramContentDuplicationSwitch;
import org.eclipse.sirius.diagram.ui.tools.api.format.semantic.MappingBasedSiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.util.GMFNotationHelper;
import org.eclipse.sirius.tools.internal.SiriusCopierHelper;

public final class MappingBasedSiriusFormatManagerFactoryHelper {
    private MappingBasedSiriusFormatManagerFactoryHelper() {
    }

    public static Diagram getGMFDiagram(DDiagram sourceDiagram) {
        DiagramCreationUtil sourceDiagramUtil = new DiagramCreationUtil(sourceDiagram);
        if (!sourceDiagramUtil.findAssociatedGMFDiagram()) {
            sourceDiagramUtil.createNewGMFDiagram();
        }
        return sourceDiagramUtil.getAssociatedGMFDiagram();
    }

    public static void addParentViewContainersToMap(View sourceView, View targetView, Map<View, View> sourceToTargetView) {
        EObject sourceViewContainer = sourceView.eContainer();
        if (sourceViewContainer instanceof View && !sourceToTargetView.containsKey(sourceView.eContainer())) {
            View targetViewContainer = (View)targetView.eContainer();
            sourceToTargetView.put((View)sourceViewContainer, targetViewContainer);
            MappingBasedSiriusFormatManagerFactoryHelper.addParentViewContainersToMap((View)sourceViewContainer, targetViewContainer, sourceToTargetView);
        }
    }

    public static void copyNodeLayout(Node sourceGmfView, Node targetGmfView) {
        LayoutConstraint layoutConstraintCopy = (LayoutConstraint)SiriusCopierHelper.copyWithNoUidDuplication((EObject)sourceGmfView.getLayoutConstraint());
        targetGmfView.setLayoutConstraint(layoutConstraintCopy);
    }

    public static void copyEdgeLayout(Edge sourceEdge, Edge targetEdge) {
        Bendpoints bendpointsCopy = (Bendpoints)SiriusCopierHelper.copyWithNoUidDuplication((EObject)sourceEdge.getBendpoints());
        Anchor sourceAnchorCopy = (Anchor)SiriusCopierHelper.copyWithNoUidDuplication((EObject)sourceEdge.getSourceAnchor());
        Anchor targetAnchorCopy = (Anchor)SiriusCopierHelper.copyWithNoUidDuplication((EObject)sourceEdge.getTargetAnchor());
        Bendpoints oldBendpoints = targetEdge.getBendpoints();
        if (oldBendpoints instanceof RelativeBendpoints && bendpointsCopy instanceof RelativeBendpoints) {
            ((RelativeBendpoints)oldBendpoints).setPoints(((RelativeBendpoints)bendpointsCopy).getPoints());
        } else {
            targetEdge.setBendpoints(bendpointsCopy);
        }
        targetEdge.setSourceAnchor(sourceAnchorCopy);
        targetEdge.setTargetAnchor(targetAnchorCopy);
        Style routingStyle = sourceEdge.getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
        Style targetRoutingStyle = targetEdge.getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
        if (targetRoutingStyle != null) {
            targetEdge.getStyles().remove((Object)targetRoutingStyle);
        }
        targetEdge.getStyles().add((Object)SiriusCopierHelper.copyWithNoUidDuplication((EObject)routingStyle));
        MappingBasedSiriusFormatManagerFactoryHelper.copyLabelLayout(sourceEdge, targetEdge);
    }

    public static void copyBorderLabelLayout(Node sourceNode, Node targetNode) {
        Node sourceLabelNode = SiriusGMFHelper.getLabelNode((View)sourceNode);
        Node targetLabelNode = SiriusGMFHelper.getLabelNode((View)targetNode);
        if (sourceLabelNode != null && targetLabelNode != null) {
            MappingBasedSiriusFormatManagerFactoryHelper.copyNodeLayout(sourceLabelNode, targetLabelNode);
        }
    }

    public static void copyLabelLayout(Edge sourceEdge, Edge targetEdge) {
        Node sourceLabelNode = SiriusGMFHelper.getLabelNode((View)sourceEdge);
        Node targetLabelNode = SiriusGMFHelper.getLabelNode((View)targetEdge);
        MappingBasedSiriusFormatManagerFactoryHelper.copyNodeLayout(sourceLabelNode, targetLabelNode);
    }

    public static Node getTargetDiagramTextNoteContainer(Node sourceNote, MappingBasedDiagramContentDuplicationSwitch diagramContentDuplicationSwitch) {
        Node parentNode;
        EObject element;
        Node textNoteContainer = null;
        EObject parent = sourceNote.eContainer();
        if (parent instanceof Node && (element = (parentNode = (Node)parent).getElement()) instanceof DDiagramElement) {
            DDiagramElement dDiagramElement = diagramContentDuplicationSwitch.getSourceDDiagramElementToTargetDDiagramElementMap().get(element);
            textNoteContainer = SiriusGMFHelper.getGmfNode(dDiagramElement);
            if (textNoteContainer != null && !parentNode.isSetElement()) {
                for (View child : textNoteContainer.getChildren()) {
                    if (!child.getType().equals(parentNode.getType())) continue;
                    textNoteContainer = (Node)child;
                    break;
                }
            }
            return textNoteContainer;
        }
        return textNoteContainer;
    }

    public static void duplicateNoteAttachment(Edge edge, Node targetNote, Session targetSession, boolean targetNoteIsSource, MappingBasedDiagramContentDuplicationSwitch diagramContentDuplicationSwitch, Map<Node, Node> sourceToTargetNoteMap, MappingBasedSiriusFormatDataManager formatDataManager, Diagram targetGMFDiagram) {
        View sourceEdgeOtherBoundView = targetNoteIsSource ? edge.getTarget() : edge.getSource();
        EObject sourceEdgeOtherBoundElement = sourceEdgeOtherBoundView.getElement();
        View matchingTargetElement = null;
        if (sourceEdgeOtherBoundElement == null) {
            matchingTargetElement = (View)sourceToTargetNoteMap.get(sourceEdgeOtherBoundView);
        } else {
            DDiagramElement targetDiagramElement = diagramContentDuplicationSwitch.getSourceDDiagramElementToTargetDDiagramElementMap().get(sourceEdgeOtherBoundElement);
            if (targetDiagramElement != null && targetDiagramElement.eResource() != null) {
                matchingTargetElement = SiriusGMFHelper.getGmfView(targetDiagramElement, targetSession);
            } else {
                DiagramPlugin.getDefault().logInfo(MessageFormat.format(Messages.MappingBasedSiriusFormatManagerFactory_ImpossibleToCopyNoteInNonExistingOrUnreachableTarget, sourceEdgeOtherBoundElement));
            }
        }
        if (matchingTargetElement != null) {
            Collection<Edge> targetNotesAttachments = GMFNotationHelper.getNotesAttachments(targetGMFDiagram);
            Edge noteAttachmentEdge = null;
            if (targetNoteIsSource) {
                noteAttachmentEdge = MappingBasedSiriusFormatManagerFactoryHelper.searchNoteAttachment(targetNotesAttachments, (View)targetNote, matchingTargetElement);
                if (noteAttachmentEdge == null) {
                    noteAttachmentEdge = ViewService.createEdge((View)targetNote, (View)matchingTargetElement, (String)ViewType.NOTEATTACHMENT, (PreferencesHint)PreferencesHint.USE_DEFAULTS);
                }
            } else {
                noteAttachmentEdge = MappingBasedSiriusFormatManagerFactoryHelper.searchNoteAttachment(targetNotesAttachments, matchingTargetElement, (View)targetNote);
                if (noteAttachmentEdge == null) {
                    noteAttachmentEdge = ViewService.createEdge((View)matchingTargetElement, (View)targetNote, (String)ViewType.NOTEATTACHMENT, (PreferencesHint)PreferencesHint.USE_DEFAULTS);
                }
            }
            MappingBasedSiriusFormatManagerFactoryHelper.copyEdgeFormatAndStyle(edge, noteAttachmentEdge, formatDataManager);
        } else {
            DiagramPlugin.getDefault().logInfo(MessageFormat.format(Messages.MappingBasedSiriusFormatManagerFactory_ImpossibleToResolveOtherBoundTargetNote, sourceEdgeOtherBoundView));
        }
    }

    private static Edge searchNoteAttachment(Collection<Edge> targetNotesAttachments, View sourceView, View targetView) {
        for (Edge edge : targetNotesAttachments) {
            if (sourceView == null || !sourceView.equals(edge.getSource()) || targetView == null || !targetView.equals(edge.getTarget())) continue;
            return edge;
        }
        return null;
    }

    private static void copyEdgeFormatAndStyle(Edge sourceEdge, Edge targetEdge, MappingBasedSiriusFormatDataManager formatDataManager) {
        formatDataManager.copyGMFStyle((View)sourceEdge, (View)targetEdge);
        Bendpoints oldBendpoints = targetEdge.getBendpoints();
        Bendpoints newBendpoints = (Bendpoints)EcoreUtil.copy((EObject)sourceEdge.getBendpoints());
        if (oldBendpoints instanceof RelativeBendpoints && newBendpoints instanceof RelativeBendpoints) {
            ((RelativeBendpoints)oldBendpoints).setPoints(((RelativeBendpoints)newBendpoints).getPoints());
        } else {
            targetEdge.setBendpoints((Bendpoints)EcoreUtil.copy((EObject)sourceEdge.getBendpoints()));
        }
        if (sourceEdge.getSourceAnchor() != null) {
            targetEdge.setSourceAnchor((Anchor)EcoreUtil.copy((EObject)sourceEdge.getSourceAnchor()));
        } else {
            targetEdge.setSourceAnchor(null);
        }
        if (sourceEdge.getTargetAnchor() != null) {
            targetEdge.setTargetAnchor((Anchor)EcoreUtil.copy((EObject)sourceEdge.getTargetAnchor()));
        } else {
            targetEdge.setTargetAnchor(null);
        }
        RoutingStyle originEdgeRoutingStyle = (RoutingStyle)sourceEdge.getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
        if (originEdgeRoutingStyle != null) {
            RoutingStyle targetEdgeRoutingStyle = (RoutingStyle)targetEdge.getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
            targetEdgeRoutingStyle.setRouting(originEdgeRoutingStyle.getRouting());
            targetEdgeRoutingStyle.setJumpLinkStatus(originEdgeRoutingStyle.getJumpLinkStatus());
            targetEdgeRoutingStyle.setJumpLinkType(originEdgeRoutingStyle.getJumpLinkType());
            targetEdgeRoutingStyle.setJumpLinksReverse(originEdgeRoutingStyle.isJumpLinksReverse());
            targetEdgeRoutingStyle.setSmoothness(originEdgeRoutingStyle.getSmoothness());
        }
    }

    public static void applyNodeDepthPositions(DDiagram sourceDiagram, DDiagram targetDiagram, Boolean copyNotes, MappingBasedDiagramContentDuplicationSwitch diagramContentDuplicationSwitch, Map<Node, Node> sourceToTargetNoteMap) {
        Diagram sourceGMFDiagram = MappingBasedSiriusFormatManagerFactoryHelper.getGMFDiagram(sourceDiagram);
        EList allDiagramElements = sourceDiagram.getDiagramElements();
        ArrayList allSourceViews = new ArrayList();
        ArrayList allTargetViews = new ArrayList();
        HashMap allSourceToTargetView = new HashMap();
        ArrayList sourceViewForSynchronizedMappingElements = new ArrayList();
        allDiagramElements.forEach(dE -> {
            DDiagramElement targetDE = diagramContentDuplicationSwitch.getSourceDDiagramElementToTargetDDiagramElementMap().get(dE);
            if (targetDE != null && targetDE.eResource() != null) {
                View sourceView = SiriusGMFHelper.getGmfView(dE);
                allSourceViews.add(sourceView);
                View targetView = SiriusGMFHelper.getGmfView(targetDE);
                allTargetViews.add(targetView);
                allSourceToTargetView.put(sourceView, targetView);
                MappingBasedSiriusFormatManagerFactoryHelper.addParentViewContainersToMap(sourceView, targetView, allSourceToTargetView);
            } else if (dE.getMapping() instanceof DiagramElementMapping && ((DiagramElementMapping)dE.getMapping()).isCreateElements()) {
                sourceViewForSynchronizedMappingElements.add(SiriusGMFHelper.getGmfView(dE));
            }
        });
        if (copyNotes.booleanValue()) {
            GMFNotationHelper.getNotes(sourceGMFDiagram).forEach(sourceNote -> {
                Node targetNote = (Node)sourceToTargetNoteMap.get(sourceNote);
                allSourceViews.add(sourceNote);
                allTargetViews.add(targetNote);
                allSourceToTargetView.put(sourceNote, targetNote);
                MappingBasedSiriusFormatManagerFactoryHelper.addParentViewContainersToMap((View)sourceNote, (View)targetNote, allSourceToTargetView);
            });
            Collection<Shape> diagramTextNotes = GMFNotationHelper.getTextNotes(sourceGMFDiagram);
            diagramTextNotes.stream().filter(sourceTextNote -> sourceGMFDiagram.getChildren().contains(sourceTextNote)).forEach(sourceTextNote -> {
                Node targetTextNote = (Node)sourceToTargetNoteMap.get(sourceTextNote);
                allSourceViews.add(sourceTextNote);
                allTargetViews.add(targetTextNote);
                allSourceToTargetView.put(sourceTextNote, targetTextNote);
                MappingBasedSiriusFormatManagerFactoryHelper.addParentViewContainersToMap((View)sourceTextNote, (View)targetTextNote, allSourceToTargetView);
            });
        }
        if (!allSourceViews.isEmpty()) {
            allSourceViews.forEach(source -> {
                int insertIndex = 0;
                EList sourceContainerChildrens = ((View)source.eContainer()).getChildren();
                View target = (View)allSourceToTargetView.get(source);
                for (View sourceContainerChild : sourceContainerChildrens) {
                    if (sourceContainerChild.equals(source)) {
                        ViewUtil.repositionChildAt((View)((View)target.eContainer()), (View)target, (int)insertIndex);
                        break;
                    }
                    if (!allSourceToTargetView.containsKey(sourceContainerChild) && !sourceViewForSynchronizedMappingElements.contains(sourceContainerChild)) continue;
                    ++insertIndex;
                }
            });
        }
    }
}

