/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.part;

import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;

public class SiriusMatchingStrategy
implements IEditorMatchingStrategy {
    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        IEditorInput editorInput;
        try {
            editorInput = editorRef.getEditorInput();
        }
        catch (PartInitException partInitException) {
            return false;
        }
        if (editorInput == null) {
            return false;
        }
        if (editorInput.equals(input)) {
            return true;
        }
        boolean matches = false;
        if (input instanceof FileEditorInput) {
            String uriEditorInputPath;
            if (editorInput instanceof URIEditorInput) {
                uriEditorInputPath = ((URIEditorInput)editorInput).getURI().toPlatformString(false);
                String fileEditorInputPath = ((FileEditorInput)input).getFile().getFullPath().toString();
                boolean bl = matches = uriEditorInputPath != null && fileEditorInputPath != null && uriEditorInputPath.equals(fileEditorInputPath);
            }
            if (!matches && editorInput instanceof SessionEditorInput) {
                uriEditorInputPath = null;
                Session editorSession = ((SessionEditorInput)editorInput).getSession();
                if (editorSession != null) {
                    uriEditorInputPath = editorSession.getSessionResource().getURI().toPlatformString(false);
                }
                String fileEditorInputPath = ((FileEditorInput)input).getFile().getFullPath().toString();
                matches = uriEditorInputPath != null && fileEditorInputPath != null && uriEditorInputPath.equals(fileEditorInputPath);
            }
        }
        return matches;
    }
}

