/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Gate;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.NotationPredicate;
import org.eclipse.sirius.diagram.sequence.business.internal.util.CacheHelper;
import org.eclipse.sirius.diagram.sequence.description.DescriptionPackage;
import org.eclipse.sirius.ext.base.Option;

public class InteractionContainer
extends AbstractSequenceNode {
    public static final int VISUAL_ID = 2002;
    public static final int COMPARTMENT_VISUAL_ID = 7001;
    public static final int MARGIN = 50;
    public static final int DEFAULT_WIDTH = 180;
    public static final int DEFAULT_HEIGHT = 500;

    InteractionContainer(Node node) {
        super(node);
    }

    public static Predicate<View> notationPredicate() {
        return new NotationPredicate(NotationPackage.eINSTANCE.getNode(), 2002, InteractionContainer.viewpointElementPredicate());
    }

    public static Predicate<View> compartmentNotationPredicate() {
        return new NotationPredicate(NotationPackage.eINSTANCE.getNode(), 7001, InteractionContainer.viewpointElementPredicate());
    }

    public static Predicate<DDiagramElement> viewpointElementPredicate() {
        return SiriusElementPredicate.INSTANCE;
    }

    @Override
    public Rectangle getProperLogicalBounds() {
        return this.getRawNotationBounds();
    }

    public Collection<Gate> getGates() {
        List<Gate> result = null;
        if (CacheHelper.isStructuralCacheEnabled()) {
            result = CacheHelper.getParentToGatesCache().get(this);
        }
        if (result == null) {
            result = new ArrayList<Gate>();
            Predicate<View> gateView = new Predicate<View>(){

                public boolean apply(View input) {
                    return input.getType().equals(Integer.toString(3012));
                }
            };
            for (View view : Iterables.filter((Iterable)Iterables.filter((Iterable)this.view.eContents(), View.class), (Predicate)gateView)) {
                Option<Gate> gate = ISequenceElementAccessor.getGate(view);
                if (!gate.some()) continue;
                result.add((Gate)gate.get());
            }
            Collections.sort(result, Ordering.natural().onResultOf(AbstractFrame.gateOrderingFunction()));
            if (CacheHelper.isStructuralCacheEnabled()) {
                CacheHelper.getParentToGatesCache().put(this, result);
            }
        }
        return result;
    }

    private static enum SiriusElementPredicate implements Predicate<DDiagramElement>
    {
        INSTANCE;


        public boolean apply(DDiagramElement input) {
            return AbstractSequenceElement.isSequenceDiagramElement(input, DescriptionPackage.eINSTANCE.getInteractionContainerMapping());
        }
    }
}

