/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.core.internal.controllers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFRadioDescription;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.AbstractEEFWidgetController;
import org.eclipse.eef.core.api.controllers.IEEFRadioController;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;

public class EEFRadioController
extends AbstractEEFWidgetController
implements IEEFRadioController {
    private final EEFRadioDescription description;
    private Consumer<Object> newValueConsumer;
    private Consumer<List<Object>> newCandidatesConsumer;

    public EEFRadioController(EEFRadioDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super(variableManager, interpreter, editingContextAdapter);
        this.description = description;
    }

    @Override
    public IStatus updateValue(Object text) {
        return this.editingContextAdapter.performModelChange(() -> {
            String editExpression = this.description.getEditExpression();
            EAttribute eAttribute = EefPackage.Literals.EEF_RADIO_DESCRIPTION__EDIT_EXPRESSION;
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.putAll(this.variableManager.getVariables());
            variables.put("newValue", text);
            EvalFactory.of(this.interpreter, variables).logIfBlank(eAttribute).call(editExpression);
        });
    }

    @Override
    public void refresh() {
        super.refresh();
        String candidatesExpression = this.description.getCandidatesExpression();
        EAttribute candidatesExpressionEAttribute = EefPackage.Literals.EEF_RADIO_DESCRIPTION__CANDIDATES_EXPRESSION;
        this.newEval().logIfBlank(candidatesExpressionEAttribute).call(candidatesExpression, value -> {
            if (value instanceof Iterable) {
                ArrayList candidates = new ArrayList();
                ((Iterable)value).forEach(object -> {
                    boolean bl = candidates.add(object);
                });
                Optional.ofNullable(this.newCandidatesConsumer).ifPresent(consumer -> consumer.accept(candidates));
            }
        });
        String valueExpression = this.description.getValueExpression();
        Optional.ofNullable(this.newValueConsumer).ifPresent(consumer -> this.newEval().call(valueExpression, (Consumer<Object>)consumer));
    }

    @Override
    public void onNewValue(Consumer<Object> consumer) {
        this.newValueConsumer = consumer;
    }

    @Override
    public void onNewCandidates(Consumer<List<Object>> consumer) {
        this.newCandidatesConsumer = consumer;
    }

    @Override
    public void removeNewValueConsumer() {
        this.newValueConsumer = null;
    }

    @Override
    public void removeNewCandidatesConsumer() {
        this.newCandidatesConsumer = null;
    }

    @Override
    protected EEFWidgetDescription getDescription() {
        return this.description;
    }
}

