/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.delete;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.sirius.diagram.business.api.helper.delete.DeleteHookHelper;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class DeleteWrapperHookExecutorCommand
extends AbstractTransactionalCommand {
    private ICommand deleteCommand;
    private Collection<DSemanticDecorator> dSemanticDecoratorsToDelete;

    public DeleteWrapperHookExecutorCommand(TransactionalEditingDomain domain, Collection<DSemanticDecorator> dSemanticDecoratorsToDelete, ICommand deleteCommand) {
        super(domain, deleteCommand.getLabel(), deleteCommand.getAffectedFiles());
        this.deleteCommand = deleteCommand;
        this.dSemanticDecoratorsToDelete = dSemanticDecoratorsToDelete;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CommandResult commandResult = null;
        DeleteHookHelper deleteHookHelper = new DeleteHookHelper(this.dSemanticDecoratorsToDelete);
        if (deleteHookHelper.checkDeleteHook()) {
            IStatus status = this.deleteCommand.execute(monitor, info);
            if (status.isOK()) {
                commandResult = CommandResult.newOKCommandResult();
            } else if (status.getSeverity() == 8) {
                commandResult = CommandResult.newCancelledCommandResult();
            } else if (status.getSeverity() == 4) {
                commandResult = CommandResult.newErrorCommandResult((Throwable)status.getException());
            }
        } else {
            throw new OperationCanceledException();
        }
        return commandResult;
    }
}

