/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part.listener;

import com.google.common.base.Objects;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DDiagramEditorImpl;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.SynchronizeStatusFigure;
import org.eclipse.ui.PlatformUI;

public class SynchronizedStatusPostCommitListener
extends ResourceSetListenerImpl {
    private DiagramEditor diagramEditor;

    public SynchronizedStatusPostCommitListener(DDiagramEditorImpl dDiagramEditorImpl) {
        super(NotificationFilter.NOT_TOUCH.and(NotificationFilter.createFeatureFilter((EStructuralFeature)DiagramPackage.eINSTANCE.getDDiagram_Synchronized())));
        this.diagramEditor = dDiagramEditorImpl;
        dDiagramEditorImpl.getEditingDomain().addResourceSetListener((ResourceSetListener)this);
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        if (this.diagramEditor instanceof DDiagramEditorImpl) {
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                ((DDiagramEditorImpl)this.diagramEditor).rebuildStatusLine();
                EObject resolveSemanticElement = this.diagramEditor.getDiagramEditPart().resolveSemanticElement();
                for (Notification notif : event.getNotifications()) {
                    if (!Objects.equal((Object)resolveSemanticElement, (Object)notif.getNotifier())) continue;
                    SynchronizeStatusFigure.updateNotification((DiagramRootEditPart)this.diagramEditor.getDiagramEditPart().getRoot());
                    break;
                }
            });
        }
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
    }
}

