/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.graph;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LMargin;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LShape;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

public final class LPort
extends LShape {
    private static final long serialVersionUID = -3406558719744943360L;
    public static final Predicate<LPort> OUTPUT_PREDICATE = port -> !port.outgoingEdges.isEmpty();
    public static final Predicate<LPort> INPUT_PREDICATE = port -> !port.incomingEdges.isEmpty();
    public static final Predicate<LPort> NORTH_PREDICATE = port -> port.side == PortSide.NORTH;
    public static final Predicate<LPort> EAST_PREDICATE = port -> port.side == PortSide.EAST;
    public static final Predicate<LPort> SOUTH_PREDICATE = port -> port.side == PortSide.SOUTH;
    public static final Predicate<LPort> WEST_PREDICATE = port -> port.side == PortSide.WEST;
    private LNode owner;
    private PortSide side = PortSide.UNDEFINED;
    private final KVector anchor = new KVector();
    private boolean explicitlySuppliedPortAnchor = false;
    private final LMargin margin = new LMargin();
    private final List<LLabel> labels = Lists.newArrayListWithCapacity((int)2);
    private final List<LEdge> incomingEdges = Lists.newArrayListWithCapacity((int)4);
    private final List<LEdge> outgoingEdges = Lists.newArrayListWithCapacity((int)4);
    private Iterable<LEdge> connectedEdges = new CombineIter<LEdge>(this.incomingEdges, this.outgoingEdges);
    private boolean connectedToExternalNodes = true;

    public LNode getNode() {
        return this.owner;
    }

    public void setNode(LNode node) {
        if (this.owner != null) {
            this.owner.getPorts().remove((Object)this);
        }
        this.owner = node;
        if (this.owner != null) {
            this.owner.getPorts().add(this);
        }
    }

    public PortSide getSide() {
        return this.side;
    }

    public void setSide(PortSide theside) {
        if (theside == null) {
            throw new NullPointerException();
        }
        this.side = theside;
        if (!this.isExplicitlySuppliedPortAnchor()) {
            switch (this.side) {
                case NORTH: {
                    this.getAnchor().x = this.getSize().x / 2.0;
                    this.getAnchor().y = 0.0;
                    break;
                }
                case EAST: {
                    this.getAnchor().x = this.getSize().x;
                    this.getAnchor().y = this.getSize().y / 2.0;
                    break;
                }
                case SOUTH: {
                    this.getAnchor().x = this.getSize().x / 2.0;
                    this.getAnchor().y = this.getSize().y;
                    break;
                }
                case WEST: {
                    this.getAnchor().x = 0.0;
                    this.getAnchor().y = this.getSize().y / 2.0;
                }
            }
        }
    }

    public KVector getAnchor() {
        return this.anchor;
    }

    public boolean isExplicitlySuppliedPortAnchor() {
        return this.explicitlySuppliedPortAnchor;
    }

    public void setExplicitlySuppliedPortAnchor(boolean fixed) {
        this.explicitlySuppliedPortAnchor = fixed;
    }

    public KVector getAbsoluteAnchor() {
        return KVector.sum((KVector[])new KVector[]{this.owner.getPosition(), this.getPosition(), this.anchor});
    }

    public LMargin getMargin() {
        return this.margin;
    }

    public List<LLabel> getLabels() {
        return this.labels;
    }

    public String getName() {
        if (!this.labels.isEmpty()) {
            return this.labels.get(0).getText();
        }
        return null;
    }

    public int getDegree() {
        return this.incomingEdges.size() + this.outgoingEdges.size();
    }

    public int getNetFlow() {
        return this.incomingEdges.size() - this.outgoingEdges.size();
    }

    public List<LEdge> getIncomingEdges() {
        return this.incomingEdges;
    }

    public List<LEdge> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    public Iterable<LEdge> getConnectedEdges() {
        return this.connectedEdges;
    }

    public boolean isConnectedToExternalNodes() {
        return this.connectedToExternalNodes;
    }

    public void setConnectedToExternalNodes(boolean conn) {
        this.connectedToExternalNodes = conn;
    }

    public Iterable<LPort> getPredecessorPorts() {
        return new Iterable<LPort>(){

            @Override
            public Iterator<LPort> iterator() {
                final Iterator<LEdge> edgesIter = LPort.this.incomingEdges.iterator();
                return new Iterator<LPort>(){

                    @Override
                    public boolean hasNext() {
                        return edgesIter.hasNext();
                    }

                    @Override
                    public LPort next() {
                        return ((LEdge)((Object)edgesIter.next())).getSource();
                    }

                    @Override
                    public void remove() {
                        edgesIter.remove();
                    }
                };
            }
        };
    }

    public Iterable<LPort> getSuccessorPorts() {
        return new Iterable<LPort>(){

            @Override
            public Iterator<LPort> iterator() {
                final Iterator<LEdge> edgesIter = LPort.this.outgoingEdges.iterator();
                return new Iterator<LPort>(){

                    @Override
                    public boolean hasNext() {
                        return edgesIter.hasNext();
                    }

                    @Override
                    public LPort next() {
                        return ((LEdge)((Object)edgesIter.next())).getTarget();
                    }

                    @Override
                    public void remove() {
                        edgesIter.remove();
                    }
                };
            }
        };
    }

    public Iterable<LPort> getConnectedPorts() {
        return Iterables.concat(this.getPredecessorPorts(), this.getSuccessorPorts());
    }

    public int getIndex() {
        if (this.owner == null) {
            return -1;
        }
        return this.owner.getPorts().indexOf((Object)this);
    }

    @Override
    public String getDesignation() {
        if (!this.labels.isEmpty() && !Strings.isNullOrEmpty((String)this.labels.get(0).getText())) {
            return this.labels.get(0).getText();
        }
        String id = super.getDesignation();
        if (id != null) {
            return id;
        }
        return Integer.toString(this.getIndex());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("p_").append(this.getDesignation());
        if (this.owner != null) {
            result.append("[").append((Object)this.owner).append("]");
        }
        if (this.incomingEdges.size() == 1 && this.outgoingEdges.isEmpty() && this.incomingEdges.get(0).getSource() != this) {
            LPort source = this.incomingEdges.get(0).getSource();
            result.append(" << ").append(source.getDesignation());
            result.append("[").append((Object)source.owner).append("]");
        }
        if (this.incomingEdges.isEmpty() && this.outgoingEdges.size() == 1 && this.outgoingEdges.get(0).getTarget() != this) {
            LPort target = this.outgoingEdges.get(0).getTarget();
            result.append(" >> ").append(target.getDesignation());
            result.append("[").append((Object)target.owner).append("]");
        }
        return result.toString();
    }

    private static class CombineIter<T>
    implements Iterable<T> {
        private Iterable<T> firstIterable;
        private Iterable<T> secondIterable;

        CombineIter(Iterable<T> firstIterable, Iterable<T> secondIterable) {
            this.firstIterable = firstIterable;
            this.secondIterable = secondIterable;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private Iterator<T> firstIterator;
                private Iterator<T> secondIterator;
                {
                    this.firstIterator = combineIter.firstIterable.iterator();
                    this.secondIterator = combineIter.secondIterable.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.firstIterator.hasNext() || this.secondIterator.hasNext();
                }

                @Override
                public T next() {
                    if (this.firstIterator.hasNext()) {
                        return this.firstIterator.next();
                    }
                    return this.secondIterator.next();
                }
            };
        }
    }
}

