/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.modelexplorer;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.sirius.ui.tools.internal.views.common.action.DeleteRepresentationAction;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationItemImpl;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;

public class DeleteActionHandler
extends Action {
    private ISelectionProvider selectionProvider;

    public DeleteActionHandler(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
        this.selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DeleteActionHandler.this.setEnabled(!DeleteActionHandler.this.getRepresentationDescriptors().isEmpty());
            }
        });
    }

    private Collection<DRepresentationDescriptor> getRepresentationDescriptors() {
        List selections;
        ISelection selection = this.selectionProvider.getSelection();
        if (selection instanceof IStructuredSelection && (selections = ((IStructuredSelection)selection).toList()) != null && !selections.isEmpty()) {
            LinkedHashSet<DRepresentationDescriptor> selectedRepDescriptors = new LinkedHashSet<DRepresentationDescriptor>();
            Iterables.addAll(selectedRepDescriptors, (Iterable)Iterables.filter((Iterable)selections, DRepresentationDescriptor.class));
            Iterables.addAll(selectedRepDescriptors, (Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)selections, RepresentationItemImpl.class), RepresentationItemImpl.REPRESENTATION_ITEM_TO_REPRESENTATION));
            return selectedRepDescriptors;
        }
        return Collections.emptyList();
    }

    public void run() {
        DeleteRepresentationAction deleteAction = new DeleteRepresentationAction(this.getRepresentationDescriptors());
        deleteAction.run();
    }
}

