/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.editor;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefContextMenu;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.MessageFormat;
import org.eclipse.swtbot.swt.finder.utils.internal.Assert;
import org.hamcrest.Matcher;

public class SWTBotSiriusGefContextMenu
extends SWTBotGefContextMenu {
    private final String text;
    private final Control control;

    public SWTBotSiriusGefContextMenu(Control control, String text) {
        super(control, text);
        this.text = text;
        this.control = control;
    }

    public SWTBotGefContextMenu click() {
        final boolean[] clicked = new boolean[1];
        UIThreadRunnable.asyncExec((Display)this.display, (VoidResult)new VoidResult(){

            public void run() {
                Menu menu = SWTBotSiriusGefContextMenu.this.control.getMenu();
                SWTBotSiriusGefContextMenu.this.invokeMenuInternal(menu, (Matcher<? extends Widget>)WidgetMatcherFactory.withMnemonic((String)SWTBotSiriusGefContextMenu.this.text), clicked, true);
            }
        });
        UIThreadRunnable.syncExec((Display)this.display, (VoidResult)new VoidResult(){

            public void run() {
            }
        });
        if (!clicked[0]) {
            throw new WidgetNotFoundException(this.text);
        }
        return this;
    }

    private boolean invokeMenuInternal(Menu bar, Matcher<? extends Widget> matcher, boolean[] clickInitiated, boolean recursive) {
        if (bar != null) {
            bar.notifyListeners(22, new Event());
            try {
                MenuItem[] items = bar.getItems();
                int i = 0;
                while (i < items.length) {
                    MenuItem menuItem = items[i];
                    if (!this.isSeparator(menuItem)) {
                        if (matcher.matches((Object)menuItem)) {
                            clickInitiated[0] = true;
                            this.click(menuItem);
                            return true;
                        }
                        if (recursive && this.invokeMenuInternal(menuItem.getMenu(), matcher, clickInitiated, recursive)) {
                            return true;
                        }
                    }
                    ++i;
                }
            }
            finally {
                if (!bar.isDisposed()) {
                    bar.notifyListeners(23, new Event());
                }
            }
        }
        return false;
    }

    private void click(MenuItem menuItem) {
        this.assertEnabled(menuItem);
        int style = menuItem.getStyle();
        if (this.hasStyle(style, 32) || this.hasStyle(style, 16)) {
            menuItem.setSelection(!menuItem.getSelection());
        }
        Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = menuItem;
        event.display = menuItem.getDisplay();
        menuItem.notifyListeners(13, event);
    }

    private boolean hasStyle(int style, int flag) {
        return (style & flag) == flag;
    }

    private boolean isSeparator(MenuItem menuItem) {
        return (menuItem.getStyle() & 2) != 0;
    }

    private void assertEnabled(MenuItem menuItem) {
        Assert.isTrue((boolean)this.isEnabled((Widget)menuItem), (Object)MessageFormat.format((String)"Widget {0} is not enabled.", (Object[])new Object[]{this}));
    }
}

