/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree;

import java.util.List;
import org.eclipse.elk.alg.common.NodeMicroLayout;
import org.eclipse.elk.alg.mrtree.ComponentsProcessor;
import org.eclipse.elk.alg.mrtree.ElkGraphImporter;
import org.eclipse.elk.alg.mrtree.MrTree;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class TreeLayoutProvider
extends AbstractLayoutProvider {
    private MrTree klayTree = new MrTree();
    private ComponentsProcessor componentsProcessor = new ComponentsProcessor();
    private final float defaultWork = 0.1f;

    public void layout(ElkNode layoutGraph, IElkProgressMonitor progressMonitor) {
        if (!((Boolean)layoutGraph.getProperty(MrTreeOptions.OMIT_NODE_MICRO_LAYOUT)).booleanValue()) {
            NodeMicroLayout.forGraph((ElkNode)layoutGraph).execute();
        }
        IElkProgressMonitor pm = progressMonitor.subTask(0.1f);
        pm.begin("build tGraph", 1.0f);
        ElkGraphImporter graphImporter = new ElkGraphImporter();
        TGraph tGraph = graphImporter.importGraph(layoutGraph);
        pm.done();
        pm = progressMonitor.subTask(0.1f);
        pm.begin("Split graph", 1.0f);
        List<TGraph> components = this.componentsProcessor.split(tGraph);
        pm.done();
        for (TGraph comp : components) {
            this.klayTree.doLayout(comp, progressMonitor.subTask(0.6f / (float)components.size()));
        }
        pm = progressMonitor.subTask(0.1f);
        pm.begin("Pack components", 1.0f);
        tGraph = this.componentsProcessor.pack(components);
        pm.done();
        pm = progressMonitor.subTask(0.1f);
        pm.begin("Apply layout results", 1.0f);
        graphImporter.applyLayout(tGraph);
        pm.done();
    }
}

