/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;

class EnhancedExecutor {
    private final Executor executor;
    private final Queue<Future<Void>> awaiting = new ConcurrentLinkedQueue<Future<Void>>();
    private final AtomicReference<Throwable> throwable = new AtomicReference();

    public EnhancedExecutor(Executor executor) {
        this.executor = executor;
    }

    public void execute(final Runnable runnable) {
        FutureTask<Object> task = new FutureTask<Object>(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    EnhancedExecutor.this.throwable.compareAndSet(null, t);
                }
            }
        }, null);
        this.awaiting.add(task);
        try {
            this.executor.execute(task);
        }
        catch (Throwable t) {
            task.cancel(false);
            this.throwable.compareAndSet(null, t);
        }
    }

    public void await() {
        Future<Void> awaitTask;
        while (this.throwable.get() == null && (awaitTask = this.awaiting.poll()) != null) {
            if (awaitTask.isDone() || awaitTask.isCancelled()) continue;
            try {
                awaitTask.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getCause());
            }
        }
        Throwable t = this.throwable.get();
        if (t != null) {
            if (t instanceof Runnable) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
    }
}

