/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.sharedobject;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectFactory;
import org.eclipse.ecf.core.sharedobject.SharedObjectCreateException;
import org.eclipse.ecf.core.sharedobject.SharedObjectTypeDescription;
import org.eclipse.ecf.core.sharedobject.provider.ISharedObjectInstantiator;
import org.eclipse.ecf.core.status.SerializableStatus;
import org.eclipse.ecf.core.util.Trace;

public class SharedObjectFactory
implements ISharedObjectFactory {
    private static Hashtable sharedobjectdescriptions = new Hashtable();
    protected static ISharedObjectFactory instance = null;

    static {
        instance = new SharedObjectFactory();
    }

    protected SharedObjectFactory() {
    }

    public static ISharedObjectFactory getDefault() {
        return instance;
    }

    private static void trace(String msg) {
        Trace.trace((String)"org.eclipse.ecf.sharedobject", (String)msg);
    }

    private static void dumpStack(String msg, Throwable e) {
        Trace.catching((String)"org.eclipse.ecf.sharedobject", (String)"org.eclipse.ecf.sharedobject/debug/exceptions/catching", SharedObjectFactory.class, (String)"dumpStack", (Throwable)e);
    }

    @Override
    public SharedObjectTypeDescription addDescription(SharedObjectTypeDescription description) {
        SharedObjectFactory.trace("addDescription(" + description + ")");
        return this.addDescription0(description);
    }

    @Override
    public List getDescriptions() {
        return this.getDescriptions0();
    }

    protected List getDescriptions0() {
        return new ArrayList(sharedobjectdescriptions.values());
    }

    protected SharedObjectTypeDescription addDescription0(SharedObjectTypeDescription n) {
        if (n == null) {
            return null;
        }
        return sharedobjectdescriptions.put(n.getName(), n);
    }

    @Override
    public boolean containsDescription(SharedObjectTypeDescription scd) {
        return this.containsDescription0(scd);
    }

    protected boolean containsDescription0(SharedObjectTypeDescription scd) {
        if (scd == null) {
            return false;
        }
        return sharedobjectdescriptions.containsKey(scd.getName());
    }

    protected SharedObjectTypeDescription getDescription0(SharedObjectTypeDescription scd) {
        if (scd == null) {
            return null;
        }
        return (SharedObjectTypeDescription)sharedobjectdescriptions.get(scd.getName());
    }

    protected SharedObjectTypeDescription getDescription0(String name) {
        if (name == null) {
            return null;
        }
        return (SharedObjectTypeDescription)sharedobjectdescriptions.get(name);
    }

    @Override
    public SharedObjectTypeDescription getDescriptionByName(String name) throws SharedObjectCreateException {
        SharedObjectFactory.trace("getDescriptionByName(" + name + ")");
        SharedObjectTypeDescription res = this.getDescription0(name);
        if (res == null) {
            this.throwSharedObjectCreateException("SharedObjectDescription named " + name + " not found");
        }
        return res;
    }

    private void throwSharedObjectCreateException(String message, Throwable exception) throws SharedObjectCreateException {
        throw new SharedObjectCreateException((IStatus)new SerializableStatus(4, "org.eclipse.ecf.sharedobject", message, exception));
    }

    private void throwSharedObjectCreateException(String message) throws SharedObjectCreateException {
        this.throwSharedObjectCreateException(message, null);
    }

    @Override
    public ISharedObject createSharedObject(SharedObjectTypeDescription desc, Object[] args) throws SharedObjectCreateException {
        SharedObjectTypeDescription cd;
        SharedObjectFactory.trace("createSharedObject(" + desc + "," + Trace.getArgumentsString((Object[])args) + ")");
        if (desc == null) {
            this.throwSharedObjectCreateException("SharedObjectTypeDescription cannot be null");
        }
        if ((cd = this.getDescription0(desc)) == null) {
            this.throwSharedObjectCreateException("SharedObjectDescription named " + desc.getName() + " not found");
        }
        ISharedObjectInstantiator instantiator = null;
        try {
            instantiator = cd.getInstantiator();
        }
        catch (Exception e) {
            SharedObjectFactory.dumpStack("Exception in createSharedObject", e);
            this.throwSharedObjectCreateException("createSharedObject exception with description" + desc, e);
        }
        if (instantiator == null) {
            this.throwSharedObjectCreateException("Instantiator for SharedObjectDescription " + cd.getName() + " is null");
        }
        return instantiator.createInstance(desc, args);
    }

    @Override
    public ISharedObject createSharedObject(String descriptionName) throws SharedObjectCreateException {
        return this.createSharedObject(this.getDescriptionByName(descriptionName), null);
    }

    @Override
    public ISharedObject createSharedObject(String descriptionName, Object[] args) throws SharedObjectCreateException {
        return this.createSharedObject(this.getDescriptionByName(descriptionName), args);
    }

    @Override
    public SharedObjectTypeDescription removeDescription(SharedObjectTypeDescription scd) {
        SharedObjectFactory.trace("removeDescription(" + scd + ")");
        return this.removeDescription0(scd);
    }

    protected SharedObjectTypeDescription removeDescription0(SharedObjectTypeDescription n) {
        if (n == null) {
            return null;
        }
        return (SharedObjectTypeDescription)sharedobjectdescriptions.remove(n.getName());
    }
}

