/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jivesoftware.smack.util.Cache;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.dns.HostAddress;
import org.jivesoftware.smack.util.dns.SRVRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNSUtil {
    private static Map<String, List<HostAddress>> cache = new Cache<String, List<HostAddress>>(100, 600000L);
    private static DNSResolver dnsResolver = null;

    public static void setDNSResolver(DNSResolver resolver) {
        dnsResolver = resolver;
    }

    public static DNSResolver getDNSResolver() {
        return dnsResolver;
    }

    public static List<HostAddress> resolveXMPPDomain(String domain) {
        if (dnsResolver == null) {
            ArrayList<HostAddress> addresses = new ArrayList<HostAddress>(1);
            addresses.add(new HostAddress(domain, 5222));
            return addresses;
        }
        return DNSUtil.resolveDomain(domain, 'c');
    }

    public static List<HostAddress> resolveXMPPServerDomain(String domain) {
        if (dnsResolver == null) {
            ArrayList<HostAddress> addresses = new ArrayList<HostAddress>(1);
            addresses.add(new HostAddress(domain, 5269));
            return addresses;
        }
        return DNSUtil.resolveDomain(domain, 's');
    }

    private static List<HostAddress> resolveDomain(String domain, char keyPrefix) {
        ArrayList<HostAddress> addresses;
        String key = String.valueOf(keyPrefix) + domain;
        if (cache.containsKey(key) && (addresses = cache.get(key)) != null) {
            return addresses;
        }
        addresses = new ArrayList();
        String srvDomain = keyPrefix == 's' ? "_xmpp-server._tcp." + domain : (keyPrefix == 'c' ? "_xmpp-client._tcp." + domain : domain);
        List<SRVRecord> srvRecords = dnsResolver.lookupSRVRecords(srvDomain);
        List<HostAddress> sortedRecords = DNSUtil.sortSRVRecords(srvRecords);
        if (sortedRecords != null) {
            addresses.addAll(sortedRecords);
        }
        addresses.add(new HostAddress(domain));
        cache.put(key, addresses);
        return addresses;
    }

    protected static List<HostAddress> sortSRVRecords(List<SRVRecord> records) {
        List bucket;
        if (records.size() == 1 && records.get(0).getFQDN().equals(".")) {
            return null;
        }
        Collections.sort(records);
        TreeMap<Integer, LinkedList<SRVRecord>> buckets = new TreeMap<Integer, LinkedList<SRVRecord>>();
        for (SRVRecord r : records) {
            Integer priority = r.getPriority();
            bucket = (LinkedList<SRVRecord>)buckets.get(priority);
            if (bucket == null) {
                bucket = new LinkedList<SRVRecord>();
                buckets.put(priority, (LinkedList<SRVRecord>)bucket);
            }
            bucket.add(r);
        }
        ArrayList<HostAddress> res = new ArrayList<HostAddress>(records.size());
        for (Integer priority : buckets.keySet()) {
            int bucketSize;
            bucket = (List)buckets.get(priority);
            while ((bucketSize = bucket.size()) > 0) {
                int selectedPos;
                int[] totals = new int[bucket.size()];
                int running_total = 0;
                int count = 0;
                int zeroWeight = 1;
                for (SRVRecord r : bucket) {
                    if (r.getWeight() <= 0) continue;
                    zeroWeight = 0;
                }
                for (SRVRecord r : bucket) {
                    totals[count] = running_total += r.getWeight() + zeroWeight;
                    ++count;
                }
                if (running_total == 0) {
                    selectedPos = (int)(Math.random() * (double)bucketSize);
                } else {
                    double rnd = Math.random() * (double)running_total;
                    selectedPos = DNSUtil.bisect(totals, rnd);
                }
                SRVRecord chosenSRVRecord = (SRVRecord)bucket.remove(selectedPos);
                res.add(chosenSRVRecord);
            }
        }
        return res;
    }

    private static int bisect(int[] array, double value) {
        int pos = 0;
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            if (value < (double)element) break;
            ++pos;
            ++n2;
        }
        return pos;
    }
}

