/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class CoolBar
extends Composite {
    CoolItem[][] items = new CoolItem[0][0];
    CoolItem[] originalItems = new CoolItem[0];
    Cursor hoverCursor;
    Cursor dragCursor;
    Cursor cursor;
    CoolItem dragging = null;
    int mouseXOffset;
    int itemXOffset;
    boolean isLocked = false;
    boolean inDispose = false;
    static final int ROW_SPACING = 2;
    static final int CLICK_DISTANCE = 3;
    static final int DEFAULT_COOLBAR_WIDTH = 0;
    static final int DEFAULT_COOLBAR_HEIGHT = 0;

    public CoolBar(Composite parent, int style) {
        super(parent, CoolBar.checkStyle(style));
        if ((style & 0x200) != 0) {
            this.style |= 0x200;
            this.hoverCursor = new Cursor(this.display, 7);
        } else {
            this.style |= 0x100;
            this.hoverCursor = new Cursor(this.display, 9);
        }
        this.dragCursor = new Cursor(this.display, 5);
        Listener listener = event -> {
            switch (event.type) {
                case 12: {
                    this.onDispose(event);
                    break;
                }
                case 3: {
                    this.onMouseDown(event);
                    break;
                }
                case 7: {
                    this.onMouseExit();
                    break;
                }
                case 5: {
                    this.onMouseMove(event);
                    break;
                }
                case 4: {
                    this.onMouseUp(event);
                    break;
                }
                case 8: {
                    this.onMouseDoubleClick(event);
                    break;
                }
                case 9: {
                    this.onPaint(event);
                    break;
                }
                case 11: {
                    this.onResize();
                }
            }
        };
        int[] events = new int[]{12, 3, 7, 5, 4, 8, 9, 11};
        int i = 0;
        while (i < events.length) {
            this.addListener(events[i], listener);
            ++i;
        }
    }

    static int checkStyle(int style) {
        return ((style |= 0x80000) | 0x100000) & 0xFFFFFCFF;
    }

    void _setCursor(Cursor cursor) {
        if (this.cursor != null) {
            return;
        }
        super.setCursor(cursor);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        this.wrapItems((this.style & 0x200) != 0 ? hHint : wHint);
        boolean flat = (this.style & 0x800000) != 0;
        int row = 0;
        while (row < this.items.length) {
            int rowWidth = 0;
            int rowHeight = 0;
            int i = 0;
            while (i < this.items[row].length) {
                CoolItem item = this.items[row][i];
                rowWidth += item.preferredWidth;
                rowHeight = Math.max(rowHeight, item.preferredHeight);
                ++i;
            }
            height += rowHeight;
            if (!flat && row > 0) {
                height += 2;
            }
            width = Math.max(width, rowWidth);
            ++row;
        }
        this.wrapItems(this.getWidth());
        if (width == 0) {
            width = 0;
        }
        if (height == 0) {
            height = 0;
        }
        Point size = this.fixPoint(width, height);
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    CoolItem getGrabbedItem(int x, int y) {
        int row = 0;
        while (row < this.items.length) {
            int i = 0;
            while (i < this.items[row].length) {
                CoolItem item = this.items[row][i];
                Rectangle bounds = item.internalGetBounds();
                bounds.width = 10;
                if (bounds.x > x) break;
                if (bounds.y > y) {
                    return null;
                }
                if (bounds.contains(x, y)) {
                    return item;
                }
                ++i;
            }
            ++row;
        }
        return null;
    }

    public CoolItem getItem(int index) {
        this.checkWidget();
        if (index < 0) {
            this.error(6);
        }
        int row = 0;
        while (row < this.items.length) {
            if (this.items[row].length > index) {
                return this.items[row][index];
            }
            index -= this.items[row].length;
            ++row;
        }
        this.error(6);
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.originalItems.length;
    }

    public CoolItem[] getItems() {
        this.checkWidget();
        CoolItem[] result = new CoolItem[this.getItemCount()];
        int offset = 0;
        int row = 0;
        while (row < this.items.length) {
            System.arraycopy(this.items[row], 0, result, offset, this.items[row].length);
            offset += this.items[row].length;
            ++row;
        }
        return result;
    }

    Point findItem(CoolItem item) {
        int row = 0;
        while (row < this.items.length) {
            int i = 0;
            while (i < this.items[row].length) {
                if (this.items[row][i].equals(item)) {
                    return new Point(i, row);
                }
                ++i;
            }
            ++row;
        }
        return new Point(-1, -1);
    }

    void fixEvent(Event event) {
        if ((this.style & 0x200) != 0) {
            int tmp = event.x;
            event.x = event.y;
            event.y = tmp;
        }
    }

    Rectangle fixRectangle(int x, int y, int width, int height) {
        if ((this.style & 0x200) != 0) {
            return new Rectangle(y, x, height, width);
        }
        return new Rectangle(x, y, width, height);
    }

    Point fixPoint(int x, int y) {
        if ((this.style & 0x200) != 0) {
            return new Point(y, x);
        }
        return new Point(x, y);
    }

    public int indexOf(CoolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int answer = 0;
        int row = 0;
        while (row < this.items.length) {
            int i = 0;
            while (i < this.items[row].length) {
                if (this.items[row][i].equals(item)) {
                    return answer;
                }
                ++answer;
                ++i;
            }
            ++row;
        }
        return -1;
    }

    boolean insertItemIntoRow(CoolItem item, int rowIndex, int x_root) {
        if (rowIndex < 0 || rowIndex >= this.items.length) {
            boolean bottom = rowIndex >= this.items.length;
            CoolItem[][] newRows = new CoolItem[this.items.length + 1][];
            System.arraycopy(this.items, 0, newRows, bottom ? 0 : 1, this.items.length);
            int row = bottom ? this.items.length : 0;
            newRows[row] = new CoolItem[1];
            newRows[row][0] = item;
            this.items = newRows;
            item.wrap = true;
            return true;
        }
        int barWidth = this.getWidth();
        Rectangle bounds = this.items[rowIndex][0].internalGetBounds();
        int rowY = bounds.y;
        int oldRowHeight = bounds.height;
        int x = Math.max(0, Math.abs(x_root - this.toDisplay((int)0, (int)0).x));
        int index = 0;
        while (index < this.items[rowIndex].length) {
            if (x < this.items[rowIndex][index].internalGetBounds().x) break;
            ++index;
        }
        if (index == 0) {
            item.wrap = true;
            this.items[rowIndex][0].wrap = false;
        }
        int oldLength = this.items[rowIndex].length;
        CoolItem[] newRow = new CoolItem[oldLength + 1];
        System.arraycopy(this.items[rowIndex], 0, newRow, 0, index);
        newRow[index] = item;
        System.arraycopy(this.items[rowIndex], index, newRow, index + 1, oldLength - index);
        this.items[rowIndex] = newRow;
        if (index > 0) {
            CoolItem left = this.items[rowIndex][index - 1];
            Rectangle leftBounds = left.internalGetBounds();
            int newWidth = x - leftBounds.x;
            if (newWidth < left.internalGetMinimumWidth()) {
                x += left.internalGetMinimumWidth() - newWidth;
                newWidth = left.internalGetMinimumWidth();
            }
            left.setBounds(leftBounds.x, leftBounds.y, newWidth, leftBounds.height);
            left.requestedWidth = newWidth;
        }
        int width = 0;
        int height = item.preferredHeight;
        if (index < this.items[rowIndex].length - 1) {
            CoolItem right;
            width = right.internalGetBounds().x - x;
            right = this.items[rowIndex][index + 1];
            if (width < right.internalGetMinimumWidth()) {
                this.moveRight(right, right.internalGetMinimumWidth() - width);
                width = right.internalGetBounds().x - x;
            }
            item.setBounds(x, rowY, width, height);
            if (width < item.internalGetMinimumWidth()) {
                this.moveLeft(item, item.internalGetMinimumWidth() - width);
            }
        } else {
            width = Math.max(item.internalGetMinimumWidth(), barWidth - x);
            item.setBounds(x, rowY, width, height);
            if (x + width > barWidth) {
                this.moveLeft(item, x + width - barWidth);
            }
        }
        bounds = item.internalGetBounds();
        item.requestedWidth = bounds.width;
        this.internalRedraw(bounds.x, bounds.y, item.internalGetMinimumWidth(), bounds.height);
        return height > oldRowHeight;
    }

    void internalRedraw(int x, int y, int width, int height) {
        if ((this.style & 0x200) != 0) {
            this.redraw(y, x, height, width, false);
        } else {
            this.redraw(x, y, width, height, false);
        }
    }

    void createItem(CoolItem item, int index) {
        int itemCount = this.getItemCount();
        int row = 0;
        if (index < 0 || index > itemCount) {
            this.error(6);
        }
        if (this.items.length == 0) {
            this.items = new CoolItem[1][1];
            this.items[0][0] = item;
        } else {
            int i = index;
            if (index < itemCount) {
                while (i > this.items[row].length) {
                    i -= this.items[row].length;
                    ++row;
                }
            } else {
                row = this.items.length - 1;
                i = this.items[row].length;
            }
            int lastIndex = this.items[row].length - 1;
            CoolItem lastItem = this.items[row][lastIndex];
            if (lastItem.ideal) {
                Rectangle bounds = lastItem.internalGetBounds();
                bounds.width = lastItem.preferredWidth;
                bounds.height = lastItem.preferredHeight;
                lastItem.requestedWidth = lastItem.preferredWidth;
                lastItem.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
            }
            if (i == 0) {
                item.wrap = true;
                this.items[row][0].wrap = false;
            }
            int oldLength = this.items[row].length;
            CoolItem[] newRow = new CoolItem[oldLength + 1];
            System.arraycopy(this.items[row], 0, newRow, 0, i);
            newRow[i] = item;
            System.arraycopy(this.items[row], i, newRow, i + 1, oldLength - i);
            this.items[row] = newRow;
        }
        item.requestedWidth = 10;
        int length = this.originalItems.length;
        CoolItem[] newOriginals = new CoolItem[length + 1];
        System.arraycopy(this.originalItems, 0, newOriginals, 0, index);
        System.arraycopy(this.originalItems, index, newOriginals, index + 1, length - index);
        newOriginals[index] = item;
        this.originalItems = newOriginals;
        this.layoutItems();
    }

    void destroyItem(CoolItem item) {
        if (this.inDispose) {
            return;
        }
        int row = this.findItem((CoolItem)item).y;
        if (row == -1) {
            return;
        }
        Rectangle bounds = item.internalGetBounds();
        this.removeItemFromRow(item, row, true);
        int index = 0;
        while (index < this.originalItems.length) {
            if (this.originalItems[index] == item) break;
            ++index;
        }
        int length = this.originalItems.length - 1;
        CoolItem[] newOriginals = new CoolItem[length];
        System.arraycopy(this.originalItems, 0, newOriginals, 0, index);
        System.arraycopy(this.originalItems, index + 1, newOriginals, index, length - index);
        this.originalItems = newOriginals;
        this.internalRedraw(bounds.x, bounds.y, 10, bounds.height);
        this.relayout();
    }

    void moveDown(CoolItem item, int x_root) {
        int oldRowIndex = this.findItem((CoolItem)item).y;
        if (this.items[oldRowIndex].length == 1 && oldRowIndex == this.items.length - 1) {
            return;
        }
        int newRowIndex = this.items[oldRowIndex].length == 1 ? oldRowIndex : oldRowIndex + 1;
        boolean resize = this.removeItemFromRow(item, oldRowIndex, false);
        Rectangle old = item.internalGetBounds();
        this.internalRedraw(old.x, old.y, 10, old.height);
        if (resize |= this.insertItemIntoRow(item, newRowIndex, x_root)) {
            this.relayout();
        } else {
            this.layoutItems();
        }
    }

    void moveLeft(CoolItem item, int pixels) {
        Point point = this.findItem(item);
        int row = point.y;
        int index = point.x;
        if (index == 0) {
            return;
        }
        Rectangle bounds = item.internalGetBounds();
        int minSpaceOnLeft = 0;
        int i = 0;
        while (i < index) {
            minSpaceOnLeft += this.items[row][i].internalGetMinimumWidth();
            ++i;
        }
        int x = Math.max(minSpaceOnLeft, bounds.x - pixels);
        CoolItem left = this.items[row][index - 1];
        Rectangle leftBounds = left.internalGetBounds();
        if (leftBounds.x + left.internalGetMinimumWidth() > x) {
            int shift = leftBounds.x + left.internalGetMinimumWidth() - x;
            this.moveLeft(left, shift);
            leftBounds = left.internalGetBounds();
        }
        int leftWidth = Math.max(left.internalGetMinimumWidth(), leftBounds.width - pixels);
        left.setBounds(leftBounds.x, leftBounds.y, leftWidth, leftBounds.height);
        left.requestedWidth = leftWidth;
        int width = bounds.width + (bounds.x - x);
        item.setBounds(x, bounds.y, width, bounds.height);
        item.requestedWidth = width;
        int damagedWidth = bounds.x - x + 10;
        if (damagedWidth > 10) {
            this.internalRedraw(x, bounds.y, damagedWidth, bounds.height);
        }
    }

    void moveRight(CoolItem item, int pixels) {
        Point point = this.findItem(item);
        int row = point.y;
        int index = point.x;
        if (index == 0) {
            return;
        }
        Rectangle bounds = item.internalGetBounds();
        int minSpaceOnRight = 0;
        int i = index;
        while (i < this.items[row].length) {
            minSpaceOnRight += this.items[row][i].internalGetMinimumWidth();
            ++i;
        }
        int max = this.getWidth() - minSpaceOnRight;
        int x = Math.min(max, bounds.x + pixels);
        int width = 0;
        if (index + 1 == this.items[row].length) {
            width = this.getWidth() - x;
        } else {
            CoolItem right = this.items[row][index + 1];
            Rectangle rightBounds = right.internalGetBounds();
            if (x + item.internalGetMinimumWidth() > rightBounds.x) {
                int shift = x + item.internalGetMinimumWidth() - rightBounds.x;
                this.moveRight(right, shift);
                rightBounds = right.internalGetBounds();
            }
            width = rightBounds.x - x;
        }
        item.setBounds(x, bounds.y, width, bounds.height);
        item.requestedWidth = width;
        CoolItem left = this.items[row][index - 1];
        Rectangle leftBounds = left.internalGetBounds();
        int leftWidth = x - leftBounds.x;
        left.setBounds(leftBounds.x, leftBounds.y, leftWidth, leftBounds.height);
        left.requestedWidth = leftWidth;
        int damagedWidth = x - bounds.x + 10 + 4;
        if (x - bounds.x > 0) {
            this.internalRedraw(bounds.x - 4, bounds.y, damagedWidth, bounds.height);
        }
    }

    void moveUp(CoolItem item, int x_root) {
        Point point = this.findItem(item);
        int oldRowIndex = point.y;
        if (this.items[oldRowIndex].length == 1 && oldRowIndex == 0) {
            return;
        }
        boolean resize = this.removeItemFromRow(item, oldRowIndex, false);
        Rectangle old = item.internalGetBounds();
        this.internalRedraw(old.x, old.y, 10, old.height);
        int newRowIndex = oldRowIndex - 1;
        if (resize |= this.insertItemIntoRow(item, newRowIndex, x_root)) {
            this.relayout();
        } else {
            this.layoutItems();
        }
    }

    void onDispose(Event event) {
        if (this.inDispose) {
            return;
        }
        this.inDispose = true;
        this.notifyListeners(12, event);
        event.type = 0;
        int i = 0;
        while (i < this.items.length) {
            int j = 0;
            while (j < this.items[i].length) {
                this.items[i][j].dispose();
                ++j;
            }
            ++i;
        }
        this.hoverCursor.dispose();
        this.dragCursor.dispose();
        this.cursor = null;
    }

    void onMouseDown(Event event) {
        if (this.isLocked || event.button != 1) {
            return;
        }
        this.fixEvent(event);
        this.dragging = this.getGrabbedItem(event.x, event.y);
        if (this.dragging != null) {
            this.mouseXOffset = event.x;
            this.itemXOffset = this.mouseXOffset - this.dragging.internalGetBounds().x;
            this._setCursor(this.dragCursor);
        }
        this.fixEvent(event);
    }

    void onMouseExit() {
        if (this.dragging == null) {
            this._setCursor(null);
        }
    }

    void onMouseMove(Event event) {
        if (this.isLocked) {
            return;
        }
        this.fixEvent(event);
        CoolItem grabbed = this.getGrabbedItem(event.x, event.y);
        if (this.dragging != null) {
            int distance;
            int left_root = this.toDisplay((int)(event.x - this.itemXOffset), (int)event.y).x;
            Rectangle bounds = this.dragging.internalGetBounds();
            if (event.y < bounds.y) {
                this.moveUp(this.dragging, left_root);
            } else if (event.y > bounds.y + bounds.height) {
                this.moveDown(this.dragging, left_root);
            } else if (event.x < this.mouseXOffset) {
                int distance2 = Math.min(this.mouseXOffset, bounds.x + this.itemXOffset) - event.x;
                if (distance2 > 0) {
                    this.moveLeft(this.dragging, distance2);
                }
            } else if (event.x > this.mouseXOffset && (distance = event.x - Math.max(this.mouseXOffset, bounds.x + this.itemXOffset)) > 0) {
                this.moveRight(this.dragging, distance);
            }
            this.mouseXOffset = event.x;
        } else if (grabbed != null) {
            this._setCursor(this.hoverCursor);
        } else {
            this._setCursor(null);
        }
        this.fixEvent(event);
    }

    void onMouseUp(Event event) {
        this.dragging = null;
        CoolItem grabbed = this.getGrabbedItem(event.x, event.y);
        if (grabbed != null) {
            this._setCursor(this.hoverCursor);
        } else {
            this._setCursor(null);
        }
    }

    void onMouseDoubleClick(Event event) {
        if (this.isLocked) {
            return;
        }
        this.dragging = null;
        this.fixEvent(event);
        CoolItem target = this.getGrabbedItem(event.x, event.y);
        if (target == null) {
            this._setCursor(null);
        } else {
            Point location = this.findItem(target);
            int row = location.y;
            int index = location.x;
            if (this.items[row].length > 1) {
                Rectangle bounds = target.internalGetBounds();
                int maxSize = this.getWidth();
                int i = 0;
                while (i < this.items[row].length) {
                    if (i != index) {
                        maxSize -= this.items[row][i].internalGetMinimumWidth();
                    }
                    ++i;
                }
                if (bounds.width == maxSize) {
                    distance = bounds.width - target.internalGetMinimumWidth();
                    if (index + 1 < this.items[row].length) {
                        CoolItem right = this.items[row][index + 1];
                        this.moveLeft(right, distance);
                    } else {
                        this.moveRight(target, distance);
                    }
                } else if (bounds.width < target.preferredWidth) {
                    distance = target.preferredWidth - bounds.width;
                    if (index + 1 < this.items[row].length) {
                        CoolItem right = this.items[row][index + 1];
                        this.moveRight(right, distance);
                        distance = target.preferredWidth - target.internalGetBounds().width;
                    }
                    if (distance > 0) {
                        this.moveLeft(target, distance);
                    }
                } else {
                    i = 0;
                    while (i < this.items[row].length) {
                        if (i != index) {
                            CoolItem item = this.items[row][i];
                            item.requestedWidth = Math.max(item.internalGetMinimumWidth(), 10);
                        }
                        ++i;
                    }
                    target.requestedWidth = maxSize;
                    this.layoutItems();
                }
                this._setCursor(this.hoverCursor);
            }
        }
        this.fixEvent(event);
    }

    void onPaint(Event event) {
        GC gc = event.gc;
        if (this.items.length == 0) {
            return;
        }
        Color shadowColor = this.display.getSystemColor(18);
        Color highlightColor = this.display.getSystemColor(20);
        boolean vertical = (this.style & 0x200) != 0;
        boolean flat = (this.style & 0x800000) != 0;
        int stopX = this.getWidth();
        Rectangle clipping = gc.getClipping();
        int row = 0;
        while (row < this.items.length) {
            Rectangle rect;
            Rectangle bounds = new Rectangle(0, 0, 0, 0);
            int i = 0;
            while (i < this.items[row].length) {
                bounds = this.items[row][i].internalGetBounds();
                rect = this.fixRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                if (clipping.intersects(rect)) {
                    boolean nativeGripper = false;
                    if (!this.isLocked) {
                        rect = this.fixRectangle(bounds.x, bounds.y, 10, bounds.height);
                        if (!flat) {
                            nativeGripper = this.drawGripper(gc, rect.x, rect.y, rect.width, rect.height, vertical);
                        }
                        if (!nativeGripper) {
                            int grabberTrim = 2;
                            int grabberHeight = bounds.height - 2 * grabberTrim - 1;
                            gc.setForeground(shadowColor);
                            rect = this.fixRectangle(bounds.x + 4, bounds.y + grabberTrim, 2, grabberHeight);
                            gc.drawRectangle(rect);
                            gc.setForeground(highlightColor);
                            rect = this.fixRectangle(bounds.x + 4, bounds.y + grabberTrim + 1, bounds.x + 4, bounds.y + grabberTrim + grabberHeight - 1);
                            gc.drawLine(rect.x, rect.y, rect.width, rect.height);
                            rect = this.fixRectangle(bounds.x + 4, bounds.y + grabberTrim, bounds.x + 4 + 1, bounds.y + grabberTrim);
                            gc.drawLine(rect.x, rect.y, rect.width, rect.height);
                        }
                    }
                    if (!flat && !nativeGripper && i != 0) {
                        gc.setForeground(shadowColor);
                        rect = this.fixRectangle(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height - 1);
                        gc.drawLine(rect.x, rect.y, rect.width, rect.height);
                        gc.setForeground(highlightColor);
                        rect = this.fixRectangle(bounds.x + 1, bounds.y, bounds.x + 1, bounds.y + bounds.height - 1);
                        gc.drawLine(rect.x, rect.y, rect.width, rect.height);
                    }
                }
                ++i;
            }
            if (!flat && row + 1 < this.items.length) {
                int separatorY = bounds.y + bounds.height;
                gc.setForeground(shadowColor);
                rect = this.fixRectangle(0, separatorY, stopX, separatorY);
                gc.drawLine(rect.x, rect.y, rect.width, rect.height);
                gc.setForeground(highlightColor);
                rect = this.fixRectangle(0, separatorY + 1, stopX, separatorY + 1);
                gc.drawLine(rect.x, rect.y, rect.width, rect.height);
            }
            ++row;
        }
    }

    void onResize() {
        this.layoutItems();
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        CoolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            CoolItem item = items[i];
            if (item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    boolean removeItemFromRow(CoolItem item, int rowIndex, boolean disposed) {
        int index = this.findItem((CoolItem)item).x;
        int newLength = this.items[rowIndex].length - 1;
        Rectangle itemBounds = item.internalGetBounds();
        int oldRowHeight = itemBounds.height;
        item.wrap = false;
        if (newLength <= 0) {
            CoolItem[][] newRows = new CoolItem[this.items.length - 1][];
            System.arraycopy(this.items, 0, newRows, 0, rowIndex);
            System.arraycopy(this.items, rowIndex + 1, newRows, rowIndex, newRows.length - rowIndex);
            this.items = newRows;
            return true;
        }
        CoolItem[] newRow = new CoolItem[newLength];
        System.arraycopy(this.items[rowIndex], 0, newRow, 0, index);
        System.arraycopy(this.items[rowIndex], index + 1, newRow, index, newRow.length - index);
        this.items[rowIndex] = newRow;
        this.items[rowIndex][0].wrap = true;
        if (!disposed) {
            if (index == 0) {
                CoolItem first = this.items[rowIndex][0];
                bounds = first.internalGetBounds();
                width = bounds.x + bounds.width;
                first.setBounds(0, bounds.y, width, bounds.height);
                first.requestedWidth = width;
                this.internalRedraw(bounds.x, bounds.y, 10, bounds.height);
            } else {
                CoolItem previous = this.items[rowIndex][index - 1];
                bounds = previous.internalGetBounds();
                width = bounds.width + itemBounds.width;
                previous.setBounds(bounds.x, bounds.y, width, bounds.height);
                previous.requestedWidth = width;
            }
        }
        int newRowHeight = 0;
        int i = 0;
        while (i < newLength) {
            newRowHeight = Math.max(newRowHeight, this.items[rowIndex][i].preferredHeight);
            ++i;
        }
        return newRowHeight != oldRowHeight;
    }

    int layoutItems() {
        int y = 0;
        int width = (this.style & 0x200) != 0 ? this.getClientArea().height : this.getClientArea().width;
        this.wrapItems(width);
        int rowSpacing = (this.style & 0x800000) != 0 ? 0 : 2;
        int row = 0;
        while (row < this.items.length) {
            int count = this.items[row].length;
            int x = 0;
            int rowHeight = 0;
            int available = width;
            int i = 0;
            while (i < count) {
                CoolItem item = this.items[row][i];
                rowHeight = Math.max(rowHeight, item.preferredHeight);
                available -= item.internalGetMinimumWidth();
                ++i;
            }
            if (row > 0) {
                y += rowSpacing;
            }
            i = 0;
            while (i < count) {
                Rectangle newBounds;
                Rectangle oldBounds;
                CoolItem child = this.items[row][i];
                int newWidth = available + child.internalGetMinimumWidth();
                if (i + 1 < count) {
                    newWidth = Math.min(newWidth, child.requestedWidth);
                    available -= newWidth - child.internalGetMinimumWidth();
                }
                if (!(oldBounds = child.internalGetBounds()).equals(newBounds = new Rectangle(x, y, newWidth, rowHeight))) {
                    child.setBounds(newBounds.x, newBounds.y, newBounds.width, newBounds.height);
                    Rectangle damage = new Rectangle(0, 0, 0, 0);
                    if (oldBounds.y != newBounds.y) {
                        damage = newBounds;
                        damage.add(oldBounds);
                        damage.y -= rowSpacing;
                        damage.height += 2 * rowSpacing;
                    } else if (oldBounds.height != newBounds.height) {
                        damage.y = newBounds.y + Math.min(oldBounds.height, newBounds.height) - 3;
                        damage.height = newBounds.y + newBounds.height + rowSpacing;
                        damage.x = oldBounds.x - 4;
                        damage.width = oldBounds.width + 4;
                    } else if (oldBounds.x != newBounds.x) {
                        damage.x = Math.min(oldBounds.x, newBounds.x);
                        damage.width = Math.abs(oldBounds.x - newBounds.x) + 10;
                        damage.y = oldBounds.y;
                        damage.height = oldBounds.height;
                    }
                    this.internalRedraw(damage.x, damage.y, damage.width, damage.height);
                }
                x += newWidth;
                ++i;
            }
            y += rowHeight;
            ++row;
        }
        return y;
    }

    void relayout() {
        Point size = this.getSize();
        int height = this.layoutItems();
        if ((this.style & 0x200) != 0) {
            Rectangle trim = this.computeTrim(0, 0, height, 0);
            if (height != size.x) {
                super.setSize(trim.width, size.y);
            }
        } else {
            Rectangle trim = this.computeTrim(0, 0, 0, height);
            if (height != size.y) {
                super.setSize(size.x, trim.height);
            }
        }
    }

    public int[] getItemOrder() {
        this.checkWidget();
        int count = this.getItemCount();
        int[] indices = new int[count];
        count = 0;
        int i = 0;
        while (i < this.items.length) {
            int j = 0;
            while (j < this.items[i].length) {
                CoolItem item = this.items[i][j];
                int index = 0;
                while (index < this.originalItems.length) {
                    if (this.originalItems[index] == item) break;
                    ++index;
                }
                if (index == this.originalItems.length) {
                    this.error(8);
                }
                indices[count++] = index;
                ++j;
            }
            ++i;
        }
        return indices;
    }

    @Override
    public void setBackground(Color color) {
        CoolItem[] coolItemArray = this.originalItems;
        int n = this.originalItems.length;
        int n2 = 0;
        while (n2 < n) {
            CoolItem ci = coolItemArray[n2];
            Control ctrl = ci.getControl();
            if (ctrl != null) {
                ctrl.setBackground(color);
            }
            ++n2;
        }
        super.setBackground(color);
    }

    void setItemOrder(int[] itemOrder) {
        int count;
        if (itemOrder == null) {
            this.error(4);
        }
        if (itemOrder.length != (count = this.originalItems.length)) {
            this.error(5);
        }
        boolean[] set = new boolean[count];
        int i = 0;
        while (i < set.length) {
            set[i] = false;
            ++i;
        }
        i = 0;
        while (i < itemOrder.length) {
            if (itemOrder[i] < 0 || itemOrder[i] >= count) {
                this.error(5);
            }
            if (set[itemOrder[i]]) {
                this.error(5);
            }
            set[itemOrder[i]] = true;
            ++i;
        }
        CoolItem[] row = new CoolItem[count];
        int i2 = 0;
        while (i2 < count) {
            row[i2] = this.originalItems[itemOrder[i2]];
            ++i2;
        }
        this.items = new CoolItem[1][count];
        this.items[0] = row;
    }

    public Point[] getItemSizes() {
        this.checkWidget();
        CoolItem[] items = this.getItems();
        Point[] sizes = new Point[items.length];
        int i = 0;
        while (i < items.length) {
            sizes[i] = items[i].getSize();
            ++i;
        }
        return sizes;
    }

    void setItemSizes(Point[] sizes) {
        CoolItem[] items;
        if (sizes == null) {
            this.error(4);
        }
        if (sizes.length != (items = this.getItems()).length) {
            this.error(5);
        }
        int i = 0;
        while (i < items.length) {
            items[i].setSize(sizes[i]);
            ++i;
        }
    }

    public boolean getLocked() {
        this.checkWidget();
        return this.isLocked;
    }

    int getWidth() {
        if ((this.style & 0x200) != 0) {
            return this.getSize().y;
        }
        return this.getSize().x;
    }

    public int[] getWrapIndices() {
        this.checkWidget();
        if (this.items.length <= 1) {
            return new int[0];
        }
        int[] wrapIndices = new int[this.items.length - 1];
        int i = 0;
        int nextWrap = this.items[0].length;
        int row = 1;
        while (row < this.items.length) {
            if (this.items[row][0].wrap) {
                wrapIndices[i++] = nextWrap;
            }
            nextWrap += this.items[row].length;
            ++row;
        }
        if (i != wrapIndices.length) {
            int[] tmp = new int[i];
            System.arraycopy(wrapIndices, 0, tmp, 0, i);
            return tmp;
        }
        return wrapIndices;
    }

    public void setLocked(boolean locked) {
        this.checkWidget();
        if (this.isLocked != locked) {
            this.redraw();
        }
        this.isLocked = locked;
    }

    public void setWrapIndices(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            indices = new int[]{};
        }
        int count = this.originalItems.length;
        int i = 0;
        while (i < indices.length) {
            if (indices[i] < 0 || indices[i] >= count) {
                this.error(5);
            }
            ++i;
        }
        i = 0;
        while (i < this.originalItems.length) {
            this.originalItems[i].wrap = false;
            ++i;
        }
        i = 0;
        while (i < indices.length) {
            int index = indices[i];
            int row = 0;
            while (row < this.items.length) {
                if (this.items[row].length > index) {
                    this.items[row][index].wrap = true;
                    break;
                }
                index -= this.items[row].length;
                ++row;
            }
            ++i;
        }
        this.relayout();
    }

    @Override
    void reskinChildren(int flags) {
        if (this.items != null) {
            int row = 0;
            while (row < this.items.length) {
                int i = 0;
                while (i < this.items[row].length) {
                    CoolItem item = this.items[row][i];
                    if (item != null) {
                        item.reskin(flags);
                    }
                    ++i;
                }
                ++row;
            }
        }
        super.reskinChildren(flags);
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.checkWidget();
        this.cursor = cursor;
        super.setCursor(this.cursor);
    }

    public void setItemLayout(int[] itemOrder, int[] wrapIndices, Point[] sizes) {
        this.checkWidget();
        this.setItemOrder(itemOrder);
        this.setWrapIndices(wrapIndices);
        this.setItemSizes(sizes);
        this.relayout();
    }

    @Override
    public void setOrientation(int orientation) {
        super.setOrientation(orientation);
        int row = 0;
        while (row < this.items.length) {
            int column = 0;
            while (column < this.items[row].length) {
                CoolItem item = this.items[row][column];
                if (item.arrowImage != null) {
                    item.arrowImage.dispose();
                    item.arrowImage = null;
                }
                item.updateChevron();
                ++column;
            }
            ++row;
        }
    }

    void wrapItems(int maxWidth) {
        int itemCount = this.originalItems.length;
        if (itemCount < 2) {
            return;
        }
        CoolItem[] itemsVisual = new CoolItem[itemCount];
        int start = 0;
        int row = 0;
        while (row < this.items.length) {
            System.arraycopy(this.items[row], 0, itemsVisual, start, this.items[row].length);
            start += this.items[row].length;
            ++row;
        }
        CoolItem[][] newItems = new CoolItem[itemCount][];
        int rowCount = 0;
        int rowWidth = 0;
        start = 0;
        int i = 0;
        while (i < itemCount) {
            CoolItem item = itemsVisual[i];
            int itemWidth = item.internalGetMinimumWidth();
            if (i > 0 && item.wrap || maxWidth != -1 && rowWidth + itemWidth > maxWidth) {
                if (i == start) {
                    newItems[rowCount] = new CoolItem[1];
                    newItems[rowCount][0] = item;
                    start = i + 1;
                    rowWidth = 0;
                } else {
                    int count = i - start;
                    newItems[rowCount] = new CoolItem[count];
                    System.arraycopy(itemsVisual, start, newItems[rowCount], 0, count);
                    start = i;
                    rowWidth = itemWidth;
                }
                ++rowCount;
            } else {
                rowWidth += itemWidth;
            }
            ++i;
        }
        if (start < itemCount) {
            int count = itemCount - start;
            newItems[rowCount] = new CoolItem[count];
            System.arraycopy(itemsVisual, start, newItems[rowCount], 0, count);
            ++rowCount;
        }
        if (newItems.length != rowCount) {
            CoolItem[][] tmp = new CoolItem[rowCount][];
            System.arraycopy(newItems, 0, tmp, 0, rowCount);
            this.items = tmp;
        } else {
            this.items = newItems;
        }
    }
}

