/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.xml.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.xml.Element;
import org.eclipse.modisco.xml.internal.resource.GenericXMLHandler;
import org.eclipse.modisco.xml.internal.resource.GenericXMLWriter;
import org.eclipse.modisco.xml.plugin.XmlActivator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class GenericXMLResourceImpl
extends ResourceImpl {
    public GenericXMLResourceImpl(URI uri) {
        super(uri);
    }

    protected final void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        try {
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setValidating(false);
            SAXParser p = f.newSAXParser();
            GenericXMLHandler handler = new GenericXMLHandler((Resource)this, options);
            XMLReader reader = p.getXMLReader();
            try {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            }
            catch (SAXNotRecognizedException e) {
                Status warning = new Status(1, "org.eclipse.modisco.xml", "Default XML sax parser does not support lexical handling.\nDTDs and comment informations will not be available.");
                XmlActivator.getDefault().getLog().log((IStatus)warning);
            }
            try {
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXNotRecognizedException e) {
                Logger.logWarning((Throwable)e, (Plugin)XmlActivator.getDefault());
            }
            p.parse(inputStream, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    protected final void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        GenericXMLWriter writer = new GenericXMLWriter(outputStream);
        for (EObject topLevelObject : this.getContents()) {
            writer.serialize((Element)topLevelObject);
        }
        writer.flush();
        writer.close();
    }
}

