/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.common.core.internal.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.infra.common.core.internal.CommonModiscoActivator;

public class MoDiscoLogHandler
extends Handler {
    private File logFile;
    private PrintWriter pWriter;

    public MoDiscoLogHandler(String filePath) {
        this.logFile = new File(filePath);
        if (!this.logFile.isAbsolute()) {
            this.logFile = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(filePath).toFile();
        }
        try {
            this.pWriter = new PrintWriter(this.logFile);
        }
        catch (FileNotFoundException e) {
            Logger.logError((Throwable)e, (Plugin)CommonModiscoActivator.getDefault());
        }
    }

    @Override
    public void close() {
        if (this.pWriter != null) {
            this.pWriter.close();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        if (this.pWriter != null) {
            this.pWriter.println(record.getMessage());
        }
    }
}

