/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.profiler.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.adt.ui.outline.AtlLabelProvider;
import org.eclipse.m2m.atl.common.ATLLogger;

public final class ATLModelHandler {
    private static ATLModelHandler instance;
    private AtlLabelProvider labelProvider;
    private EObject atlModel;
    private Map<String, EObject> registry;
    private boolean debugMessages;

    private ATLModelHandler() {
    }

    public static ATLModelHandler getInstance() {
        if (instance == null) {
            instance = new ATLModelHandler();
        }
        return instance;
    }

    public void init() {
        this.labelProvider = new AtlLabelProvider();
        this.registry = new HashMap<String, EObject>();
    }

    public void registerATLModel(EObject model) {
        this.atlModel = model;
        this.registerElements(model);
    }

    private void registerElements(EObject eo) {
        String name = this.getName(eo).trim();
        if (!name.equals("<default>")) {
            this.registry.put(name, eo);
            for (EObject o : eo.eContents()) {
                this.registerElements(o);
            }
            if (this.debugMessages) {
                ATLLogger.info((String)("atl registry : [" + name + "]"));
            }
        }
    }

    private String getName(EObject eo) {
        return this.labelProvider.getText((Object)eo).trim().split(":")[0];
    }

    public static boolean isNativeOperation(String name) {
        return name.equals("__exec__") || name.equals("__matcher__") || name.equals("__resolve__");
    }

    public String getATLName(String sfOpName) {
        String name = "";
        name = sfOpName.contains("__apply") ? sfOpName.split("__apply")[1] : (sfOpName.contains("__match") & !sfOpName.contains("__matcher__") ? sfOpName.split("__match")[1] : (sfOpName.contains("__init") ? sfOpName.split("__init")[1] : sfOpName));
        return name;
    }

    public EObject getATLOperationFromName(String sfOpName) {
        String name = this.getATLName(sfOpName);
        EObject o = this.registry.get(name);
        return o;
    }

    public EObject getAtlModel() {
        return this.atlModel;
    }

    public void setAtlModel(EObject atlModel) {
        this.atlModel = atlModel;
    }
}

