/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.core.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.axis.constants.Scope;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.GeneratedFileInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.axis.consumption.core.AxisConsumptionCoreMessages;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.core.context.AxisEmitterContext;
import org.eclipse.jst.ws.internal.axis.consumption.core.context.AxisEmitterDefaults;
import org.eclipse.jst.ws.internal.axis.consumption.core.plugin.WebServiceAxisConsumptionCorePlugin;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.ProgressUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.ILog;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class WSDL2JavaCommand
extends AbstractDataModelOperation {
    private final String DEPLOY_TYPE = "deploy";
    private final String UNDEPLOY_TYPE = "undeploy";
    private final String TEMP = "temp";
    private JavaWSDLParameter javaWSDLParam;
    private String wsdlURI;
    private String httpBasicAuthUsername;
    private String httpBasicAuthPassword;
    private List deployFiles;
    private List javaFiles;
    private File tempOutputFile;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status;
        IEnvironment environment = this.getEnvironment();
        ILog envLog = environment.getLog();
        if (this.javaWSDLParam == null) {
            IStatus status2 = StatusUtils.errorStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
            environment.getStatusHandler().reportError(status2);
            return status2;
        }
        if (this.wsdlURI != null) {
            this.javaWSDLParam.setInputWsdlLocation(this.wsdlURI);
        }
        this.javaWSDLParam.setHTTPUsername(this.httpBasicAuthUsername);
        this.javaWSDLParam.setHTTPPassword(this.httpBasicAuthPassword);
        Emitter wsdl2Java = new Emitter();
        if (envLog.isEnabled("emitter")) {
            wsdl2Java.setVerbose(true);
        } else {
            wsdl2Java.setVerbose(false);
        }
        boolean serverSide = this.javaWSDLParam.getServerSide() == 1;
        wsdl2Java.setServerSide(serverSide);
        if (serverSide) {
            wsdl2Java.setSkeletonWanted(this.javaWSDLParam.isSkeletonDeploy());
        }
        this.tempOutputFile = this.createTempDir();
        wsdl2Java.setOutputDir(this.tempOutputFile.toString());
        try {
            try {
                if (this.javaWSDLParam.isMetaInfOnly()) {
                    HashMap pck2nsMap = this.javaWSDLParam.getMappings();
                    if (pck2nsMap != null) {
                        HashMap<String, String> ns2pckMap = new HashMap<String, String>();
                        for (String pakage : pck2nsMap.keySet()) {
                            String namespace = (String)pck2nsMap.get(pakage);
                            ns2pckMap.put(namespace, pakage);
                        }
                        wsdl2Java.setNamespaceMap(ns2pckMap);
                    }
                } else if (this.javaWSDLParam.getMappings() != null) {
                    wsdl2Java.setNamespaceMap(this.javaWSDLParam.getMappings());
                }
                envLog.log(1, 5019, (Object)this, "execute", (Object)("Java output = " + this.javaWSDLParam.getJavaOutput()));
                if (this.javaWSDLParam.getHTTPPassword() != null) {
                    wsdl2Java.setPassword(this.javaWSDLParam.getHTTPPassword());
                    envLog.log(1, 5081, (Object)this, "execute", (Object)("password: " + this.javaWSDLParam.getHTTPPassword()));
                }
                if (this.javaWSDLParam.getHTTPUsername() != null) {
                    wsdl2Java.setUsername(this.javaWSDLParam.getHTTPUsername());
                    envLog.log(1, 5082, (Object)this, "execute", (Object)("username: " + this.javaWSDLParam.getHTTPUsername()));
                }
                envLog.log(1, 5020, (Object)this, "execute", (Object)("WSDL Location = " + this.javaWSDLParam.getInputWsdlLocation()));
                AxisEmitterContext context = WebServiceAxisConsumptionCorePlugin.getInstance().getAxisEmitterContext();
                String wsdl2JavaTimeoutProperty = System.getProperty("AxisWsdl2JavaTimeout");
                if (wsdl2JavaTimeoutProperty != null) {
                    long timeout = new Integer(wsdl2JavaTimeoutProperty).longValue();
                    wsdl2Java.setTimeout(timeout);
                    envLog.log(1, 5091, (Object)this, "execute", (Object)("AxisWsdl2JavaTimeout = " + timeout));
                } else if (context.getTimeOut() != AxisEmitterDefaults.getTimeOutDefault()) {
                    long timeout = context.getTimeOut() == -1 ? -1 : context.getTimeOut() * 1000;
                    wsdl2Java.setTimeout(timeout);
                    envLog.log(1, 5100, (Object)this, "execute", (Object)("Timeout = " + timeout));
                }
                if (context.getDeployScopeType() != AxisEmitterDefaults.getDeployScopeDefault()) {
                    switch (context.getDeployScopeType()) {
                        case 0: {
                            wsdl2Java.setScope(Scope.APPLICATION);
                            envLog.log(1, 5101, (Object)this, "execute", (Object)" Deploy Scope: Application");
                            break;
                        }
                        case 1: {
                            wsdl2Java.setScope(Scope.REQUEST);
                            envLog.log(1, 5102, (Object)this, "execute", (Object)" Deploy Scope: Request");
                            break;
                        }
                        case 2: {
                            wsdl2Java.setScope(Scope.SESSION);
                            envLog.log(1, 5103, (Object)this, "execute", (Object)" Deploy Scope: Session");
                        }
                    }
                }
                if (context.isAllWantedEnabled() != AxisEmitterDefaults.getAllWantedDefault()) {
                    wsdl2Java.setAllWanted(context.isAllWantedEnabled());
                    envLog.log(1, 5104, (Object)this, "execute", (Object)(" set AllWanted : " + context.isAllWantedEnabled()));
                }
                if (context.isHelperWantedEnabled() != AxisEmitterDefaults.getHelperWantedDefault()) {
                    wsdl2Java.setHelperWanted(context.isHelperWantedEnabled());
                    envLog.log(1, 5105, (Object)this, "execute", (Object)(" set HelperWanted : " + context.isHelperWantedEnabled()));
                }
                if (context.isWrapArraysEnabled() != AxisEmitterDefaults.getWrapArraysDefault()) {
                    wsdl2Java.setWrapArrays(context.isWrapArraysEnabled());
                    envLog.log(1, 5106, (Object)this, "execute", (Object)(" set WrapArrays : " + context.isWrapArraysEnabled()));
                }
                ProgressUtils.report((IProgressMonitor)monitor, (String)NLS.bind((String)AxisConsumptionCoreMessages.MSG_PARSING_WSDL, (Object)this.javaWSDLParam.getInputWsdlLocation()));
                wsdl2Java.run(this.javaWSDLParam.getInputWsdlLocation());
                this.javaFiles = wsdl2Java.getGeneratedFileNames();
                this.deployFiles = new ArrayList();
                if (serverSide) {
                    List deploymentFiles1 = wsdl2Java.getGeneratedFileInfo().findType("deploy");
                    List deploymentFiles2 = wsdl2Java.getGeneratedFileInfo().findType("undeploy");
                    if (deploymentFiles1 != null && deploymentFiles2 != null) {
                        deploymentFiles1.addAll(deploymentFiles2);
                        int i = 0;
                        while (i < deploymentFiles1.size()) {
                            GeneratedFileInfo.Entry entry = (GeneratedFileInfo.Entry)deploymentFiles1.get(i);
                            this.deployFiles.add(entry.fileName);
                            ++i;
                        }
                    }
                    this.javaFiles.removeAll(this.deployFiles);
                }
                if (!this.javaWSDLParam.isMetaInfOnly() && this.javaWSDLParam.getMappings() != null) {
                    Map pkg2NsMap = wsdl2Java.getNamespaces().getPkg2NamespacesMap();
                    for (Map.Entry entry : pkg2NsMap.entrySet()) {
                        String pkg = (String)entry.getKey();
                        List nsList = (List)entry.getValue();
                        for (String ns : nsList) {
                            if (!this.javaWSDLParam.getMappings().containsKey(ns)) continue;
                            this.javaWSDLParam.getMappings().put(ns, pkg);
                        }
                    }
                }
                status = this.moveGeneratedFiles(environment, monitor);
            }
            catch (Exception e) {
                envLog.log(4, 5021, (Object)this, "execute", (Throwable)e);
                status = StatusUtils.errorStatus((String)(AxisConsumptionCoreMessages.MSG_ERROR_WSDL_JAVA_GENERATE + " " + e.toString()), (Throwable)e);
                environment.getStatusHandler().reportError(status);
                this.deleteDir(this.tempOutputFile);
            }
        }
        finally {
            this.deleteDir(this.tempOutputFile);
        }
        return status;
    }

    public IStatus moveGeneratedFiles(IEnvironment environment, IProgressMonitor monitor) {
        IStatus status;
        block18: {
            status = Status.OK_STATUS;
            IStatusHandler statusHandler = environment.getStatusHandler();
            FileInputStream finStream = null;
            try {
                try {
                    String outputDir = this.removeFileProtocol(this.javaWSDLParam.getOutput());
                    String javaOutput = this.removeFileProtocol(this.javaWSDLParam.getJavaOutput());
                    ResourceContext context = ((BaseEclipseEnvironment)environment).getResourceContext();
                    Path outputPath = new Path(outputDir);
                    IPath targetPath = null;
                    String tempOutputDir = this.tempOutputFile.toString();
                    String[] movedDeployFiles = new String[this.deployFiles.size()];
                    Iterator iterator = this.deployFiles.iterator();
                    int i = 0;
                    while (iterator.hasNext()) {
                        String deployFile = (String)iterator.next();
                        File source = new File(deployFile);
                        finStream = new FileInputStream(source);
                        if (finStream == null) continue;
                        if (deployFile.startsWith(tempOutputDir)) {
                            String fileName = deployFile.substring(tempOutputDir.length());
                            targetPath = outputPath.append(fileName).makeAbsolute();
                            FileResourceUtils.createFileAtLocation((ResourceContext)context, (IPath)targetPath, (InputStream)finStream, (IProgressMonitor)monitor, (IStatusHandler)statusHandler);
                            movedDeployFiles[i++] = ResourceUtils.getWorkspaceRoot().getFileForLocation(targetPath).getLocation().toString();
                        }
                        finStream.close();
                    }
                    this.javaWSDLParam.setDeploymentFiles(movedDeployFiles);
                    Path javaOutputPath = new Path(javaOutput);
                    String fullClassName = null;
                    Vector<String> movedJavaFiles = new Vector<String>();
                    iterator = this.javaFiles.iterator();
                    i = 0;
                    while (iterator.hasNext()) {
                        IFile file;
                        String javaFile = (String)iterator.next();
                        File source = new File(javaFile);
                        finStream = new FileInputStream(source);
                        if (finStream == null) continue;
                        if (!this.javaWSDLParam.isMetaInfOnly() && javaFile.startsWith(tempOutputDir) && (file = FileResourceUtils.createFileAtLocation((ResourceContext)context, (IPath)(targetPath = javaOutputPath.append(fullClassName = javaFile.substring(tempOutputDir.length())).makeAbsolute()), (InputStream)finStream, (IProgressMonitor)monitor, (IStatusHandler)statusHandler)) != null) {
                            file.setCharset("UTF-8", monitor);
                            movedJavaFiles.add(ResourceUtils.getWorkspaceRoot().getFileForLocation(targetPath).getLocation().toString());
                        }
                        finStream.close();
                    }
                    this.javaWSDLParam.setJavaFiles(movedJavaFiles.toArray(new String[0]));
                }
                catch (Exception e) {
                    status = StatusUtils.errorStatus((String)NLS.bind((String)AxisConsumptionCoreMessages.MSG_ERROR_MOVE_RESOURCE, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
                    statusHandler.reportError(status);
                    if (finStream != null) {
                        try {
                            finStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (finStream != null) {
                    try {
                        finStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (finStream != null) {
                try {
                    finStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return status;
    }

    public void deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                this.deleteDir(new File(dir, children[i]));
                ++i;
            }
        }
        dir.delete();
    }

    private File createTempDir() {
        String pluginTempDir = WebServiceAxisConsumptionCorePlugin.getInstance().getStateLocation().toString();
        File tempDir = new File(pluginTempDir);
        File newTempDir = null;
        try {
            newTempDir = File.createTempFile("temp", "", tempDir);
            if (newTempDir.delete() && newTempDir.mkdir()) {
                tempDir = newTempDir;
            }
            return tempDir;
        }
        catch (Exception exception) {
            return tempDir;
        }
    }

    private String removeFileProtocol(String s) {
        if (s.startsWith("file:")) {
            int k;
            String protocol;
            int j;
            int max;
            String newS = s.substring(5, s.length());
            int i = newS.indexOf(58);
            if (i != -1 && (max = Math.max(j = (protocol = newS.substring(0, i)).indexOf(47), k = protocol.indexOf(92))) != -1) {
                newS = newS.substring(max + 1, newS.length());
            }
            return newS;
        }
        return s;
    }

    public Status undo(IEnvironment environment) {
        return null;
    }

    public Status redo(IEnvironment environment) {
        return null;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setHttpBasicAuthPassword(String httpBasicAuthPassword) {
        this.httpBasicAuthPassword = httpBasicAuthPassword;
    }

    public void setHttpBasicAuthUsername(String httpBasicAuthUsername) {
        this.httpBasicAuthUsername = httpBasicAuthUsername;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }
}

