/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.classpath;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.jst.common.project.facet.core.libprov.osgi.OsgiBundlesContainer;
import org.eclipse.jst.common.project.facet.core.libprov.osgi.OsgiBundlesLibraryProviderInstallOperationConfig;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;

public class WtpOsgiBundlesLibraryProviderInstallOperationConfig
extends OsgiBundlesLibraryProviderInstallOperationConfig {
    private static final IProjectFacet WEB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.web");
    private static final String CLASS_NAME = WtpOsgiBundlesLibraryProviderInstallOperationConfig.class.getName();
    public static final String PROP_INCLUDE_WITH_APPLICATION_ENABLED = String.valueOf(CLASS_NAME) + ".INCLUDE_WITH_APPLICATION_ENABLED";
    public static final String PROP_INCLUDE_WITH_APPLICATION_SETTING_ENABLED = String.valueOf(CLASS_NAME) + ".INCLUDE_WITH_APPLICATION_SETTING_ENABLED";
    private boolean includeWithApplicationEnabled;
    private boolean includeWithApplicationSettingEnabled;
    private IFacetedProjectListener facetedProjectListener;

    public synchronized void init(IFacetedProjectBase fproj, IProjectFacetVersion fv, ILibraryProvider provider) {
        IProjectFacet f;
        ILibraryProvider currentProvider;
        super.init(fproj, fv, provider);
        this.includeWithApplicationEnabled = WtpOsgiBundlesLibraryProviderInstallOperationConfig.hasModuleFacet(fproj);
        IProject project = fproj.getProject();
        if (project != null && (currentProvider = LibraryProviderFramework.getCurrentProvider((IProject)project, (IProjectFacet)(f = fv.getProjectFacet()))) == provider) {
            this.includeWithApplicationEnabled = false;
            IPath path = OsgiBundlesContainer.CONTAINER_PATH.append(f.getId());
            IJavaProject jproj = JavaCore.create((IProject)project);
            try {
                IClasspathEntry[] iClasspathEntryArray = jproj.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry cpe = iClasspathEntryArray[n2];
                    if (path.equals((Object)cpe.getPath())) {
                        IClasspathAttribute[] iClasspathAttributeArray = cpe.getExtraAttributes();
                        int n3 = iClasspathAttributeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IClasspathAttribute attr = iClasspathAttributeArray[n4];
                            if (attr.getName().equals("org.eclipse.jst.component.dependency")) {
                                this.includeWithApplicationEnabled = true;
                                break;
                            }
                            ++n4;
                        }
                    }
                    if (!this.includeWithApplicationEnabled) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        this.includeWithApplicationSettingEnabled = this.includeWithApplicationEnabled ? true : WtpOsgiBundlesLibraryProviderInstallOperationConfig.hasModuleFacet(fproj);
        this.facetedProjectListener = new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                boolean moduleFaceted = WtpOsgiBundlesLibraryProviderInstallOperationConfig.hasModuleFacet((IFacetedProjectBase)event.getWorkingCopy());
                WtpOsgiBundlesLibraryProviderInstallOperationConfig.this.setIncludeWithApplicationEnabled(moduleFaceted);
                WtpOsgiBundlesLibraryProviderInstallOperationConfig.this.setIncludeWithApplicationSettingEnabled(moduleFaceted);
            }
        };
        fproj.addListener(this.facetedProjectListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED});
    }

    public boolean isIncludeWithApplicationEnabled() {
        return this.includeWithApplicationEnabled;
    }

    public void setIncludeWithApplicationEnabled(boolean value) {
        boolean oldValue = this.includeWithApplicationEnabled;
        this.includeWithApplicationEnabled = value;
        this.notifyListeners(PROP_INCLUDE_WITH_APPLICATION_ENABLED, oldValue, this.includeWithApplicationEnabled);
    }

    public boolean isIncludeWithApplicationSettingEnabled() {
        return this.includeWithApplicationSettingEnabled;
    }

    public void setIncludeWithApplicationSettingEnabled(boolean value) {
        boolean oldValue = this.includeWithApplicationSettingEnabled;
        this.includeWithApplicationSettingEnabled = value;
        this.notifyListeners(PROP_INCLUDE_WITH_APPLICATION_SETTING_ENABLED, oldValue, this.includeWithApplicationSettingEnabled);
    }

    public IClasspathAttribute[] getClasspathAttributes() {
        IClasspathAttribute[] iClasspathAttributeArray;
        IFacetedProjectBase fproj = this.getFacetedProject();
        boolean isWebProject = fproj.hasProjectFacet(WEB_FACET);
        IClasspathAttribute attr = null;
        if (this.isIncludeWithApplicationSettingEnabled()) {
            attr = this.isIncludeWithApplicationEnabled() ? JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.dependency", (String)ClasspathDependencyUtil.getDefaultRuntimePath(isWebProject).toString()) : JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.nondependency", (String)"");
        }
        if (attr == null) {
            iClasspathAttributeArray = null;
        } else {
            IClasspathAttribute[] iClasspathAttributeArray2 = new IClasspathAttribute[1];
            iClasspathAttributeArray = iClasspathAttributeArray2;
            iClasspathAttributeArray2[0] = attr;
        }
        return iClasspathAttributeArray;
    }

    private static boolean hasModuleFacet(IFacetedProjectBase fproj) {
        Set moduleFacets = ProjectFacetsManager.getGroup((String)"modules").getMembers();
        for (IProjectFacetVersion facetVersion : fproj.getProjectFacets()) {
            if (!moduleFacets.contains(facetVersion)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        this.getFacetedProject().removeListener(this.facetedProjectListener);
    }
}

