/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockMidx;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectToPack;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFileMidxNPacks;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFileMidxSingle;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndex;
import org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class DfsPackFileMidx
extends DfsPackFile {
    public static DfsPackFileMidx create(DfsBlockCache cache, DfsPackDescription desc, List<DfsPackFile> requiredPacks, @Nullable DfsPackFileMidx base) {
        if (desc.getCoveredPacks().size() == 1) {
            return new DfsPackFileMidxSingle(cache, desc, requiredPacks.get(0), base);
        }
        return new DfsPackFileMidxNPacks(cache, desc, requiredPacks, base);
    }

    protected DfsPackFileMidx(DfsBlockCache cache, DfsPackDescription desc) {
        super(cache, desc);
    }

    public abstract DfsPackFileMidx getMultipackIndexBase();

    public abstract List<DfsPackFile> getCoveredPacks();

    public List<DfsPackFile> getAllCoveredPacks() {
        ArrayList<DfsPackFile> coveredPacks = new ArrayList<DfsPackFile>(this.getCoveredPacks());
        DfsPackFileMidx base = this.getMultipackIndexBase();
        while (base != null) {
            coveredPacks.addAll(base.getCoveredPacks());
            base = base.getMultipackIndexBase();
        }
        return coveredPacks;
    }

    abstract ObjectId getObjectAt(DfsReader var1, long var2) throws IOException;

    protected int getObjectCount(DfsReader ctx) throws IOException {
        return (int)this.getPackDescription().getObjectCount();
    }

    protected abstract byte[] getChecksum(DfsReader var1) throws IOException;

    protected abstract MultiPackIndex.MidxIterator localIterator(DfsReader var1) throws IOException;

    @Override
    public final PackIndex getPackIndex(DfsReader ctx) {
        return new MidxPackIndex(this, ctx);
    }

    abstract List<ObjectToPack> getLocalObjects(DfsReader var1) throws IOException;

    @Override
    public abstract PackReverseIndex getReverseIdx(DfsReader var1) throws IOException;

    @Override
    ObjectLoader load(DfsReader ctx, long midxOffset) throws IOException {
        DfsPackOffset location = this.getOffsetCalculator().decode(midxOffset);
        if (location == null) {
            return null;
        }
        return location.getPack().load(ctx, location.getPackOffset());
    }

    @Override
    void copyAsIs(PackOutputStream out, DfsObjectToPack src, boolean validate, DfsReader ctx) throws IOException, StoredObjectRepresentationNotAvailableException {
        if (src.pack != this) {
            throw new IllegalArgumentException("pack mismatch in object description");
        }
        DfsPackOffset location = this.getOffsetCalculator().decode(src.offset);
        src.offset = location.getPackOffset();
        location.getPack().copyAsIs(out, src, validate, ctx);
        src.offset = location.getPackStart() + location.getPackOffset();
    }

    @Override
    final byte[] getDeltaHeader(DfsReader ctx, long pos) throws IOException, DataFormatException {
        DfsPackOffset location = this.getOffsetCalculator().decode(pos);
        return location.getPack().getDeltaHeader(ctx, location.getPackOffset());
    }

    @Override
    final int getObjectType(DfsReader ctx, long pos) throws IOException {
        DfsPackOffset location = this.getOffsetCalculator().decode(pos);
        return location.getPack().getObjectType(ctx, location.getPackOffset());
    }

    @Override
    final long getObjectSize(DfsReader ctx, long pos) throws IOException {
        if (pos < 0L) {
            return -1L;
        }
        DfsPackOffset location = this.getOffsetCalculator().decode(pos);
        return location.getPack().getObjectSize(ctx, location.getPackOffset());
    }

    @Override
    final void fillRepresentation(DfsObjectRepresentation r, long offset, DfsReader ctx) throws IOException {
        DfsPackOffset location = this.getOffsetCalculator().decode(offset);
        if (location == null) {
            throw new IllegalArgumentException("Invalid offset in midx");
        }
        location.getPack().fillRepresentation(r, location.getPackOffset(), ctx);
        r.offset = offset;
    }

    @Override
    final void fillRepresentation(DfsObjectRepresentation r, long offset, DfsReader ctx, PackReverseIndex rev) {
        throw new UnsupportedOperationException();
    }

    @Override
    final boolean isCorrupt(long offset) {
        DfsPackOffset location = this.getOffsetCalculator().decode(offset);
        if (location == null) {
            throw new IllegalArgumentException("Invalid offset in midx");
        }
        return location.getPack().isCorrupt(location.getPackOffset());
    }

    @Override
    final DfsBlock readOneBlock(long pos, DfsReader ctx, ReadableChannel rc) throws IOException {
        DfsPackOffset location = this.getOffsetCalculator().decode(pos);
        return new DfsBlockMidx(location.getPack().readOneBlock(location.getPackOffset(), ctx, rc), location.getPackStart());
    }

    @Override
    final DfsBlock getOrLoadBlock(long pos, DfsReader ctx) throws IOException {
        DfsPackOffset location = this.getOffsetCalculator().decode(pos);
        return new DfsBlockMidx(location.getPack().getOrLoadBlock(location.getPackOffset(), ctx), location.getPackStart());
    }

    protected abstract VOffsetCalculator getOffsetCalculator();

    protected static final class DfsPackOffset {
        private DfsPackFile pack;
        private long packStart;
        private long midxOffset;

        protected DfsPackOffset() {
        }

        DfsPackOffset setValues(DfsPackFile pack, long packStart, long midxOffset) {
            this.pack = pack;
            this.packStart = packStart;
            this.midxOffset = midxOffset;
            return this;
        }

        DfsPackOffset setMidxOffset(long midxOffset) {
            this.midxOffset = midxOffset;
            return this;
        }

        DfsPackFile getPack() {
            return this.pack;
        }

        long getPackStart() {
            return this.packStart;
        }

        long getPackOffset() {
            return this.midxOffset - this.packStart;
        }
    }

    private static class MidxPackIndex
    implements PackIndex {
        private final DfsPackFileMidx pack;
        private final DfsReader ctx;

        MidxPackIndex(DfsPackFileMidx pack, DfsReader ctx) {
            this.pack = pack;
            this.ctx = ctx;
        }

        @Override
        public Iterator<PackIndex.MutableEntry> iterator() {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        @Override
        public long getObjectCount() {
            try {
                return this.pack.getObjectCount(this.ctx);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public long getOffset64Count() {
            return 0L;
        }

        @Override
        public ObjectId getObjectId(long nthPosition) {
            try {
                return this.pack.getObjectAt(this.ctx, nthPosition);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public long getOffset(long nthPosition) {
            ObjectId objectAt;
            try {
                objectAt = this.pack.getObjectAt(this.ctx, nthPosition);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (objectAt == null) {
                return -1L;
            }
            return this.findOffset(objectAt);
        }

        @Override
        public long findOffset(AnyObjectId objId) {
            try {
                return this.pack.findOffset(this.ctx, objId);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int findPosition(AnyObjectId objId) {
            try {
                return this.pack.findIdxPosition(this.ctx, objId);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public long findCRC32(AnyObjectId objId) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasCRC32Support() {
            return false;
        }

        @Override
        public void resolve(Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) throws IOException {
            this.pack.resolve(this.ctx, matches, id, matchLimit);
        }

        @Override
        public byte[] getChecksum() {
            throw new UnsupportedOperationException();
        }
    }

    protected static interface VOffsetCalculator {
        public DfsPackOffset decode(long var1);

        public long getMaxOffset();
    }
}

