/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.admin.actions;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.ui.internal.admin.bundle.OM;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.net4j.signal.RemoteException;
import org.eclipse.net4j.util.security.NotAuthenticatedException;
import org.eclipse.net4j.util.ui.actions.LongRunningAction;
import org.eclipse.swt.widgets.Shell;

public abstract class AdminAction<T>
extends LongRunningAction {
    protected final T target;

    protected AdminAction(String label, String tooltip, ImageDescriptor imageDescriptor, T target) {
        super(label, tooltip, imageDescriptor);
        this.target = target;
    }

    protected final void doRun(IProgressMonitor progressMonitor) throws Exception {
        try {
            this.safeRun(progressMonitor);
        }
        catch (RemoteException ex) {
            this.handleError(ex.getCause() == null ? ex : ex.getCause());
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    protected abstract void safeRun(IProgressMonitor var1) throws Exception;

    protected void handleError(Throwable ex) {
        if (!(ex instanceof NotAuthenticatedException)) {
            this.showError(ex);
        }
    }

    protected void showError(final Throwable ex) {
        OM.LOG.error(ex);
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)AdminAction.this.getShell(), (String)AdminAction.this.getText(), (String)MessageFormat.format(AdminAction.this.getErrorPattern(), ex.getLocalizedMessage()));
            }
        });
    }

    protected abstract String getErrorPattern();
}

