/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.util.ResourceSetConfigurer;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.IDeactivateable;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public final class ResourceSetConfigurerRegistry
implements ResourceSetConfigurer.Registry {
    public static final ResourceSetConfigurerRegistry INSTANCE = new ResourceSetConfigurerRegistry();

    private ResourceSetConfigurerRegistry() {
    }

    @Override
    public ResourceSetConfigurer getConfigurer(IManagedContainer container, String type) {
        return (ResourceSetConfigurer)container.getElementOrNull("org.eclipse.emf.cdo.common.ResourceSetConfigurers", type);
    }

    @Override
    public ResourceSetConfigurer.Registry.ResourceSetConfiguration configureResourceSet(ResourceSet resourceSet, Object context) {
        return this.configureResourceSet(resourceSet, context, null);
    }

    @Override
    public ResourceSetConfigurer.Registry.ResourceSetConfiguration configureResourceSet(ResourceSet resourceSet, Object context, IManagedContainer container) {
        ResourceSetConfigurer.Registry.ResourceSetConfiguration configuration = null;
        if (container == null) {
            container = ContainerUtil.getContainer((Object)context);
        }
        if (container == null) {
            container = IPluginContainer.INSTANCE;
        }
        for (String type : container.getFactoryTypes("org.eclipse.emf.cdo.common.ResourceSetConfigurers")) {
            ResourceSetConfigurer.Registry.ResourceSetConfiguration c = this.configureResourceSet(resourceSet, context, container, type);
            if (c == null) continue;
            configuration = c;
        }
        return configuration;
    }

    @Override
    public ResourceSetConfigurer.Registry.ResourceSetConfiguration configureResourceSet(ResourceSet resourceSet, Object context, IManagedContainer container, String type) {
        Object configurerResult;
        ResourceSetConfigurer configurer = this.getConfigurer(container, type);
        if (configurer != null && (configurerResult = configurer.configureResourceSet(resourceSet, context, container)) != null) {
            ResourceSetConfigurationImpl configuration = (ResourceSetConfigurationImpl)ResourceSetConfigurer.Registry.ResourceSetConfiguration.of(resourceSet);
            if (configuration == null) {
                configuration = new ResourceSetConfigurationImpl(resourceSet);
            }
            configuration.configurerResults.put(type, configurerResult);
            return configuration;
        }
        return null;
    }

    public static final class ResourceSetConfigurationImpl
    extends AdapterImpl
    implements ResourceSetConfigurer.Registry.ResourceSetConfiguration,
    IDeactivateable {
        private final ResourceSet resourceSet;
        private final Map<String, Object> configurerResults = new HashMap<String, Object>();
        private boolean active = true;

        private ResourceSetConfigurationImpl(ResourceSet resourceSet) {
            this.resourceSet = resourceSet;
            resourceSet.eAdapters().add((Object)this);
        }

        @Override
        public ResourceSet getResourceSet() {
            return this.resourceSet;
        }

        @Override
        public Map<String, Object> getConfigurerResults() {
            return Collections.unmodifiableMap(this.configurerResults);
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        public Exception deactivate() {
            Exception exception = null;
            if (this.active) {
                this.active = false;
                try {
                    try {
                        this.resourceSet.eAdapters().remove((Object)this);
                        for (Object configurerResult : this.configurerResults.values()) {
                            Exception ex = LifecycleUtil.deactivate((Object)configurerResult);
                            if (ex == null) continue;
                            OM.LOG.error((Throwable)ex);
                            if (exception != null) continue;
                            exception = ex;
                        }
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                        if (exception == null) {
                            exception = ex;
                        }
                        this.configurerResults.clear();
                    }
                }
                finally {
                    this.configurerResults.clear();
                }
            }
            return exception;
        }

        public boolean isAdapterForType(Object type) {
            return type == ResourceSetConfigurer.Registry.ResourceSetConfiguration.class;
        }
    }
}

