/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.revision.AbstractCDORevisionCache;
import org.eclipse.emf.cdo.internal.common.revision.CacheAdditionEvent;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CDORevisionCacheAuditing
extends AbstractCDORevisionCache {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, CDORevisionCacheAuditing.class);
    protected Map<Object, RevisionList> revisionLists = new HashMap<Object, RevisionList>();

    @Override
    public InternalCDORevisionCache instantiate(CDORevision revision) {
        return new CDORevisionCacheAuditing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EClass getObjectType(CDOID id) {
        Map<Object, RevisionList> map = this.revisionLists;
        synchronized (map) {
            Reference ref;
            InternalCDORevision revision;
            RevisionList list = this.revisionLists.get(id);
            if (list != null && !list.isEmpty() && (revision = (InternalCDORevision)(ref = (Reference)list.getFirst()).get()) != null) {
                return revision.getEClass();
            }
            return null;
        }
    }

    @Override
    public InternalCDORevision getRevision(CDOID id, CDOBranchPoint branchPoint) {
        CDOBranch branch = branchPoint.getBranch();
        this.checkBranch(branch);
        return this.withRevisionList(id, branch, list -> list.getRevision(branchPoint.getTimeStamp()));
    }

    @Override
    public InternalCDORevision getRevisionByVersion(CDOID id, CDOBranchVersion branchVersion) {
        CDOBranch branch = branchVersion.getBranch();
        this.checkBranch(branch);
        return this.withRevisionList(id, branch, list -> list.getRevisionByVersion(branchVersion.getVersion()));
    }

    @Override
    public void forEachCurrentRevision(Consumer<CDORevision> consumer) {
        this.forEachRevisionList(list -> {
            InternalCDORevision revision = list.getRevision(0L);
            if (revision != null) {
                consumer.accept(revision);
            }
        });
    }

    @Override
    public void forEachRevision(Consumer<CDORevision> consumer) {
        this.forEachRevisionList(list -> list.forEachRevision(consumer));
    }

    @Override
    public Map<CDOBranch, List<CDORevision>> getAllRevisions() {
        HashMap<CDOBranch, List<CDORevision>> result = new HashMap<CDOBranch, List<CDORevision>>();
        this.forEachRevisionList(list -> list.getAllRevisions(result));
        return result;
    }

    @Override
    public void getAllRevisions(List<InternalCDORevision> result) {
        this.forEachRevisionList(list2 -> list2.getAllRevisions(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CDORevision> getRevisions(CDOBranchPoint branchPoint) {
        CDOBranch branch = branchPoint.getBranch();
        this.checkBranch(branch);
        ArrayList<CDORevision> result = new ArrayList<CDORevision>();
        Map<Object, RevisionList> map = this.revisionLists;
        synchronized (map) {
            for (Map.Entry<Object, RevisionList> entry : this.revisionLists.entrySet()) {
                RevisionList list;
                InternalCDORevision revision;
                if (!this.isKeyInBranch(entry.getKey(), branch) || (revision = (list = entry.getValue()).getRevision(branchPoint.getTimeStamp())) == null) continue;
                result.add(revision);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public CDORevision internRevision(CDORevision revision) {
        CDORevision cDORevision;
        CheckUtil.checkArg((Object)revision, (String)"revision");
        CDOBranch branch = revision.getBranch();
        this.checkBranch(branch);
        CDOID id = revision.getID();
        Object key = this.createKey(id, branch);
        IListener[] listeners = this.getListeners();
        CacheAdditionEvent event = null;
        try {
            block9: {
                CDORevision cachedRevision;
                Map<Object, RevisionList> map = this.revisionLists;
                // MONITORENTER : map
                RevisionList list = this.revisionLists.get(key);
                if (list == null) {
                    list = new RevisionList();
                    this.revisionLists.put(key, list);
                }
                if ((cachedRevision = list.addRevision(revision, () -> this.createReference(revision))) == revision) break block9;
                CDORevision cDORevision2 = cachedRevision;
                // MONITOREXIT : map
                if (event == null) return cDORevision2;
                {
                    catch (Throwable throwable) {
                        // MONITOREXIT : map
                        throw throwable;
                    }
                }
                this.fireEvent(event, listeners);
                return cDORevision2;
            }
            this.typeRefIncrease(id, revision.getEClass());
            // MONITOREXIT : map
        }
        catch (Throwable throwable) {
            if (event == null) throw throwable;
            this.fireEvent(event, listeners);
            throw throwable;
        }
        {
            if (listeners.length != 0) {
                event = new CacheAdditionEvent(this, revision);
            }
            cDORevision = revision;
            if (event == null) return cDORevision;
        }
        this.fireEvent(event, listeners);
        return cDORevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRevisions(CDOBranch ... branches) {
        if (branches != null && branches.length != 0) {
            Map<Object, RevisionList> map = this.revisionLists;
            synchronized (map) {
                Iterator<Map.Entry<Object, RevisionList>> it = this.revisionLists.entrySet().iterator();
                block3: while (it.hasNext()) {
                    Map.Entry<Object, RevisionList> entry = it.next();
                    Object key = entry.getKey();
                    int i = 0;
                    while (i < branches.length) {
                        CDOBranch branch = branches[i];
                        if (this.isKeyInBranch(key, branch)) {
                            it.remove();
                            CDOID id = this.getID(key);
                            this.typeRefDecrease(id);
                            continue block3;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InternalCDORevision doRemoveRevision(CDOID id, CDOBranchVersion branchVersion) {
        CDOBranch branch = branchVersion.getBranch();
        this.checkBranch(branch);
        Object key = this.createKey(id, branch);
        Map<Object, RevisionList> map = this.revisionLists;
        synchronized (map) {
            RevisionList list = this.revisionLists.get(key);
            if (list != null) {
                list.removeRevision(branchVersion.getVersion());
                if (list.isEmpty()) {
                    this.revisionLists.remove(key);
                    this.typeRefDecrease(id);
                    if (TRACER.isEnabled()) {
                        TRACER.format("Removed cache list of {0}", new Object[]{key});
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<Object, RevisionList> map = this.revisionLists;
        synchronized (map) {
            this.revisionLists.clear();
            this.typeRefDispose();
        }
    }

    protected void typeRefIncrease(CDOID id, EClass type) {
    }

    protected void typeRefDecrease(CDOID id) {
    }

    protected void typeRefDispose() {
    }

    protected Object createKey(CDOID id, CDOBranch branch) {
        return id;
    }

    protected boolean isKeyInBranch(Object key, CDOBranch branch) {
        return true;
    }

    protected CDOID getID(Object key) {
        return (CDOID)key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T withRevisionList(CDOID id, CDOBranch branch, Function<RevisionList, T> function) {
        Object key = this.createKey(id, branch);
        Map<Object, RevisionList> map = this.revisionLists;
        synchronized (map) {
            RevisionList list = this.revisionLists.get(key);
            if (list != null) {
                return function.apply(list);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forEachRevisionList(Consumer<RevisionList> consumer) {
        Map<Object, RevisionList> map = this.revisionLists;
        synchronized (map) {
            for (RevisionList revisionList : this.revisionLists.values()) {
                consumer.accept(revisionList);
            }
        }
    }

    protected static final class RevisionList
    extends LinkedList<Reference<InternalCDORevision>> {
        private static final long serialVersionUID = 1L;

        public InternalCDORevision getRevision(long timeStamp) {
            if (timeStamp == 0L) {
                Reference ref;
                Reference reference = ref = this.isEmpty() ? null : (Reference)this.getFirst();
                if (ref != null) {
                    InternalCDORevision revision = (InternalCDORevision)ref.get();
                    if (revision != null) {
                        if (!revision.isHistorical()) {
                            return revision;
                        }
                    } else {
                        this.removeFirst();
                    }
                }
                return null;
            }
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Reference ref = (Reference)it.next();
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (revision != null) {
                    long created = revision.getTimeStamp();
                    if (created > timeStamp) continue;
                    long revised = revision.getRevised();
                    if (timeStamp > revised && revised != 0L) break;
                    return revision;
                }
                it.remove();
            }
            return null;
        }

        public InternalCDORevision getRevisionByVersion(int version) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Reference ref = (Reference)it.next();
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (revision != null) {
                    int v = revision.getVersion();
                    if (v == version) {
                        return revision;
                    }
                    if (v >= version) continue;
                    break;
                }
                it.remove();
            }
            return null;
        }

        public void forEachRevision(Consumer<CDORevision> consumer) {
            for (Reference ref : this) {
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (revision == null) continue;
                consumer.accept(revision);
            }
        }

        public CDORevision addRevision(CDORevision revision, Supplier<Reference<InternalCDORevision>> referenceCreator) {
            int version = revision.getVersion();
            ListIterator<Reference<InternalCDORevision>> it = this.listIterator();
            while (it.hasNext()) {
                Reference ref = (Reference)it.next();
                InternalCDORevision foundRevision = (InternalCDORevision)ref.get();
                if (foundRevision != null) {
                    CDORevisionKey key = (CDORevisionKey)((Object)ref);
                    int v = key.getVersion();
                    if (v == version) {
                        return foundRevision;
                    }
                    if (v >= version) continue;
                    it.previous();
                    it.add(referenceCreator.get());
                    return revision;
                }
                it.remove();
            }
            this.addLast(referenceCreator.get());
            return revision;
        }

        public void removeRevision(int version) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Reference ref = (Reference)it.next();
                CDORevisionKey key = (CDORevisionKey)((Object)ref);
                int v = key.getVersion();
                if (v == version) {
                    it.remove();
                    if (!TRACER.isEnabled()) break;
                    TRACER.format("Removed version {0} from cache list of {1}", new Object[]{version, key.getID()});
                    break;
                }
                if (v < version) break;
            }
        }

        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer();
            for (Reference ref : this) {
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (buffer.length() == 0) {
                    buffer.append("{");
                } else {
                    buffer.append(", ");
                }
                buffer.append(revision);
            }
            buffer.append("}");
            return buffer.toString();
        }

        public void getAllRevisions(Map<CDOBranch, List<CDORevision>> result) {
            for (Reference ref : this) {
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (revision == null) continue;
                InternalCDOBranch branch = revision.getBranch();
                List<CDORevision> resultList = result.get(branch);
                if (resultList == null) {
                    resultList = new ArrayList<CDORevision>(1);
                    result.put(branch, resultList);
                }
                resultList.add(revision);
            }
        }

        public void getAllRevisions(List<InternalCDORevision> result) {
            for (Reference ref : this) {
                InternalCDORevision revision = (InternalCDORevision)ref.get();
                if (revision == null) continue;
                result.add(revision);
            }
        }
    }
}

