/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Iterator;
import org.eclipse.cdt.internal.ui.editor.ICAnnotation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class CAnnotationIterator
implements Iterator<Annotation> {
    private Iterator<Annotation> fIterator;
    private Annotation fNext;
    private boolean fReturnAllAnnotations;

    public CAnnotationIterator(Iterator<Annotation> parent, boolean returnAllAnnotations) {
        this.fReturnAllAnnotations = returnAllAnnotations;
        this.fIterator = parent;
        this.skip();
    }

    private void skip() {
        while (this.fIterator.hasNext()) {
            Annotation next = this.fIterator.next();
            if (next.isMarkedDeleted() || !this.fReturnAllAnnotations && !(next instanceof ICAnnotation) && !CAnnotationIterator.isProblemMarkerAnnotation(next)) continue;
            this.fNext = next;
            return;
        }
        this.fNext = null;
    }

    private static boolean isProblemMarkerAnnotation(Annotation annotation) {
        if (!(annotation instanceof MarkerAnnotation)) {
            return false;
        }
        try {
            return ((MarkerAnnotation)annotation).getMarker().isSubtypeOf("org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException e) {
            return false;
        }
    }

    @Override
    public boolean hasNext() {
        return this.fNext != null;
    }

    @Override
    public Annotation next() {
        try {
            Annotation annotation = this.fNext;
            return annotation;
        }
        finally {
            this.skip();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

