/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring.code.flow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.cdt.core.dom.ast.ASTGenericVisitor;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionWithTryBlock;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTRangeBasedForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVariableReadWriteFlags;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.BlockFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.BranchFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.ConditionalFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.DoWhileFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.ForFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.FunctionCallFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.GenericSequentialFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.IfFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.LocalFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.RangeBasedForFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.ReturnFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.SwitchFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.ThrowFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.TryFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.WhileFlowInfo;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

abstract class FlowAnalyzer
extends ASTGenericVisitor {
    private final HashMap<IASTNode, FlowInfo> fData = new HashMap(100);
    FlowContext fFlowContext;

    public FlowAnalyzer(FlowContext context) {
        super(true);
        this.fFlowContext = context;
    }

    protected abstract boolean shouldCreateReturnFlowInfo(IASTReturnStatement var1);

    protected abstract boolean traverseNode(IASTNode var1);

    protected boolean skipNode(IASTNode node) {
        return !this.traverseNode(node);
    }

    protected final int genericVisit(IASTNode node) {
        return this.traverseNode(node) ? 3 : 1;
    }

    protected ReturnFlowInfo createReturn(IASTReturnStatement statement) {
        return new ReturnFlowInfo(statement);
    }

    protected ThrowFlowInfo createThrow() {
        return new ThrowFlowInfo();
    }

    protected BranchFlowInfo createBranch(IASTName label) {
        return new BranchFlowInfo(label, this.fFlowContext);
    }

    protected GenericSequentialFlowInfo createSequential() {
        return new GenericSequentialFlowInfo();
    }

    protected ConditionalFlowInfo createConditional() {
        return new ConditionalFlowInfo();
    }

    protected RangeBasedForFlowInfo createRangeBasedFor() {
        return new RangeBasedForFlowInfo();
    }

    protected ForFlowInfo createFor() {
        return new ForFlowInfo();
    }

    protected TryFlowInfo createTry() {
        return new TryFlowInfo();
    }

    protected WhileFlowInfo createWhile() {
        return new WhileFlowInfo();
    }

    protected IfFlowInfo createIf() {
        return new IfFlowInfo();
    }

    protected DoWhileFlowInfo createDoWhile() {
        return new DoWhileFlowInfo();
    }

    protected SwitchFlowInfo createSwitch() {
        return new SwitchFlowInfo();
    }

    protected BlockFlowInfo createBlock() {
        return new BlockFlowInfo();
    }

    protected FunctionCallFlowInfo createFunctionCallFlowInfo() {
        return new FunctionCallFlowInfo();
    }

    protected FlowContext getFlowContext() {
        return this.fFlowContext;
    }

    protected FlowInfo getFlowInfo(IASTNode node) {
        return this.fData.remove(node);
    }

    protected void setFlowInfo(IASTNode node, FlowInfo info) {
        this.fData.put(node, info);
    }

    protected FlowInfo assignFlowInfo(IASTNode target, IASTNode source) {
        FlowInfo result = this.getFlowInfo(source);
        this.setFlowInfo(target, result);
        return result;
    }

    protected FlowInfo accessFlowInfo(IASTNode node) {
        return this.fData.get(node);
    }

    protected GenericSequentialFlowInfo processSequential(IASTNode parent, IASTNode[] nodes) {
        GenericSequentialFlowInfo result = this.createSequential(parent);
        this.process(result, nodes);
        return result;
    }

    protected GenericSequentialFlowInfo processSequential(IASTNode parent, Iterable<IASTNode> nodes) {
        GenericSequentialFlowInfo result = this.createSequential(parent);
        this.process(result, nodes);
        return result;
    }

    protected GenericSequentialFlowInfo processSequential(IASTNode parent, IASTNode node) {
        GenericSequentialFlowInfo result = this.createSequential(parent);
        if (node != null) {
            result.merge(this.getFlowInfo(node), this.fFlowContext);
        }
        return result;
    }

    protected GenericSequentialFlowInfo processSequential(IASTNode parent, IASTNode node1, IASTNode node2) {
        GenericSequentialFlowInfo result = this.createSequential(parent);
        if (node1 != null) {
            result.merge(this.getFlowInfo(node1), this.fFlowContext);
        }
        if (node2 != null) {
            result.merge(this.getFlowInfo(node2), this.fFlowContext);
        }
        return result;
    }

    protected GenericSequentialFlowInfo createSequential(IASTNode parent) {
        GenericSequentialFlowInfo result = this.createSequential();
        this.setFlowInfo(parent, result);
        return result;
    }

    protected GenericSequentialFlowInfo createSequential(IASTNode[] nodes) {
        GenericSequentialFlowInfo result = this.createSequential();
        this.process(result, nodes);
        return result;
    }

    protected void process(GenericSequentialFlowInfo info, IASTNode[] nodes) {
        if (nodes == null) {
            return;
        }
        IASTNode[] iASTNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode node = iASTNodeArray[n2];
            info.merge(this.getFlowInfo(node), this.fFlowContext);
            ++n2;
        }
    }

    protected void process(GenericSequentialFlowInfo info, Iterable<IASTNode> nodes) {
        if (nodes == null) {
            return;
        }
        for (IASTNode node : nodes) {
            info.merge(this.getFlowInfo(node), this.fFlowContext);
        }
    }

    protected void process(GenericSequentialFlowInfo info, IASTNode node) {
        if (node != null) {
            info.merge(this.getFlowInfo(node), this.fFlowContext);
        }
    }

    protected void process(GenericSequentialFlowInfo info, IASTNode node1, IASTNode node2) {
        if (node1 != null) {
            info.merge(this.getFlowInfo(node1), this.fFlowContext);
        }
        if (node2 != null) {
            info.merge(this.getFlowInfo(node2), this.fFlowContext);
        }
    }

    public int visit(IASTStatement node) {
        if (this.skipNode((IASTNode)node)) {
            return 1;
        }
        if (node instanceof IASTBreakStatement) {
            return this.visit((IASTBreakStatement)node);
        }
        if (node instanceof IASTCaseStatement) {
            return this.visit((IASTCaseStatement)node);
        }
        if (node instanceof IASTCompoundStatement) {
            return this.visit((IASTCompoundStatement)node);
        }
        if (node instanceof IASTContinueStatement) {
            return this.visit((IASTContinueStatement)node);
        }
        if (node instanceof IASTDeclarationStatement) {
            return this.visit((IASTDeclarationStatement)node);
        }
        if (node instanceof IASTDefaultStatement) {
            return this.visit((IASTDefaultStatement)node);
        }
        if (node instanceof IASTDoStatement) {
            return this.visit((IASTDoStatement)node);
        }
        if (node instanceof IASTExpressionStatement) {
            return this.visit((IASTExpressionStatement)node);
        }
        if (node instanceof IASTForStatement) {
            return this.visit((IASTForStatement)node);
        }
        if (node instanceof IASTGotoStatement) {
            return this.visit((IASTGotoStatement)node);
        }
        if (node instanceof IASTIfStatement) {
            return this.visit((IASTIfStatement)node);
        }
        if (node instanceof IASTLabelStatement) {
            return this.visit((IASTLabelStatement)node);
        }
        if (node instanceof IASTNullStatement) {
            return this.visit((IASTNullStatement)node);
        }
        if (node instanceof IASTReturnStatement) {
            return this.visit((IASTReturnStatement)node);
        }
        if (node instanceof IASTSwitchStatement) {
            return this.visit((IASTSwitchStatement)node);
        }
        if (node instanceof IASTWhileStatement) {
            return this.visit((IASTWhileStatement)node);
        }
        if (node instanceof ICPPASTCatchHandler) {
            return this.visit((ICPPASTCatchHandler)node);
        }
        if (node instanceof ICPPASTRangeBasedForStatement) {
            return this.visit((ICPPASTRangeBasedForStatement)node);
        }
        if (node instanceof ICPPASTTryBlockStatement) {
            return this.visit((ICPPASTTryBlockStatement)node);
        }
        return 3;
    }

    public int visit(IASTBreakStatement node) {
        return 3;
    }

    public int visit(IASTCaseStatement node) {
        return 3;
    }

    public int visit(IASTDefaultStatement node) {
        return 3;
    }

    public int visit(IASTCompoundStatement node) {
        return 3;
    }

    public int visit(IASTContinueStatement node) {
        return 3;
    }

    public int visit(IASTDeclarationStatement node) {
        return 3;
    }

    public int visit(IASTDoStatement node) {
        return 3;
    }

    public int visit(IASTExpressionStatement node) {
        return 3;
    }

    public int visit(IASTForStatement node) {
        return 3;
    }

    public int visit(IASTGotoStatement node) {
        return 3;
    }

    public int visit(IASTIfStatement node) {
        return 3;
    }

    public int visit(IASTLabelStatement node) {
        return 3;
    }

    public int visit(IASTNullStatement node) {
        return 1;
    }

    public int visit(ICPPASTRangeBasedForStatement node) {
        return 3;
    }

    public int visit(ICPPASTTryBlockStatement node) {
        if (this.traverseNode((IASTNode)node)) {
            this.fFlowContext.pushExceptions(node);
            node.getTryBody().accept((ASTVisitor)this);
            this.fFlowContext.popExceptions();
            ICPPASTCatchHandler[] iCPPASTCatchHandlerArray = node.getCatchHandlers();
            int n = iCPPASTCatchHandlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTCatchHandler catchHandler = iCPPASTCatchHandlerArray[n2];
                catchHandler.accept((ASTVisitor)this);
                ++n2;
            }
        }
        return 1;
    }

    public int visit(ICPPASTCatchHandler node) {
        return 3;
    }

    public int visit(IASTReturnStatement node) {
        return 3;
    }

    public int visit(IASTSwitchStatement node) {
        return 3;
    }

    public int visit(IASTWhileStatement node) {
        return 3;
    }

    protected SwitchData createSwitchData(IASTSwitchStatement node) {
        SwitchData result = new SwitchData();
        IASTStatement body = node.getBody();
        IASTStatement[] statements = body instanceof IASTCompoundStatement ? ((IASTCompoundStatement)body).getStatements() : new IASTStatement[]{body};
        if (statements.length == 0) {
            return result;
        }
        int start = -1;
        int end = -1;
        FlowInfo info = null;
        IASTStatement[] iASTStatementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            IASTStatement statement = iASTStatementArray[n2];
            IASTFileLocation location = statement.getFileLocation();
            if (statement instanceof IASTCaseStatement || statement instanceof IASTDefaultStatement) {
                if (statement instanceof IASTDefaultStatement) {
                    result.setHasDefaultCase();
                }
                if (info == null) {
                    info = this.createSequential();
                    start = location.getNodeOffset();
                } else if (info.isReturn() || info.isPartialReturn() || info.branches()) {
                    result.add((IRegion)new Region(start, end - start + 1), info);
                    info = this.createSequential();
                    start = location.getNodeOffset();
                }
            } else if (info == null) {
                info = this.createSequential();
                start = location.getNodeOffset();
            } else {
                ((GenericSequentialFlowInfo)info).merge(this.getFlowInfo((IASTNode)statement), this.fFlowContext);
            }
            end = location.getNodeOffset() + location.getNodeLength() - 1;
            ++n2;
        }
        result.add((IRegion)new Region(start, end - start + 1), info);
        return result;
    }

    public int leave(IASTStatement node) {
        if (this.skipNode((IASTNode)node)) {
            return 1;
        }
        if (node instanceof IASTBreakStatement) {
            return this.leave((IASTBreakStatement)node);
        }
        if (node instanceof IASTCaseStatement) {
            return this.leave((IASTCaseStatement)node);
        }
        if (node instanceof IASTCompoundStatement) {
            return this.leave((IASTCompoundStatement)node);
        }
        if (node instanceof IASTContinueStatement) {
            return this.leave((IASTContinueStatement)node);
        }
        if (node instanceof IASTDeclarationStatement) {
            return this.leave((IASTDeclarationStatement)node);
        }
        if (node instanceof IASTDefaultStatement) {
            return this.leave((IASTDefaultStatement)node);
        }
        if (node instanceof IASTDoStatement) {
            return this.leave((IASTDoStatement)node);
        }
        if (node instanceof IASTExpressionStatement) {
            return this.leave((IASTExpressionStatement)node);
        }
        if (node instanceof IASTForStatement) {
            return this.leave((IASTForStatement)node);
        }
        if (node instanceof IASTGotoStatement) {
            return this.leave((IASTGotoStatement)node);
        }
        if (node instanceof IASTIfStatement) {
            return this.leave((IASTIfStatement)node);
        }
        if (node instanceof IASTLabelStatement) {
            return this.leave((IASTLabelStatement)node);
        }
        if (node instanceof IASTNullStatement) {
            return this.leave((IASTNullStatement)node);
        }
        if (node instanceof IASTReturnStatement) {
            return this.leave((IASTReturnStatement)node);
        }
        if (node instanceof IASTSwitchStatement) {
            return this.leave((IASTSwitchStatement)node);
        }
        if (node instanceof IASTWhileStatement) {
            return this.leave((IASTWhileStatement)node);
        }
        if (node instanceof ICPPASTCatchHandler) {
            return this.leave((ICPPASTCatchHandler)node);
        }
        if (node instanceof ICPPASTRangeBasedForStatement) {
            return this.leave((ICPPASTRangeBasedForStatement)node);
        }
        if (node instanceof ICPPASTTryBlockStatement) {
            return this.leave((ICPPASTTryBlockStatement)node);
        }
        return 1;
    }

    public int leave(IASTBreakStatement node) {
        this.setFlowInfo((IASTNode)node, this.createBranch(null));
        return 1;
    }

    public int leave(IASTCaseStatement node) {
        return 1;
    }

    public int leave(IASTDefaultStatement node) {
        return 1;
    }

    public int leave(IASTCompoundStatement node) {
        BlockFlowInfo info = this.createBlock();
        this.setFlowInfo((IASTNode)node, info);
        this.process((GenericSequentialFlowInfo)info, (IASTNode[])node.getStatements());
        return 1;
    }

    public int leave(IASTContinueStatement node) {
        this.setFlowInfo((IASTNode)node, this.createBranch(null));
        return 1;
    }

    public int leave(IASTDeclarationStatement node) {
        this.processSequential((IASTNode)node, (IASTNode)node.getDeclaration());
        return 1;
    }

    public int leave(IASTDoStatement node) {
        DoWhileFlowInfo info = this.createDoWhile();
        this.setFlowInfo((IASTNode)node, info);
        info.mergeAction(this.getFlowInfo((IASTNode)node.getBody()), this.fFlowContext);
        info.mergeCondition(this.getFlowInfo((IASTNode)node.getCondition()), this.fFlowContext);
        info.removeLabel(null);
        return 1;
    }

    public int leave(IASTExpressionStatement node) {
        this.assignFlowInfo((IASTNode)node, (IASTNode)node.getExpression());
        return 1;
    }

    public int leave(IASTForStatement node) {
        ForFlowInfo forInfo = this.createFor();
        this.setFlowInfo((IASTNode)node, forInfo);
        forInfo.mergeInitializer(this.createSequential((IASTNode)node.getInitializerStatement()), this.fFlowContext);
        forInfo.mergeCondition(this.getFlowInfo((IASTNode)node.getConditionExpression()), this.fFlowContext);
        forInfo.mergeAction(this.getFlowInfo((IASTNode)node.getBody()), this.fFlowContext);
        forInfo.mergeIncrement(this.createSequential((IASTNode)node.getIterationExpression()), this.fFlowContext);
        forInfo.removeLabel(null);
        return 1;
    }

    public int leave(IASTGotoStatement node) {
        this.setFlowInfo((IASTNode)node, this.createBranch(node.getName()));
        return 1;
    }

    public int leave(IASTIfStatement node) {
        IfFlowInfo info = this.createIf();
        this.setFlowInfo((IASTNode)node, info);
        info.mergeCondition(this.getFlowInfo((IASTNode)node.getConditionExpression()), this.fFlowContext);
        info.merge(this.getFlowInfo((IASTNode)node.getThenClause()), this.getFlowInfo((IASTNode)node.getElseClause()), this.fFlowContext);
        return 1;
    }

    public int leave(IASTLabelStatement node) {
        this.assignFlowInfo((IASTNode)node, (IASTNode)node.getNestedStatement());
        return 1;
    }

    public int leave(IASTNullStatement node) {
        return 1;
    }

    public int leave(ICPPASTRangeBasedForStatement node) {
        RangeBasedForFlowInfo forInfo = this.createRangeBasedFor();
        this.setFlowInfo((IASTNode)node, forInfo);
        forInfo.mergeDeclaration(this.getFlowInfo((IASTNode)node.getDeclaration()), this.fFlowContext);
        forInfo.mergeInitializerClause(this.getFlowInfo((IASTNode)node.getInitializerClause()), this.fFlowContext);
        forInfo.mergeAction(this.getFlowInfo((IASTNode)node.getBody()), this.fFlowContext);
        forInfo.removeLabel(null);
        return 1;
    }

    public int leave(ICPPASTTryBlockStatement node) {
        TryFlowInfo info = this.createTry();
        this.setFlowInfo((IASTNode)node, info);
        info.mergeTry(this.getFlowInfo((IASTNode)node.getTryBody()), this.fFlowContext);
        ICPPASTCatchHandler[] iCPPASTCatchHandlerArray = node.getCatchHandlers();
        int n = iCPPASTCatchHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTCatchHandler catchHandler = iCPPASTCatchHandlerArray[n2];
            info.mergeCatch(this.getFlowInfo((IASTNode)catchHandler), this.fFlowContext);
            ++n2;
        }
        return 1;
    }

    public int leave(ICPPASTCatchHandler node) {
        this.processSequential((IASTNode)node, (IASTNode)node.getDeclaration(), (IASTNode)node.getCatchBody());
        return 1;
    }

    public int leave(IASTReturnStatement node) {
        if (this.shouldCreateReturnFlowInfo(node)) {
            ReturnFlowInfo info = this.createReturn(node);
            this.setFlowInfo((IASTNode)node, info);
            info.merge(this.getFlowInfo((IASTNode)node.getReturnArgument()), this.fFlowContext);
        } else {
            this.assignFlowInfo((IASTNode)node, (IASTNode)node.getReturnArgument());
        }
        return 1;
    }

    public int leave(IASTSwitchStatement node) {
        return this.leave(node, this.createSwitchData(node));
    }

    protected int leave(IASTSwitchStatement node, SwitchData data) {
        SwitchFlowInfo switchFlowInfo = this.createSwitch();
        this.setFlowInfo((IASTNode)node, switchFlowInfo);
        switchFlowInfo.mergeTest(this.getFlowInfo((IASTNode)node.getControllerExpression()), this.fFlowContext);
        FlowInfo[] cases = data.getInfos();
        int i = 0;
        while (i < cases.length) {
            switchFlowInfo.mergeCase(cases[i], this.fFlowContext);
            ++i;
        }
        switchFlowInfo.mergeDefault(data.hasDefaultCase(), this.fFlowContext);
        switchFlowInfo.removeLabel(null);
        return 1;
    }

    public int leave(IASTWhileStatement node) {
        WhileFlowInfo info = this.createWhile();
        this.setFlowInfo((IASTNode)node, info);
        info.mergeCondition(this.getFlowInfo((IASTNode)node.getCondition()), this.fFlowContext);
        if (node instanceof ICPPASTWhileStatement) {
            info.mergeCondition(this.getFlowInfo((IASTNode)((ICPPASTWhileStatement)node).getConditionDeclaration()), this.fFlowContext);
        }
        info.mergeAction(this.getFlowInfo((IASTNode)node.getBody()), this.fFlowContext);
        info.removeLabel(null);
        return 1;
    }

    public int leave(IASTExpression node) {
        if (this.skipNode((IASTNode)node)) {
            return 1;
        }
        if (node instanceof IASTArraySubscriptExpression) {
            return this.leave((IASTArraySubscriptExpression)node);
        }
        if (node instanceof IASTConditionalExpression) {
            return this.leave((IASTConditionalExpression)node);
        }
        if (node instanceof IASTFunctionCallExpression) {
            return this.leave((IASTFunctionCallExpression)node);
        }
        if (node instanceof IASTExpressionList) {
            return this.leave((IASTExpressionList)node);
        }
        if (node instanceof IASTTypeIdExpression) {
            return this.leave((IASTTypeIdExpression)node);
        }
        if (node instanceof IASTBinaryExpression) {
            return this.leave((IASTBinaryExpression)node);
        }
        if (node instanceof IASTLiteralExpression) {
            return this.leave((IASTLiteralExpression)node);
        }
        if (node instanceof IASTIdExpression) {
            return this.leave((IASTIdExpression)node);
        }
        if (node instanceof IASTCastExpression) {
            return this.leave((IASTCastExpression)node);
        }
        if (node instanceof IASTUnaryExpression) {
            return this.leave((IASTUnaryExpression)node);
        }
        if (node instanceof IASTFieldReference) {
            return this.leave((IASTFieldReference)node);
        }
        if (node instanceof IASTTypeIdInitializerExpression) {
            return this.leave((IASTTypeIdInitializerExpression)node);
        }
        if (node instanceof ICPPASTNewExpression) {
            return this.leave((ICPPASTNewExpression)node);
        }
        if (node instanceof ICPPASTDeleteExpression) {
            return this.leave((ICPPASTDeleteExpression)node);
        }
        if (node instanceof ICPPASTSimpleTypeConstructorExpression) {
            return this.leave((ICPPASTSimpleTypeConstructorExpression)node);
        }
        if (node instanceof IASTProblemExpression) {
            return this.leave(node);
        }
        return 1;
    }

    public int leave(IASTArraySubscriptExpression node) {
        this.processSequential((IASTNode)node, (IASTNode)node.getArrayExpression(), (IASTNode)node.getArgument());
        return 1;
    }

    public int leave(IASTConditionalExpression node) {
        ConditionalFlowInfo info = this.createConditional();
        this.setFlowInfo((IASTNode)node, info);
        info.mergeCondition(this.getFlowInfo((IASTNode)node.getLogicalConditionExpression()), this.fFlowContext);
        info.merge(this.getFlowInfo((IASTNode)node.getPositiveResultExpression()), this.getFlowInfo((IASTNode)node.getNegativeResultExpression()), this.fFlowContext);
        return 1;
    }

    public int leave(IASTFunctionCallExpression node) {
        this.processFunctionCall(node, node.getFunctionNameExpression(), node.getArguments());
        return 1;
    }

    public int leave(IASTDeclaration node) {
        if (this.skipNode((IASTNode)node)) {
            return 1;
        }
        if (node instanceof IASTFunctionDefinition) {
            return this.leave((IASTFunctionDefinition)node);
        }
        if (node instanceof IASTSimpleDeclaration) {
            return this.leave((IASTSimpleDeclaration)node);
        }
        return 1;
    }

    public int leave(IASTFunctionDefinition node) {
        GenericSequentialFlowInfo info = this.processSequential((IASTNode)node, (IASTNode)node.getDeclSpecifier());
        this.process(info, (IASTNode)node.getDeclarator());
        this.process(info, (IASTNode)node.getBody());
        if (node instanceof ICPPASTFunctionWithTryBlock) {
            this.process(info, (IASTNode[])((ICPPASTFunctionWithTryBlock)node).getCatchHandlers());
        }
        return 1;
    }

    public int leave(IASTSimpleDeclaration node) {
        GenericSequentialFlowInfo info = this.processSequential((IASTNode)node, (IASTNode)node.getDeclSpecifier());
        this.process(info, (IASTNode[])node.getDeclarators());
        return 1;
    }

    public int leave(IASTParameterDeclaration node) {
        if (this.skipNode((IASTNode)node)) {
            return 1;
        }
        GenericSequentialFlowInfo info = this.processSequential((IASTNode)node, (IASTNode)node.getDeclSpecifier());
        this.process(info, (IASTNode)node.getDeclarator());
        return 1;
    }

    public int leave(IASTDeclarator node) {
        if (this.skipNode((IASTNode)node)) {
            return 1;
        }
        IASTDeclarator nestedOrName = node.getNestedDeclarator();
        if (nestedOrName == null) {
            nestedOrName = node.getName();
        }
        GenericSequentialFlowInfo info = this.processSequential((IASTNode)node, (IASTNode)nestedOrName);
        if (node instanceof IASTArrayDeclarator) {
            this.process(info, (IASTNode[])((IASTArrayDeclarator)node).getArrayModifiers());
        }
        IASTParameterDeclaration[] parameters = null;
        if (node instanceof IASTStandardFunctionDeclarator) {
            parameters = ((IASTStandardFunctionDeclarator)node).getParameters();
        } else if (node instanceof ICASTKnRFunctionDeclarator) {
            parameters = ((ICASTKnRFunctionDeclarator)node).getParameterDeclarations();
        }
        if (parameters != null) {
            this.process(info, (IASTNode[])parameters);
        }
        this.process(info, (IASTNode)node.getInitializer());
        return 1;
    }

    public int leave(IASTExpressionList node) {
        IASTExpression[] expressions = node.getExpressions();
        this.processSequential((IASTNode)node, (IASTNode[])expressions);
        return 1;
    }

    public int leave(IASTTypeIdExpression node) {
        this.assignFlowInfo((IASTNode)node, (IASTNode)node.getTypeId());
        return 1;
    }

    public int leave(IASTBinaryExpression node) {
        int operator = node.getOperator();
        switch (operator) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                FlowInfo lhs = this.getFlowInfo((IASTNode)node.getOperand1());
                FlowInfo rhs = this.getFlowInfo((IASTNode)node.getOperand2());
                if (lhs instanceof LocalFlowInfo) {
                    LocalFlowInfo llhs = (LocalFlowInfo)lhs;
                    llhs.setWriteAccess(this.fFlowContext);
                    if (operator != 17) {
                        GenericSequentialFlowInfo tmp = this.createSequential();
                        tmp.merge(new LocalFlowInfo(llhs, 2, this.fFlowContext), this.fFlowContext);
                        tmp.merge(rhs, this.fFlowContext);
                        rhs = tmp;
                    }
                }
                GenericSequentialFlowInfo info = this.createSequential((IASTNode)node);
                info.merge(rhs, this.fFlowContext);
                info.merge(lhs, this.fFlowContext);
                break;
            }
            default: {
                IASTExpression[] operands = CPPVisitor.getOperandsOfMultiExpression((IASTBinaryExpression)node);
                this.processSequential((IASTNode)node, (IASTNode[])operands);
            }
        }
        return 1;
    }

    public int leave(IASTLiteralExpression node) {
        return 1;
    }

    public int leave(IASTIdExpression node) {
        this.assignFlowInfo((IASTNode)node, (IASTNode)node.getName());
        return 1;
    }

    public int leave(IASTCastExpression node) {
        if (this.skipNode((IASTNode)node)) {
            return 1;
        }
        this.processSequential((IASTNode)node, (IASTNode)node.getTypeId(), (IASTNode)node.getOperand());
        return 1;
    }

    public int leave(IASTUnaryExpression node) {
        if (this.skipNode((IASTNode)node)) {
            return 1;
        }
        int operator = node.getOperator();
        switch (operator) {
            case 0: 
            case 1: 
            case 9: 
            case 10: {
                FlowInfo info = this.getFlowInfo((IASTNode)node.getOperand());
                if (info instanceof LocalFlowInfo) {
                    GenericSequentialFlowInfo result = this.createSequential((IASTNode)node);
                    result.merge(info, this.fFlowContext);
                    result.merge(new LocalFlowInfo((LocalFlowInfo)info, 8, this.fFlowContext), this.fFlowContext);
                    break;
                }
                this.setFlowInfo((IASTNode)node, info);
                break;
            }
            case 12: {
                ThrowFlowInfo info = this.createThrow();
                this.setFlowInfo((IASTNode)node, info);
                IASTExpression expression = node.getOperand();
                info.merge(this.getFlowInfo((IASTNode)expression), this.fFlowContext);
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            default: {
                this.assignFlowInfo((IASTNode)node, (IASTNode)node.getOperand());
            }
        }
        return 1;
    }

    public int leave(IASTName node) {
        int index;
        IVariable variable;
        if (this.skipNode((IASTNode)node) || node.isDeclaration() || node instanceof ICPPASTQualifiedName) {
            return 1;
        }
        IBinding binding = node.resolveBinding();
        if (binding instanceof IVariable && !((variable = (IVariable)binding) instanceof IField) && (index = this.fFlowContext.getIndexFromLocal(variable)) >= 0) {
            Optional accessMode = CPPVariableReadWriteFlags.getReadWriteFlags((IASTName)node);
            if (accessMode.isPresent() && (Integer)accessMode.get() != 0) {
                int flowInfoMode = 1;
                switch ((Integer)accessMode.get()) {
                    case 32: {
                        flowInfoMode = 2;
                        break;
                    }
                    case 64: {
                        flowInfoMode = 8;
                        break;
                    }
                    case 96: {
                        flowInfoMode = 32;
                    }
                }
                this.setFlowInfo((IASTNode)node, new LocalFlowInfo(variable, index, flowInfoMode, this.fFlowContext));
            } else if (!accessMode.isPresent()) {
                this.setFlowInfo((IASTNode)node, new LocalFlowInfo(variable, index, 32, this.fFlowContext));
            }
        }
        return 1;
    }

    public int leave(IASTFieldReference node) {
        this.processSequential((IASTNode)node, (IASTNode)node.getFieldOwner(), (IASTNode)node.getFieldName());
        return 1;
    }

    public int leave(IASTTypeIdInitializerExpression node) {
        this.processSequential((IASTNode)node, (IASTNode)node.getInitializer());
        return 1;
    }

    public int leave(ICPPASTNewExpression node) {
        GenericSequentialFlowInfo info = this.processSequential((IASTNode)node, (IASTNode)node.getTypeId());
        this.process(info, (IASTNode[])node.getPlacementArguments());
        this.process(info, (IASTNode)node.getInitializer());
        return 1;
    }

    public int leave(ICPPASTDeleteExpression node) {
        this.assignFlowInfo((IASTNode)node, (IASTNode)node.getOperand());
        return 1;
    }

    public int leave(ICPPASTSimpleTypeConstructorExpression node) {
        this.processSequential((IASTNode)node, (IASTNode)node.getDeclSpecifier(), (IASTNode)node.getInitializer());
        return 1;
    }

    public int leave(IASTInitializer node) {
        if (this.skipNode((IASTNode)node)) {
            return 1;
        }
        if (node instanceof IASTEqualsInitializer) {
            return this.leave((IASTEqualsInitializer)node);
        }
        if (node instanceof IASTInitializerList) {
            return this.leave((IASTInitializerList)node);
        }
        if (node instanceof ICASTDesignatedInitializer) {
            return this.leave((ICASTDesignatedInitializer)node);
        }
        if (node instanceof IASTInitializerList) {
            return this.leave((ICPPASTConstructorChainInitializer)node);
        }
        if (node instanceof ICPPASTConstructorInitializer) {
            return this.leave((ICPPASTConstructorInitializer)node);
        }
        return 1;
    }

    public int leave(IASTEqualsInitializer node) {
        this.assignFlowInfo((IASTNode)node, (IASTNode)node.getInitializerClause());
        return 1;
    }

    public int leave(IASTInitializerList node) {
        this.processSequential((IASTNode)node, (IASTNode[])node.getClauses());
        return 1;
    }

    public int leave(ICASTDesignatedInitializer node) {
        this.processSequential((IASTNode)node, (IASTNode[])node.getDesignators());
        return 1;
    }

    public int leave(ICPPASTConstructorChainInitializer node) {
        this.processSequential((IASTNode)node, (IASTNode)node.getMemberInitializerId(), (IASTNode)node.getInitializer());
        return 1;
    }

    public int leave(ICPPASTConstructorInitializer node) {
        this.processSequential((IASTNode)node, (IASTNode[])node.getArguments());
        return 1;
    }

    public int leave(IASTTranslationUnit node) {
        if (this.skipNode((IASTNode)node)) {
            return 1;
        }
        this.processSequential((IASTNode)node, (IASTNode[])node.getDeclarations());
        return 1;
    }

    private void processFunctionCall(IASTFunctionCallExpression node, IASTExpression functionNameExpression, IASTInitializerClause[] arguments) {
        if (this.skipNode((IASTNode)node)) {
            return;
        }
        FunctionCallFlowInfo info = this.createFunctionCallFlowInfo();
        this.setFlowInfo((IASTNode)node, info);
        info.mergeReceiver(this.getFlowInfo((IASTNode)functionNameExpression), this.fFlowContext);
        IASTInitializerClause[] iASTInitializerClauseArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            IASTInitializerClause arg = iASTInitializerClauseArray[n2];
            info.mergeArgument(this.getFlowInfo((IASTNode)arg), this.fFlowContext);
            ++n2;
        }
    }

    protected static class SwitchData {
        private boolean fHasDefaultCase;
        private final List<IRegion> fRanges = new ArrayList<IRegion>(4);
        private final List<FlowInfo> fInfos = new ArrayList<FlowInfo>(4);

        protected SwitchData() {
        }

        public void setHasDefaultCase() {
            this.fHasDefaultCase = true;
        }

        public boolean hasDefaultCase() {
            return this.fHasDefaultCase;
        }

        public void add(IRegion range, FlowInfo info) {
            this.fRanges.add(range);
            this.fInfos.add(info);
        }

        public IRegion[] getRanges() {
            return this.fRanges.toArray(new IRegion[this.fRanges.size()]);
        }

        public FlowInfo[] getInfos() {
            return this.fInfos.toArray(new FlowInfo[this.fInfos.size()]);
        }

        public FlowInfo getInfo(int index) {
            return this.fInfos.get(index);
        }
    }
}

