/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CursorType implements Enumerator
{
    AUTO(0, "Auto", "Auto"),
    CROSSHAIR(1, "Crosshair", "Crosshair"),
    DEFAULT(2, "Default", "Default"),
    POINTER(3, "Pointer", "Pointer"),
    MOVE(4, "Move", "Move"),
    TEXT(5, "Text", "Text"),
    WAIT(6, "Wait", "Wait"),
    ERESIZE(7, "EResize", "E-Resize"),
    NE_RESIZE(8, "NEResize", "NE-Resize"),
    NW_RESIZE(9, "NWResize", "NW-Resize"),
    NRESIZE(10, "NResize", "N-Resize"),
    SE_RESIZE(11, "SEResize", "SE-Resize"),
    SW_RESIZE(12, "SWResize", "SW-Resize"),
    SRESIZE(13, "SResize", "S-Resize"),
    WRESIZE(14, "WResize", "W-Resize"),
    CUSTOM(15, "Custom", "Custom");

    public static final int AUTO_VALUE = 0;
    public static final int CROSSHAIR_VALUE = 1;
    public static final int DEFAULT_VALUE = 2;
    public static final int POINTER_VALUE = 3;
    public static final int MOVE_VALUE = 4;
    public static final int TEXT_VALUE = 5;
    public static final int WAIT_VALUE = 6;
    public static final int ERESIZE_VALUE = 7;
    public static final int NE_RESIZE_VALUE = 8;
    public static final int NW_RESIZE_VALUE = 9;
    public static final int NRESIZE_VALUE = 10;
    public static final int SE_RESIZE_VALUE = 11;
    public static final int SW_RESIZE_VALUE = 12;
    public static final int SRESIZE_VALUE = 13;
    public static final int WRESIZE_VALUE = 14;
    public static final int CUSTOM_VALUE = 15;
    private static final CursorType[] VALUES_ARRAY;
    public static final List<CursorType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CursorType[]{AUTO, CROSSHAIR, DEFAULT, POINTER, MOVE, TEXT, WAIT, ERESIZE, NE_RESIZE, NW_RESIZE, NRESIZE, SE_RESIZE, SW_RESIZE, SRESIZE, WRESIZE, CUSTOM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CursorType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CursorType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CursorType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CursorType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CursorType get(int value) {
        switch (value) {
            case 0: {
                return AUTO;
            }
            case 1: {
                return CROSSHAIR;
            }
            case 2: {
                return DEFAULT;
            }
            case 3: {
                return POINTER;
            }
            case 4: {
                return MOVE;
            }
            case 5: {
                return TEXT;
            }
            case 6: {
                return WAIT;
            }
            case 7: {
                return ERESIZE;
            }
            case 8: {
                return NE_RESIZE;
            }
            case 9: {
                return NW_RESIZE;
            }
            case 10: {
                return NRESIZE;
            }
            case 11: {
                return SE_RESIZE;
            }
            case 12: {
                return SW_RESIZE;
            }
            case 13: {
                return SRESIZE;
            }
            case 14: {
                return WRESIZE;
            }
            case 15: {
                return CUSTOM;
            }
        }
        return null;
    }

    private CursorType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

