/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.java.refactoring;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapter;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

class JSPJavaSelectionProvider {
    JSPJavaSelectionProvider() {
    }

    static IJavaScriptElement[] getSelection(ITextEditor textEditor) {
        IJavaScriptElement[] elements = null;
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        ISelection selection = textEditor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            IStructuredModel model = null;
            try {
                IDOMModel xmlModel;
                IDOMDocument xmlDoc;
                JsTranslationAdapter adapter;
                model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                if (model instanceof IDOMModel && (adapter = (JsTranslationAdapter)(xmlDoc = (xmlModel = (IDOMModel)model).getDocument()).getAdapterFor(IJsTranslation.class)) != null) {
                    IJsTranslation translation = adapter.getJsTranslation(true);
                    elements = translation.getElementsFromJsRange(translation.getJavaScriptOffset(textSelection.getOffset()), translation.getJavaScriptOffset(textSelection.getOffset() + textSelection.getLength()));
                }
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        if (elements == null) {
            elements = new IJavaScriptElement[]{};
        }
        return elements;
    }
}

