/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;

public class TypeDeclaration
extends AbstractTypeDeclaration {
    public static final ChildPropertyDescriptor JAVADOC_PROPERTY = TypeDeclaration.internalJavadocPropertyFactory(TypeDeclaration.class);
    public static final SimplePropertyDescriptor MODIFIERS_PROPERTY = TypeDeclaration.internalModifiersPropertyFactory(TypeDeclaration.class);
    public static final ChildListPropertyDescriptor MODIFIERS2_PROPERTY = TypeDeclaration.internalModifiers2PropertyFactory(TypeDeclaration.class);
    public static final ChildPropertyDescriptor NAME_PROPERTY = TypeDeclaration.internalNamePropertyFactory(TypeDeclaration.class);
    public static final ChildPropertyDescriptor SUPERCLASS_PROPERTY = new ChildPropertyDescriptor(TypeDeclaration.class, "superclass", Name.class, false, false);
    public static final ChildPropertyDescriptor SUPERCLASS_EXPRESSION_PROPERTY = new ChildPropertyDescriptor(TypeDeclaration.class, "superclassExpression", Expression.class, false, false);
    public static final ChildPropertyDescriptor SUPERCLASS_TYPE_PROPERTY = new ChildPropertyDescriptor(TypeDeclaration.class, "superclassType", Type.class, false, false);
    public static final ChildListPropertyDescriptor BODY_DECLARATIONS_PROPERTY = TypeDeclaration.internalBodyDeclarationPropertyFactory(TypeDeclaration.class);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;
    private Expression superclassExpression = null;
    private Type optionalSuperclassType = null;

    static {
        ArrayList propertyList = new ArrayList(8);
        TypeDeclaration.createPropertyList(TypeDeclaration.class, propertyList);
        TypeDeclaration.addProperty(JAVADOC_PROPERTY, propertyList);
        TypeDeclaration.addProperty(MODIFIERS_PROPERTY, propertyList);
        TypeDeclaration.addProperty(NAME_PROPERTY, propertyList);
        TypeDeclaration.addProperty(SUPERCLASS_PROPERTY, propertyList);
        TypeDeclaration.addProperty(BODY_DECLARATIONS_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = TypeDeclaration.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    TypeDeclaration(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return TypeDeclaration.propertyDescriptors(apiLevel);
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == MODIFIERS_PROPERTY) {
            if (get) {
                return this.getModifiers();
            }
            this.internalSetModifiers(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == JAVADOC_PROPERTY) {
            if (get) {
                return this.getJavadoc();
            }
            this.setJavadoc((JSdoc)child);
            return null;
        }
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((SimpleName)child);
            return null;
        }
        if (property == SUPERCLASS_PROPERTY) {
            if (get) {
                return this.getSuperclass();
            }
            this.setSuperclass((Name)child);
            return null;
        }
        if (property == SUPERCLASS_EXPRESSION_PROPERTY) {
            if (get) {
                return this.getSuperclassExpression();
            }
            this.setSuperclassExpression((Expression)child);
            return null;
        }
        if (property == SUPERCLASS_TYPE_PROPERTY) {
            if (get) {
                return this.getSuperclassType();
            }
            this.setSuperclassType((Type)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == MODIFIERS2_PROPERTY) {
            return this.modifiers();
        }
        if (property == BODY_DECLARATIONS_PROPERTY) {
            return this.bodyDeclarations();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ChildPropertyDescriptor internalJavadocProperty() {
        return JAVADOC_PROPERTY;
    }

    @Override
    final ChildListPropertyDescriptor internalModifiers2Property() {
        return MODIFIERS2_PROPERTY;
    }

    @Override
    final SimplePropertyDescriptor internalModifiersProperty() {
        return MODIFIERS_PROPERTY;
    }

    @Override
    final ChildPropertyDescriptor internalNameProperty() {
        return NAME_PROPERTY;
    }

    @Override
    final ChildListPropertyDescriptor internalBodyDeclarationsProperty() {
        return BODY_DECLARATIONS_PROPERTY;
    }

    @Override
    final int getNodeType0() {
        return 55;
    }

    @Override
    ASTNode clone0(AST target) {
        TypeDeclaration result = new TypeDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setJavadoc((JSdoc)ASTNode.copySubtree(target, this.getJavadoc()));
        result.setSuperclassExpression((Expression)ASTNode.copySubtree(target, this.getSuperclassExpression()));
        if (this.ast.apiLevel == 2) {
            result.internalSetModifiers(this.getModifiers());
        }
        result.setName((SimpleName)this.getName().clone(target));
        result.bodyDeclarations().addAll(ASTNode.copySubtrees(target, this.bodyDeclarations()));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getJavadoc());
            this.acceptChildren(visitor, this.modifiers);
            this.acceptChild(visitor, this.getName());
            this.acceptChild(visitor, this.getSuperclassExpression());
            this.acceptChildren(visitor, this.bodyDeclarations);
        }
        visitor.endVisit(this);
    }

    public Name getSuperclass() {
        return this.internalGetSuperclass();
    }

    final Name internalGetSuperclass() {
        return (Name)this.superclassExpression;
    }

    public Type getSuperclassType() {
        return this.optionalSuperclassType;
    }

    public void setSuperclass(Name superclassName) {
        this.internalSetSuperclass(superclassName);
    }

    public Expression getSuperclassExpression() {
        return this.superclassExpression;
    }

    public void setSuperclassExpression(Expression superclassExpression) {
        Expression oldChild = this.superclassExpression;
        this.preReplaceChild(oldChild, superclassExpression, SUPERCLASS_EXPRESSION_PROPERTY);
        this.superclassExpression = superclassExpression;
        this.postReplaceChild(oldChild, superclassExpression, SUPERCLASS_EXPRESSION_PROPERTY);
    }

    final void internalSetSuperclass(Name superclassName) {
        Expression oldChild = this.superclassExpression;
        this.preReplaceChild(oldChild, superclassName, SUPERCLASS_PROPERTY);
        this.superclassExpression = superclassName;
        this.postReplaceChild(oldChild, superclassName, SUPERCLASS_PROPERTY);
    }

    public void setSuperclassType(Type superclassType) {
        this.unsupportedIn2();
        Type oldChild = this.optionalSuperclassType;
        this.preReplaceChild(oldChild, superclassType, SUPERCLASS_TYPE_PROPERTY);
        this.optionalSuperclassType = superclassType;
        this.postReplaceChild(oldChild, superclassType, SUPERCLASS_TYPE_PROPERTY);
    }

    public FieldDeclaration[] getFields() {
        List bd = this.bodyDeclarations();
        int fieldCount = 0;
        ListIterator it = bd.listIterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof FieldDeclaration)) continue;
            ++fieldCount;
        }
        FieldDeclaration[] fields = new FieldDeclaration[fieldCount];
        int next = 0;
        ListIterator it2 = bd.listIterator();
        while (it2.hasNext()) {
            Object decl = it2.next();
            if (!(decl instanceof FieldDeclaration)) continue;
            fields[next++] = (FieldDeclaration)decl;
        }
        return fields;
    }

    public FunctionDeclaration[] getMethods() {
        List bd = this.bodyDeclarations();
        int methodCount = 0;
        ListIterator it = bd.listIterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof FunctionDeclaration)) continue;
            ++methodCount;
        }
        FunctionDeclaration[] methods = new FunctionDeclaration[methodCount];
        int next = 0;
        ListIterator it2 = bd.listIterator();
        while (it2.hasNext()) {
            Object decl = it2.next();
            if (!(decl instanceof FunctionDeclaration)) continue;
            methods[next++] = (FunctionDeclaration)decl;
        }
        return methods;
    }

    public TypeDeclaration[] getTypes() {
        List bd = this.bodyDeclarations();
        int typeCount = 0;
        ListIterator it = bd.listIterator();
        while (it.hasNext()) {
            if (!(it.next() instanceof TypeDeclaration)) continue;
            ++typeCount;
        }
        TypeDeclaration[] memberTypes = new TypeDeclaration[typeCount];
        int next = 0;
        ListIterator it2 = bd.listIterator();
        while (it2.hasNext()) {
            Object decl = it2.next();
            if (!(decl instanceof TypeDeclaration)) continue;
            memberTypes[next++] = (TypeDeclaration)decl;
        }
        return memberTypes;
    }

    @Override
    ITypeBinding internalResolveBinding() {
        return this.ast.getBindingResolver().resolveType(this);
    }

    @Override
    int memSize() {
        return super.memSize() + 24;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.optionalDocComment == null ? 0 : this.getJavadoc().treeSize()) + (this.modifiers == null ? 0 : this.modifiers.listSize()) + (this.typeName == null ? 0 : this.getName().treeSize()) + (this.superclassExpression == null ? 0 : this.getSuperclassExpression().treeSize()) + (this.optionalSuperclassType == null ? 0 : this.getSuperclassType().treeSize()) + this.bodyDeclarations.listSize();
    }
}

