/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.jsdt.chromium.internal.transport.LineReader;

public class Message {
    private static final Logger LOGGER = Logger.getLogger(Message.class.getName());
    private static final byte[] HEADER_TERMINATOR_BYTES = "\r\n".getBytes();
    private static byte[] FIELD_SEPARATOR_BYTES = ":".getBytes();
    private static final String CONTENT_LENGTH = "Content-Length";
    private final HashMap<String, String> headers;
    private final String content;
    private static final Charset TO_STRING_CHARSET = Charset.forName("UTF-8");

    public Message(Map<String, String> headers, String content) {
        this.headers = new HashMap<String, String>(headers);
        this.content = content;
    }

    public void sendThrough(OutputStream outputStream, Charset charset) throws IOException {
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            String headerValue = entry.getValue();
            if (headerValue == null) break;
            Message.writeHeaderField(entry.getKey(), headerValue, outputStream, charset);
        }
        String content = Message.maskNull(this.content);
        byte[] contentBytes = content.getBytes(charset);
        Message.writeHeaderField(CONTENT_LENGTH, String.valueOf(contentBytes.length), outputStream, charset);
        outputStream.write(HEADER_TERMINATOR_BYTES);
        outputStream.write(contentBytes);
    }

    public static Message fromBufferedReader(LineReader reader, Charset charset) throws IOException, MalformedMessageException {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        String contentLengthValue = null;
        while (true) {
            String line;
            if ((line = reader.readLine(charset)) == null) {
                LOGGER.fine("End of stream");
                return null;
            }
            if (line.length() == 0) break;
            int semiColonPos = line.indexOf(58);
            if (semiColonPos == -1) {
                LOGGER.log(Level.SEVERE, "Bad header line: {0}", line);
                return null;
            }
            String name = line.substring(0, semiColonPos);
            String value = line.substring(semiColonPos + 1);
            String trimmedValue = value.trim();
            if (CONTENT_LENGTH.equals(name)) {
                contentLengthValue = trimmedValue;
                continue;
            }
            headers.put(name, trimmedValue);
        }
        int contentLength = Integer.valueOf(contentLengthValue.trim());
        byte[] contentBytes = new byte[contentLength];
        int totalRead = 0;
        LOGGER.log(Level.FINER, "Reading payload: {0} bytes", contentLength);
        while (totalRead < contentLength) {
            int readBytes = reader.read(contentBytes, totalRead, contentLength - totalRead);
            if (readBytes == -1) {
                LOGGER.fine("End of stream while reading content");
                return null;
            }
            totalRead += readBytes;
        }
        String contentString = new String(contentBytes, charset);
        return new Message(headers, contentString);
    }

    public String getTool() {
        return this.getHeader(Header.TOOL.name, null);
    }

    public String getDestination() {
        return this.getHeader(Header.DESTINATION.name, null);
    }

    public String getContent() {
        return this.content;
    }

    public String getHeader(String name, String defaultValue) {
        return Message.getHeader(this.headers, name, defaultValue);
    }

    private static String getHeader(Map<? extends String, String> headers, String headerName, String defaultValue) {
        String value = headers.get(headerName);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private static String maskNull(String string) {
        return string == null ? "" : string;
    }

    public String toString() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            this.sendThrough(stream, TO_STRING_CHARSET);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new String(stream.toByteArray(), TO_STRING_CHARSET);
    }

    private static void writeHeaderField(String name, String value, OutputStream outputStream, Charset charset) throws IOException {
        outputStream.write(name.getBytes(charset));
        outputStream.write(FIELD_SEPARATOR_BYTES);
        outputStream.write(value.getBytes(charset));
        outputStream.write(HEADER_TERMINATOR_BYTES);
    }

    public static enum Header {
        TOOL("Tool"),
        DESTINATION("Destination");

        public final String name;

        private Header(String value) {
            this.name = value;
        }
    }

    public static class MalformedMessageException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MalformedMessageException() {
        }

        public MalformedMessageException(String message) {
            super(message);
        }

        public MalformedMessageException(Throwable cause) {
            super(cause);
        }

        public MalformedMessageException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

