/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.delete;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sirius.business.internal.helper.delete.IDeleteHookDescriptor;

public final class DeleteHookDescriptorRegistry {
    private static final List<IDeleteHookDescriptor> EXTENSIONS = new ArrayList<IDeleteHookDescriptor>();
    private static final Map<String, IDeleteHookDescriptor> ID_TO_DESCRITPOR_MAP = new HashMap<String, IDeleteHookDescriptor>();

    private DeleteHookDescriptorRegistry() {
    }

    public static void addExtension(IDeleteHookDescriptor extension) {
        EXTENSIONS.add(extension);
        ID_TO_DESCRITPOR_MAP.put(extension.getId(), extension);
    }

    public static void clearRegistry() {
        EXTENSIONS.clear();
        ID_TO_DESCRITPOR_MAP.clear();
    }

    public static List<IDeleteHookDescriptor> getRegisteredExtensions() {
        return new ArrayList<IDeleteHookDescriptor>(EXTENSIONS);
    }

    public static void removeExtension(String id) {
        for (IDeleteHookDescriptor extension : DeleteHookDescriptorRegistry.getRegisteredExtensions()) {
            if (!extension.getId().equals(id)) continue;
            EXTENSIONS.remove(extension);
            ID_TO_DESCRITPOR_MAP.remove(extension.getId());
        }
    }

    public static IDeleteHookDescriptor getDescriptorFromId(String id) {
        return ID_TO_DESCRITPOR_MAP.get(id);
    }
}

