/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.interpreter.internal.view.listener;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.ui.interpreter.internal.view.InterpreterView;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class NotifierSelectionListener
implements ISelectionListener {
    private final InterpreterView view;

    public NotifierSelectionListener(InterpreterView view) {
        this.view = view;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && part != this.view) {
            boolean cleared = false;
            for (Object next : (IStructuredSelection)selection) {
                Notifier adaptedNotifier;
                Notifier nextNotifier = next instanceof Notifier ? (Notifier)next : ((adaptedNotifier = this.adaptAs(next, Notifier.class)) != null ? adaptedNotifier : (Notifier)this.adaptAs(next, EObject.class));
                if (nextNotifier == null) continue;
                if (!cleared) {
                    this.view.clearSelection();
                    cleared = true;
                }
                this.view.addToSelection(nextNotifier);
            }
            if (cleared && this.view.getRealTimeThread() != null) {
                this.view.getRealTimeThread().setDirty();
            }
        }
    }

    private <T> T adaptAs(Object object, Class<T> clazz) {
        if (object instanceof IAdaptable) {
            return (T)((IAdaptable)object).getAdapter(clazz);
        }
        return (T)Platform.getAdapterManager().getAdapter(object, clazz);
    }
}

