/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.environment;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.s2e.environment.IWorkingCopyManager;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public final class WorkingCopyManager
implements IWorkingCopyManager {
    private static final ThreadLocal<IWorkingCopyManager> CURRENT = ThreadLocal.withInitial(() -> null);
    private final Set<ICompilationUnit> m_workingCopies = new LinkedHashSet<ICompilationUnit>();
    private volatile boolean m_open = true;

    public static IWorkingCopyManager currentWorkingCopyManager() {
        return (IWorkingCopyManager)Ensure.notNull((Object)CURRENT.get(), (CharSequence)"No working-copy-manager available in the current context.", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithWorkingCopyManager(Runnable r, Supplier<IProgressMonitor> monitorSupplier) {
        Ensure.notNull((Object)r);
        Ensure.notNull(monitorSupplier);
        WorkingCopyManager wcm = new WorkingCopyManager();
        boolean save = false;
        try {
            WorkingCopyManager.runWithWorkingCopyManager(r, wcm);
            save = true;
        }
        finally {
            wcm.unregisterAll(save, monitorSupplier.get());
        }
    }

    static void runWithWorkingCopyManager(Runnable r, IWorkingCopyManager wcm) {
        CoreUtils.callInContext(CURRENT, (Object)wcm, () -> {
            r.run();
            return null;
        });
    }

    private WorkingCopyManager() {
    }

    @Override
    public synchronized boolean register(ICompilationUnit icu, IProgressMonitor monitor) throws JavaModelException {
        this.ensureOpen();
        if (!this.m_workingCopies.contains(icu)) {
            icu.becomeWorkingCopy(monitor);
            this.m_workingCopies.add(icu);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean checkpoint(IProgressMonitor monitor) {
        return this.unregisterAllImpl(true, monitor);
    }

    synchronized void unregisterAll(boolean save, IProgressMonitor monitor) {
        try {
            this.unregisterAllImpl(save, monitor);
        }
        finally {
            this.m_open = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unregisterAllImpl(boolean save, IProgressMonitor monitor) {
        this.ensureOpen();
        try {
            IStatus result;
            Collection resourcesToSave;
            boolean tryToSave;
            boolean bl = tryToSave = save && (monitor == null || !monitor.isCanceled());
            if (tryToSave && !(resourcesToSave = (Collection)this.m_workingCopies.stream().map(IJavaElement::getResource).collect(Collectors.toList())).isEmpty() && !(result = S2eUtils.makeCommittable(resourcesToSave)).isOK()) {
                tryToSave = false;
                SdkLog.info((CharSequence)"Unable to make all resources committable. Save will be skipped.", (Object[])new Object[]{new CoreException(result)});
            }
            for (ICompilationUnit icu : this.m_workingCopies) {
                WorkingCopyManager.releaseCompilationUnit(icu, monitor, tryToSave);
            }
            boolean bl2 = tryToSave;
            return bl2;
        }
        finally {
            this.m_workingCopies.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void releaseCompilationUnit(ICompilationUnit icu, IProgressMonitor monitor, boolean tryToSave) {
        block11: {
            block10: {
                if (!tryToSave) break block10;
                icu.commitWorkingCopy(true, monitor);
            }
            try {
                icu.discardWorkingCopy();
            }
            catch (JavaModelException e) {
                SdkLog.warning((CharSequence)"Unable to discard working copy '{}'.", (Object[])new Object[]{icu.getElementName(), e});
            }
            break block11;
            catch (RuntimeException | JavaModelException e) {
                try {
                    SdkLog.warning((CharSequence)"Unable to commit working copy '{}'.", (Object[])new Object[]{icu.getElementName(), e});
                }
                catch (Throwable throwable) {
                    try {
                        icu.discardWorkingCopy();
                    }
                    catch (JavaModelException e2) {
                        SdkLog.warning((CharSequence)"Unable to discard working copy '{}'.", (Object[])new Object[]{icu.getElementName(), e2});
                    }
                    throw throwable;
                }
                try {
                    icu.discardWorkingCopy();
                }
                catch (JavaModelException e3) {
                    SdkLog.warning((CharSequence)"Unable to discard working copy '{}'.", (Object[])new Object[]{icu.getElementName(), e3});
                }
            }
        }
    }

    @Override
    public synchronized void reconcile(ICompilationUnit icu, IProgressMonitor monitor) throws JavaModelException {
        this.ensureOpen();
        if (!this.m_workingCopies.contains(icu)) {
            throw Ensure.newFail((CharSequence)"compilation unit {} has not been registered", (Object[])new Object[]{icu.getElementName()});
        }
        icu.reconcile(0, true, icu.getOwner(), monitor);
    }

    @Override
    public int size() {
        return this.m_workingCopies.size();
    }

    private void ensureOpen() {
        Ensure.isTrue((boolean)this.isOpen(), (CharSequence)"{} has already been committed/discarded. No more changes are allowed.", (Object[])new Object[]{this.getClass().getName()});
    }

    boolean isOpen() {
        return this.m_open;
    }
}

