/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.launch;

import jakarta.inject.Inject;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.php.composer.core.launch.ExecutableNotFoundException;
import org.eclipse.php.composer.core.launch.Messages;
import org.eclipse.php.composer.core.launch.ScriptLauncher;
import org.eclipse.php.composer.core.launch.ScriptLauncherInterface;
import org.eclipse.php.composer.core.launch.ScriptNotFoundException;
import org.eclipse.php.composer.core.launch.environment.Environment;
import org.eclipse.php.composer.core.launch.environment.EnvironmentFactory;
import org.eclipse.php.composer.core.log.Logger;

@Creatable
public class ScriptLauncherManager
implements ScriptLauncherInterface {
    private static final String LAUNCHER_ID = "org.eclipse.php.composer.core.executableLauncher";
    private final HashMap<String, EnvironmentFactory> factories = new HashMap();

    @Inject
    public ScriptLauncherManager(IExtensionRegistry registry) {
        this.evaluate(registry);
    }

    private void evaluate(IExtensionRegistry registry) {
        try {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = registry.getConfigurationElementsFor(LAUNCHER_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                EnvironmentFactory factory = (EnvironmentFactory)e.createExecutableExtension("class");
                if (factory != null) {
                    this.factories.put(e.getAttribute("id"), factory);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    private Environment getEnvironment(String factoryId, IProject project) throws ExecutableNotFoundException {
        if (!this.factories.containsKey(factoryId)) {
            return null;
        }
        return this.factories.get(factoryId).getEnvironment(project);
    }

    @Override
    public ScriptLauncher getLauncher(String factoryId, IProject project) throws ScriptNotFoundException, ExecutableNotFoundException {
        Environment env = this.getEnvironment(factoryId, project);
        if (env == null) {
            throw new ExecutableNotFoundException(Messages.ScriptLauncherManager_CannotFindExe);
        }
        return new ScriptLauncher(env, project);
    }

    @Override
    public void resetEnvironment() {
    }
}

